/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.Token;
import java.io.IOException;

public class LoginAckToken
extends Token {
    protected int _status;
    protected byte[] _tdsVers = null;
    protected String _progName = null;
    protected byte[] _progVers = null;

    protected LoginAckToken() {
    }

    public LoginAckToken(TdsInputStream tdsInputStream) throws IOException {
        int n = tdsInputStream.readShort();
        this._status = tdsInputStream.readUnsignedByte();
        this._tdsVers = new byte[4];
        tdsInputStream.read(this._tdsVers);
        n = tdsInputStream.readUnsignedByte();
        this._progName = tdsInputStream.readString(n);
        this._progVers = new byte[4];
        tdsInputStream.read(this._progVers);
    }

    protected boolean tdsVersionOK() {
        return this._tdsVers != null && this._tdsVers[0] >= 5;
    }

    protected String getTdsVersionString() {
        return LoginAckToken.makeVersionString(this._tdsVers);
    }

    protected int getLoginStatus() {
        return this._status;
    }

    protected boolean loginOK() {
        boolean bl = false;
        String string = "UNRECOGNIZED STATUS";
        switch (this._status) {
            case 5: 
            case 133: {
                string = "SUCCEED";
                bl = true;
                break;
            }
            case 7: 
            case 135: {
                string = "NEGOTIATE";
                bl = true;
                break;
            }
            case 6: 
            case 134: {
                string = "LOG_FAIL";
                break;
            }
        }
        return bl;
    }

    public static String makeVersionString(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            return null;
        }
        return byArray[0] + "." + byArray[1] + "." + byArray[2] + "." + byArray[3];
    }
}

