/*
 * Decompiled with CFR 0.152.
 */
package nosqlite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import nosqlite.handlers.WatchData;
import nosqlite.handlers.WatchHandler;
import nosqlite.utilities.Rewriter;
import nosqlite.utilities.Utils;
import org.sqlite.Function;

class DbHelper {
    Connection conn;
    private final BlockingDeque<Task> tasks = new LinkedBlockingDeque<Task>();
    private final Map<String, List<WatchHandler>> watchers = new HashMap<String, List<WatchHandler>>();
    private final Map<String, Map<String, List<WatchHandler>>> eventWatchers = new HashMap<String, Map<String, List<WatchHandler>>>();
    private AtomicBoolean isRunning = new AtomicBoolean(true);
    private boolean runAsync;
    private boolean useRegex;
    private final ObjectMapper mapper = new ObjectMapper();
    ThreadPoolExecutor watchExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(5);

    DbHelper(Connection conn, boolean useRegex, boolean runAsync) throws SQLException {
        this.conn = conn;
        this.runAsync = runAsync;
        this.useRegex = useRegex;
        if (useRegex) {
            this.addRegex(conn);
        }
        if (runAsync) {
            new Thread(() -> {
                while (this.isRunning.get() || !this.tasks.isEmpty()) {
                    try {
                        String[] future;
                        Task task = this.tasks.take();
                        if (task.method.equals("queryMany")) {
                            future = new String[]{"insert", this.queryMany(task.query, task.params, task.coll, task.collName)};
                            task.future.complete(future);
                            continue;
                        }
                        future = new String[]{task.method, this.query(task.query, task.params, task.collName)};
                        task.future.complete(future);
                    }
                    catch (InterruptedException | SQLException e) {
                        e.printStackTrace();
                    }
                }
                this.watchExecutor.shutdown();
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }).start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    void close() {
        this.isRunning.set(false);
        if (!this.runAsync) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    <T> String run(String method, String query, Object[] params, Class<T> coll, String collName) {
        String[] get = new String[2];
        if (this.runAsync) {
            CompletableFuture<String[]> future = new CompletableFuture<String[]>();
            this.tasks.add(new Task<T>(method, query, params, coll, collName, future));
            try {
                get = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (method.equals("queryMany")) {
                    get[0] = "insert";
                    get[1] = this.queryMany(query, params, coll, collName);
                } else {
                    get[0] = method;
                    get[1] = this.query(query, params, collName);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!query.startsWith("CREATE")) {
            if (!(method.equals("none") || get[1] == null || get[1].equals("deleted") || get[1].endsWith("all") || this.eventWatchers.get(collName) == null && this.watchers.get(collName) == null)) {
                if (!get[1].startsWith("[")) {
                    get[1] = "[" + get[1] + "]";
                }
                this.updateWatchers(collName, get[0], get[1], coll);
            }
            return get[1];
        }
        return null;
    }

    <T> String run(String method, String query, Class<T> coll, String collName) {
        return this.run(method, query, null, coll, collName);
    }

    private String query(String query, Object[] params, String collName) throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement(query);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Utils.setParams(i + 1, params[i], stmt);
            }
        }
        if (query.startsWith("DROP") || query.startsWith("DELETE")) {
            stmt.executeUpdate();
            return "deleted";
        }
        stmt.executeUpdate();
        if (params == null) {
            return null;
        }
        if (query.startsWith("INSERT")) {
            Object[] id = new Object[]{params[0]};
            return this.get("SELECT value FROM " + collName + " WHERE key = ?", id);
        }
        if (query.startsWith("CREATE")) {
            return "created";
        }
        if (params.length > 2) {
            String where = " " + query.substring(query.indexOf("WHERE"));
            Object[] p = new Object[params.length - 2];
            for (int i = 2; i < params.length; ++i) {
                p[i - 2] = params[i];
            }
            return this.get("SELECT value FROM " + collName + where, p);
        }
        return "updated all";
    }

    String get(String query) {
        return this.get(query, null);
    }

    String get(String query, Object[] params) {
        try {
            PreparedStatement stmt = this.conn.prepareStatement(query);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Utils.setParams(i + 1, params[i], stmt);
                }
            }
            ResultSet rs = stmt.executeQuery();
            return rs.getString(1);
        }
        catch (SQLException e) {
            if (!e.getMessage().equals("ResultSet closed")) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> String queryMany(String query, Object[] documents, Class<T> coll, String collName) {
        ArrayList<String> docs = new ArrayList<String>();
        ArrayList<String> jsonDocs = new ArrayList<String>();
        boolean isJson = false;
        if (documents[0] instanceof String) {
            Object[] params = new Object[]{documents[0]};
            isJson = this.get("SELECT json_valid(?)", params).equals("1");
        }
        try {
            this.conn.setAutoCommit(false);
            PreparedStatement stmt = this.conn.prepareStatement(query);
            if (isJson) {
                for (Object model : documents) {
                    String json = (String)model;
                    String idField = "_id";
                    if (coll != null) {
                        try {
                            idField = Utils.getIdField(coll.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).get("name");
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    Object[] jsonParams = new Object[]{json, "$." + idField};
                    String jsonId = this.get("SELECT json_extract(json(?), ?)", jsonParams);
                    docs.add(json);
                    jsonDocs.add(json);
                    stmt.setString(1, jsonId);
                    stmt.setString(2, json);
                    stmt.executeUpdate();
                }
            } else {
                for (Object model : documents) {
                    Map<String, String> field = Utils.getIdField(model);
                    String json = this.mapper.writeValueAsString(model);
                    docs.add(json);
                    jsonDocs.add(json);
                    stmt.setString(1, field.get("id"));
                    stmt.setString(2, json);
                    stmt.executeUpdate();
                }
            }
            this.conn.commit();
            stmt.close();
            if (this.eventWatchers.get(collName) != null || this.watchers.get(collName) != null) {
                this.updateWatchers(collName, "insert", ((Object)docs).toString(), coll);
            }
            String string = "[" + String.join((CharSequence)",", jsonDocs) + "]";
            return string;
        }
        catch (JsonProcessingException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String findAsJson(String collName, String filter, Object[] params, int limit) {
        Map<String, List<String>> filters = this.generateWhereClause(filter);
        String q = String.format("SELECT GROUP_CONCAT(value) FROM (SELECT value FROM %1$s" + filters.get("query").get(0) + (limit == 0 ? ")" : " LIMIT %2$d)"), collName, limit);
        return this.get(q, params);
    }

    String findAsJson(String collName, String filter, String sort, int limit, int offset) {
        String orderBy = "";
        String[] order = new String[2];
        if (sort != null) {
            if (sort.endsWith("<")) {
                order[0] = "$." + sort.substring(0, sort.length() - 1);
                order[1] = "ASC";
            } else if (sort.endsWith(">")) {
                order[0] = "$." + sort.substring(0, sort.length() - 1);
                order[1] = "DESC";
            } else {
                order = sort.split("==|=");
                order[0] = "$." + order[0];
            }
            orderBy = " ORDER BY json_extract(value, ?) " + order[1];
        }
        if (filter == null) {
            String q = String.format("SELECT GROUP_CONCAT(value) FROM (SELECT value FROM %1$s" + orderBy + (limit == 0 ? ")" : " LIMIT %2$d OFFSET %3$d)"), collName, limit, offset);
            if (sort != null) {
                Object[] params = new Object[]{order[0]};
                return this.get(q, params);
            }
            return this.get(q);
        }
        Map<String, List<String>> filters = this.generateWhereClause(filter);
        String q = String.format("SELECT GROUP_CONCAT(value) FROM (SELECT value FROM %1$s" + filters.get("query").get(0) + orderBy + (limit == 0 ? ")" : " LIMIT %2$d OFFSET %3$d)"), collName, limit, offset);
        List params = this.populateParams(filters);
        if (sort != null) {
            params.add(order[0]);
        }
        return this.get(q, params.toArray());
    }

    String deleteDocs(String collName, String filter, int limit, Class klass) {
        String deleted;
        String deletedDocs;
        if (filter == null) {
            return this.run("delete", String.format("DELETE FROM %1$s", collName), klass, collName);
        }
        Map<String, List<String>> filters = this.generateWhereClause(filter);
        String q = limit == 0 ? String.format("DELETE FROM %1$s" + filters.get("query").get(0), collName) : String.format("DELETE FROM %1$s WHERE %1$s.key = (SELECT %1$s.key FROM %1$s" + filters.get("query").get(0) + " LIMIT %2$d)", collName, limit);
        List params = this.populateParams(filters);
        if (filter.startsWith("key=")) {
            Object[] param = new Object[]{params.get(1)};
            deletedDocs = this.get("SELECT value FROM " + collName + " WHERE key = ?", param);
            deleted = this.run("delete", "DELETE FROM " + collName + " WHERE key = ?", param, klass, collName);
        } else {
            deletedDocs = this.findAsJson(collName, filter, params.toArray(), limit);
            deleted = this.run("delete", q, params.toArray(), klass, collName);
        }
        deletedDocs = "[" + deletedDocs + "]";
        if (deleted.equals("deleted") && (this.eventWatchers.get(collName) != null || this.watchers.get(collName) != null)) {
            this.updateWatchers(collName, "delete", deletedDocs, klass);
        }
        return deletedDocs;
    }

    void watch(String collName, WatchHandler watcher) {
        this.watchers.putIfAbsent(collName, new ArrayList());
        this.watchers.get(collName).add(watcher);
    }

    void watch(String collName, String event, WatchHandler watcher) {
        this.eventWatchers.putIfAbsent(collName, new HashMap());
        this.eventWatchers.get(collName).putIfAbsent(event.toLowerCase(), new ArrayList());
        this.eventWatchers.get(collName).get(event.toLowerCase()).add(watcher);
    }

    void updateWatchers(String collName, String event, String docs, Class coll) {
        if (event.equals("none")) {
            return;
        }
        WatchData watchData = null;
        if (!this.runAsync) {
            try {
                watchData = new WatchData(collName, event, (List)this.mapper.readValue(docs, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, coll)));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        if (this.eventWatchers.get(collName) != null && this.eventWatchers.get(collName).get(event) != null) {
            if (this.runAsync) {
                this.watchExecutor.submit(() -> {
                    WatchData watchDataAsync = null;
                    try {
                        watchDataAsync = new WatchData(collName, event, (List)this.mapper.readValue(docs, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, coll)));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                    WatchData finalWatchDataAsync = watchDataAsync;
                    this.eventWatchers.get(collName).get(event).forEach(w -> w.handle(finalWatchDataAsync));
                });
            } else {
                WatchData finalWatchData = watchData;
                this.eventWatchers.get(collName).get(event).forEach(w -> w.handle(finalWatchData));
            }
        }
        if (this.watchers.get(collName) != null) {
            if (this.runAsync) {
                this.watchExecutor.submit(() -> {
                    WatchData watchDataAsync = null;
                    try {
                        watchDataAsync = new WatchData(collName, event, (List)this.mapper.readValue(docs, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, coll)));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                    WatchData finalWatchDataAsync = watchDataAsync;
                    this.watchers.get(collName).forEach(w -> w.handle(finalWatchDataAsync));
                });
            } else {
                WatchData finalWatchData1 = watchData;
                this.watchers.get(collName).forEach(w -> w.handle(finalWatchData1));
            }
        }
    }

    private void addRegex(Connection conn) throws SQLException {
        Function.create(conn, "REGEXP", new Function(){

            @Override
            protected void xFunc() throws SQLException {
                Pattern pattern;
                String expression = this.value_text(0);
                String value = this.value_text(1);
                if (value == null) {
                    value = "";
                }
                this.result((pattern = Pattern.compile(expression)).matcher(value).find() ? 1 : 0);
            }
        });
    }

    List populateParams(Map<String, List<String>> filters) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < filters.get("paths").size(); ++i) {
            params.add(filters.get("paths").get(i));
            String[] inValues = new String[]{filters.get("values").get(i)};
            if (inValues[0].startsWith("[") && inValues[0].endsWith("]")) {
                inValues[0] = inValues[0].replaceAll("^\\[", "").replaceAll("]$", "");
                inValues = inValues[0].split(",");
            }
            for (String value : inValues) {
                if (Utils.isNumeric(value)) {
                    if (value.contains(".")) {
                        try {
                            params.add(Double.parseDouble(value));
                        }
                        catch (Exception tryFloat) {
                            try {
                                params.add(Float.valueOf(Float.parseFloat(value)));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
                    try {
                        params.add(Integer.parseInt(value));
                    }
                    catch (Exception tryLong) {
                        try {
                            params.add(Long.parseLong(value));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                params.add(value);
            }
        }
        return params;
    }

    Map<String, List<String>> generateWhereClause(String filter) {
        final ArrayList paths = new ArrayList();
        final ArrayList values = new ArrayList();
        String regex = "(\\s*\\!\\s*)?([\\(\\w\\s\\.\\[\\]]+)\\s*(~~|=~|==|>=|<=|!=|<|>|=)\\s*(([!-%'-{\\}\u00a3~\\s\u00e5\u00e4\u00f6\u00c5\u00c4\u00d6]*\\|{0,1}\\&{0,1}[!-%'-{\\}\u00a3~\\s\u00e5\u00e4\u00f6\u00c5\u00c4\u00d6])*(?<!\\|))(&&|\\|\\|)?";
        String query = " WHERE" + new Rewriter(regex){

            @Override
            public String replacement() {
                String comparator;
                boolean isRegex = this.group(3).equals("~~");
                String path = this.group(2).replace(" ", "");
                String startParam = "";
                if (this.group(1) != null && this.group(1).trim().equals("!")) {
                    startParam = " NOT ";
                }
                if (path.startsWith("(")) {
                    startParam = startParam + "(";
                    path = path.replaceAll("^\\(", "");
                }
                paths.add("$." + path);
                String val = this.group(4).trim();
                if ((this.group(3).equals("==") || this.group(3).equals("=")) && val.startsWith("[") && val.endsWith("]")) {
                    val = val.replace(" ", "");
                    String[] inValues = val.split(",");
                    comparator = " IN (";
                    for (String in : inValues) {
                        comparator = comparator + "?,";
                    }
                    comparator = comparator.replaceAll(",$", ")");
                } else {
                    comparator = this.group(3).equals("=~") ? "LIKE ?" : (isRegex ? "REGEXP ?" : this.group(3) + " ?");
                }
                if (!isRegex && val.endsWith(")")) {
                    comparator = comparator + ")";
                    val = val.replaceAll("\\s*\\)$", "");
                }
                values.add(val);
                String andOr = this.group(6) == null ? "" : (this.group(6).equals("&&") ? "AND" : "OR");
                return String.format(startParam + " json_extract(value, ?) %s %s", comparator, andOr);
            }
        }.rewrite(filter);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("query", Collections.singletonList(query));
        map.put("paths", paths);
        map.put("values", values);
        return map;
    }

    private class Task<T> {
        String method;
        String query;
        Object[] params;
        Class<T> coll;
        String collName;
        CompletableFuture<String[]> future;

        public Task(String method, String query, Object[] params, Class<T> coll, String collName, CompletableFuture<String[]> future) {
            this.method = method;
            this.query = query;
            this.params = params;
            this.coll = coll;
            this.collName = collName;
            this.future = future;
        }
    }
}

