/*
 * Decompiled with CFR 0.152.
 */
package nosqlite.utilities;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nosqlite.annotations.Id;

public abstract class Utils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> T resultSetToObject(ResultSet rs, Class<T> klass) throws SQLException, JsonProcessingException {
        String json = Utils.resultSetToJson(rs);
        if (json == null) {
            return null;
        }
        return mapper.readValue(json, klass);
    }

    public static String resultSetToJson(ResultSet rs) throws SQLException, JsonProcessingException {
        ArrayList rows = new ArrayList();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                String colName = rsmd.getColumnName(i);
                Object colVal = rs.getObject(i);
                row.put(colName, colVal);
            }
            rows.add(row);
        }
        return mapper.writeValueAsString(rows);
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        char[] data = str.toCharArray();
        if (data.length <= 0) {
            return false;
        }
        int index = 0;
        if ((data[0] == '-' || data[0] == '+') && data.length > 1) {
            index = 1;
        }
        while (index < data.length) {
            if (data[index] >= '.' && (data[index] < '0' || data[index] > '9')) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static void setParams(int index, Object param, PreparedStatement stmt) throws SQLException {
        if (param == null) {
            stmt.setNull(index, 0);
        } else if (param instanceof String) {
            stmt.setString(index, (String)param);
        } else if (param instanceof Integer) {
            stmt.setInt(index, (Integer)param);
        } else if (param instanceof Double) {
            stmt.setDouble(index, (Double)param);
        } else if (param instanceof Float) {
            stmt.setFloat(index, ((Float)param).floatValue());
        } else if (param instanceof Long) {
            stmt.setLong(index, (Long)param);
        } else if (param instanceof Blob) {
            stmt.setBlob(index, (Blob)param);
        } else if (param instanceof Byte) {
            stmt.setByte(index, (Byte)param);
        } else if (param instanceof byte[]) {
            stmt.setBytes(index, (byte[])param);
        } else if (param instanceof InputStream) {
            stmt.setBlob(index, (InputStream)param);
        } else if (param instanceof Boolean) {
            stmt.setBoolean(index, (Boolean)param);
        } else if (param instanceof Short) {
            stmt.setShort(index, (Short)param);
        } else if (param instanceof Timestamp) {
            stmt.setTimestamp(index, (Timestamp)param);
        } else if (param instanceof URL) {
            stmt.setURL(index, (URL)param);
        } else {
            stmt.setObject(index, param);
        }
    }

    public static Map<String, String> getIdField(Object model) {
        HashMap<String, String> idValues = new HashMap<String, String>();
        if (model instanceof Map) {
            idValues.put("name", "_id");
            idValues.put("id", NanoIdUtils.randomNanoId());
            return idValues;
        }
        try {
            for (Field field : model.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                field.setAccessible(true);
                if (field.get(model) == null) {
                    field.set(model, NanoIdUtils.randomNanoId());
                }
                idValues.put("name", field.getName());
                idValues.put("id", (String)field.get(model));
                break;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return idValues;
    }
}

