/*
 * Decompiled with CFR 0.152.
 */
package com.fm.openinstall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fm.openinstall.Configuration;
import com.fm.openinstall.OpenInstallHelper;
import com.fm.openinstall.SharePlatform;
import com.fm.openinstall.listener.AppInstallListener;
import com.fm.openinstall.listener.AppInstallRetryAdapter;
import com.fm.openinstall.listener.AppWakeUpListener;
import com.fm.openinstall.listener.ResultCallback;
import com.fm.openinstall.model.Error;
import io.openinstall.sdk.a;
import io.openinstall.sdk.as;
import io.openinstall.sdk.et;
import io.openinstall.sdk.ft;
import io.openinstall.sdk.fv;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class OpenInstall {
    private static volatile boolean a = false;
    private static volatile boolean b = false;

    private OpenInstall() {
    }

    @NonNull
    public static String getVersion() {
        return "2.8.5";
    }

    @Nullable
    public static String getOpid() {
        if (!OpenInstall.a()) {
            return null;
        }
        return io.openinstall.sdk.a.a().b();
    }

    public static void preInit(@NonNull Context context) {
        String string = ft.a(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("\u8bf7\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eOpenInstall\u63d0\u4f9b\u7684AppKey");
        }
        OpenInstall.preInit(context, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInit(@NonNull Context context, @NonNull String appKey) {
        if (context == null) {
            throw new IllegalArgumentException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            throw new IllegalArgumentException("\u8bf7\u524d\u5f80OpenInstall\u63a7\u5236\u53f0\u7684 \u201cAndroid\u96c6\u6210\u201d -> \u201cAndroid\u5e94\u7528\u914d\u7f6e\u201d \u4e2d\u83b7\u53d6AppKey");
        }
        if (fv.a) {
            fv.a("SDK Version : " + OpenInstall.getVersion(), new Object[0]);
        }
        as.a().a(context.getApplicationContext());
        as.a().a(appKey);
        Class<OpenInstall> clazz = OpenInstall.class;
        synchronized (OpenInstall.class) {
            if (!a) {
                io.openinstall.sdk.a.a().c();
                a = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void init(@NonNull Context context) {
        OpenInstall.init(context, Configuration.getDefault());
    }

    public static void init(@NonNull Context context, @NonNull String appKey) {
        OpenInstall.init(context, appKey, Configuration.getDefault());
    }

    public static void init(@NonNull Context context, @Nullable Configuration configuration) {
        String string = ft.a(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("\u8bf7\u5728AndroidManifest.xml\u4e2d\u914d\u7f6eOpenInstall\u63d0\u4f9b\u7684AppKey");
        }
        OpenInstall.init(context, string, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(@NonNull Context context, @NonNull String appKey, @Nullable Configuration configuration) {
        Object object;
        long l2 = System.currentTimeMillis();
        WeakReference<Activity> weakReference = null;
        if (context instanceof Activity) {
            object = (Activity)context;
            weakReference = new WeakReference<Activity>((Activity)object);
        }
        object = OpenInstall.class;
        synchronized (OpenInstall.class) {
            if (!a) {
                if (fv.a) {
                    fv.b("\u672a\u63d0\u524d\u8c03\u7528 preInit\uff0c\u53ef\u80fd\u5bfc\u81f4\u7edf\u8ba1\u6570\u636e\u4e0d\u51c6\u786e\u3002", new Object[0]);
                }
                OpenInstall.preInit(context, appKey);
            }
            if (!b) {
                io.openinstall.sdk.a.a().a(configuration, weakReference, l2);
                b = true;
            }
            // ** MonitorExit[var6_5 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    public static void setChannel(String channel) {
        as.a().b(channel);
    }

    public static void setDebug(boolean debug) {
        fv.a = debug;
    }

    public static void clipBoardEnabled(boolean enabled) {
        as.a().a(enabled);
    }

    public static void setTrackData(@Nullable ClipData trackData) {
        as.a().a(trackData);
        as.a().a(false);
    }

    @Deprecated
    public static void serialEnabled(boolean enabled) {
        as.a().b(enabled);
    }

    public static boolean getWakeUp(@Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            return false;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            io.openinstall.sdk.a.a().a(intent, appWakeUpListener);
            return true;
        }
        return false;
    }

    public static void getWakeUpAlwaysCallback(@Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            appWakeUpListener.onWakeUpFinish(null, Error.fromInner(et.a.a));
            return;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            io.openinstall.sdk.a.a().a(intent, appWakeUpListener);
            return;
        }
        appWakeUpListener.onWakeUpFinish(null, Error.fromInner(et.a.g));
    }

    public static boolean getWakeUpYYB(@NonNull Activity activity, @Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            return false;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            io.openinstall.sdk.a.a().a(intent, appWakeUpListener);
            return true;
        }
        if (OpenInstallHelper.isLauncherFromYYB(activity, intent)) {
            io.openinstall.sdk.a.a().a(appWakeUpListener);
            return true;
        }
        return false;
    }

    public static void getWakeUpYYBAlwaysCallback(@NonNull Activity activity, @Nullable Intent intent, @NonNull AppWakeUpListener appWakeUpListener) {
        if (!OpenInstall.a()) {
            appWakeUpListener.onWakeUpFinish(null, Error.fromInner(et.a.a));
            return;
        }
        if (OpenInstallHelper.isSchemeWakeup(intent)) {
            io.openinstall.sdk.a.a().a(intent, appWakeUpListener);
            return;
        }
        if (OpenInstallHelper.isLauncherFromYYB(activity, intent)) {
            io.openinstall.sdk.a.a().a(appWakeUpListener);
            return;
        }
        appWakeUpListener.onWakeUpFinish(null, Error.fromInner(et.a.g));
    }

    public static void getInstall(@NonNull AppInstallListener appInstallListener) {
        OpenInstall.getInstall(appInstallListener, 10);
    }

    public static void getInstall(@NonNull AppInstallListener appInstallListener, int seconds) {
        if (!OpenInstall.a()) {
            appInstallListener.onInstallFinish(null, Error.fromInner(et.a.a));
            return;
        }
        if (fv.a && seconds < 5) {
            fv.b("getInstall\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u8fc7\u5c0f\uff0c\u6613\u9020\u6210\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u589e\u5927\u8d85\u65f6\u65f6\u95f4\u6216\u8c03\u6574\u8c03\u7528\u65f6\u673a", new Object[0]);
        }
        io.openinstall.sdk.a.a().a(false, seconds, appInstallListener);
    }

    public static void getInstallCanRetry(@NonNull AppInstallRetryAdapter retryListener, int seconds) {
        if (!OpenInstall.a()) {
            et et2 = et.a.a.a();
            retryListener.onInstallFinish(null, Error.fromInner(et.a.a));
            return;
        }
        io.openinstall.sdk.a.a().a(true, seconds, retryListener);
    }

    public static void reportRegister() {
        if (!OpenInstall.a()) {
            return;
        }
        io.openinstall.sdk.a.a().d();
    }

    public static void reportEffectPoint(@NonNull String pointId, long pointValue) {
        if (!OpenInstall.a()) {
            return;
        }
        io.openinstall.sdk.a.a().a(pointId, pointValue);
    }

    public static void reportEffectPoint(@NonNull String pointId, long pointValue, Map<String, String> extraMap) {
        if (!OpenInstall.a()) {
            return;
        }
        io.openinstall.sdk.a.a().a(pointId, pointValue, extraMap);
    }

    public static void reportShare(@NonNull String shareCode, SharePlatform sharePlatform, ResultCallback<Void> resultCallback) {
        OpenInstall.reportShare(shareCode, sharePlatform.name(), resultCallback);
    }

    public static void reportShare(@NonNull String shareCode, @NonNull String sharePlatform, ResultCallback<Void> resultCallback) {
        if (!OpenInstall.a()) {
            resultCallback.onResult(null, Error.fromInner(et.a.a));
            return;
        }
        io.openinstall.sdk.a.a().a(shareCode, sharePlatform, resultCallback);
    }

    private static boolean a() {
        if (!b) {
            if (fv.a) {
                fv.c("\u8bf7\u5148\u8c03\u7528 init(Context) \u521d\u59cb\u5316", new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static void getUpdateApk(@NonNull ResultCallback<File> resultCallback) {
        if (!OpenInstall.a()) {
            resultCallback.onResult(null, Error.fromInner(et.a.a));
            return;
        }
        io.openinstall.sdk.a.a().a(resultCallback);
    }
}

