/*
 * Decompiled with CFR 0.152.
 */
package com.fm.openinstall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.openinstall.sdk.dt;
import io.openinstall.sdk.fr;
import io.openinstall.sdk.k;

public final class OpenInstallHelper {
    private OpenInstallHelper() {
    }

    public static boolean isTrackData(@Nullable ClipData clipData) {
        dt dt2 = dt.a(clipData);
        if (dt2 == null) {
            return false;
        }
        return dt2.c(1) || dt2.c(2);
    }

    public static boolean checkSimulator(@NonNull Context context) {
        return k.a().a(context);
    }

    @Deprecated
    public static boolean isSchemeWakeup(@Nullable Intent intent) {
        if (intent == null || intent.getData() == null || intent.getAction() == null) {
            return false;
        }
        String string = intent.getAction();
        String string2 = intent.getData().getHost();
        return !TextUtils.isEmpty((CharSequence)string2) && string.equals("android.intent.action.VIEW");
    }

    public static boolean isLauncherFromYYB(@NonNull Activity activity, @Nullable Intent intent) {
        boolean bl2 = false;
        if (activity == null || intent == null || TextUtils.isEmpty((CharSequence)intent.getAction()) || intent.getCategories() == null) {
            return false;
        }
        if (intent.getAction().equals("android.intent.action.MAIN") && intent.getCategories().contains("android.intent.category.LAUNCHER") && Build.VERSION.SDK_INT >= 22) {
            Uri uri = activity.getReferrer();
            if (uri == null) {
                return false;
            }
            String string = uri.getAuthority();
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            if (string.equalsIgnoreCase(fr.o) || string.equalsIgnoreCase(fr.p) || string.equalsIgnoreCase(fr.n)) {
                bl2 = true;
            }
            if (string.equalsIgnoreCase(fr.q) || string.equalsIgnoreCase(fr.r) || string.equalsIgnoreCase(fr.s)) {
                bl2 = true;
            }
        }
        return bl2;
    }
}

