/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import net.sf.jsignpdf.Constants;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class JSignEncryptor {
    private BufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new BlowfishEngine()));
    private KeyParameter key;
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public JSignEncryptor(byte[] aKey) {
        this.key = new KeyParameter(aKey);
    }

    public JSignEncryptor(String aKey) {
        this(aKey.getBytes());
    }

    public JSignEncryptor() {
        this(Constants.USER_HOME + "Conan, premozitel hobitu.");
    }

    private byte[] callCipher(byte[] data) throws CryptoException {
        int size = this.cipher.getOutputSize(data.length);
        byte[] result = new byte[size];
        int olen = this.cipher.processBytes(data, 0, data.length, result, 0);
        if ((olen += this.cipher.doFinal(result, olen)) < size) {
            byte[] tmp = new byte[olen];
            System.arraycopy(result, 0, tmp, 0, olen);
            result = tmp;
        }
        return result;
    }

    private synchronized byte[] encrypt(byte[] data) throws CryptoException {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        this.cipher.init(true, (CipherParameters)this.key);
        return this.callCipher(data);
    }

    public String encryptString(String data) throws CryptoException {
        if (data == null || data.length() == 0) {
            return null;
        }
        return JSignEncryptor.toHexString(this.encrypt(data.getBytes()));
    }

    private synchronized byte[] decrypt(byte[] data) throws CryptoException {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        this.cipher.init(false, (CipherParameters)this.key);
        return this.callCipher(data);
    }

    public String decryptString(String data) throws CryptoException {
        if (data == null || data.length() == 0) {
            return "";
        }
        return new String(this.decrypt(JSignEncryptor.fromHexString(data)));
    }

    public static String toHexString(byte[] data, int offset, int length) {
        StringBuffer s = new StringBuffer(length * 2);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            int high_nibble = (data[i] & 0xF0) >>> 4;
            int low_nibble = data[i] & 0xF;
            s.append(hex_table[high_nibble]);
            s.append(hex_table[low_nibble]);
        }
        return s.toString();
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        return JSignEncryptor.toHexString(data, 0, data.length);
    }

    public static byte[] fromHexString(String s, int offset, int length) {
        if (length % 2 != 0) {
            return null;
        }
        byte[] byteArray = new byte[length / 2];
        int j = 0;
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            int high_nibble = Character.digit(s.charAt(i), 16);
            int low_nibble = Character.digit(s.charAt(i + 1), 16);
            if (high_nibble == -1 || low_nibble == -1) {
                return null;
            }
            byteArray[j++] = (byte)(high_nibble << 4 & 0xF0 | low_nibble & 0xF);
        }
        return byteArray;
    }

    public static byte[] fromHexString(String s) {
        return JSignEncryptor.fromHexString(s, 0, s.length());
    }
}

