/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.io.File;
import java.io.FileFilter;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.UIManager;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.SignPdfForm;
import net.sf.jsignpdf.SignerLogic;
import net.sf.jsignpdf.SignerOptionsFromCmdLine;
import net.sf.jsignpdf.ssl.SSLInitializer;
import net.sf.jsignpdf.utils.ConfigProvider;
import net.sf.jsignpdf.utils.GuiUtils;
import net.sf.jsignpdf.utils.KeyStoreUtils;
import net.sf.jsignpdf.utils.PKCS11Utils;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Signer {
    private static final Logger LOGGER = Logger.getLogger(Signer.class);
    static String pkcs11ProviderName = null;

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "java -jar JSignPdf.jar [file1.pdf [file2.pdf ...]]", Constants.RES.get("hlp.header"), SignerOptionsFromCmdLine.OPTS, Constants.NEW_LINE + Constants.RES.get("hlp.footer.exitCodes") + Constants.NEW_LINE + StringUtils.repeat((String)"-", (int)80) + Constants.NEW_LINE + Constants.RES.get("hlp.footer.examples"), true);
    }

    public static void main(String[] args) {
        SignerOptionsFromCmdLine tmpOpts = null;
        if (args != null && args.length > 0) {
            tmpOpts = new SignerOptionsFromCmdLine();
            Signer.parseCommandLine(args, tmpOpts);
        }
        try {
            SSLInitializer.init();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to re-configure SSL layer", (Throwable)e);
        }
        pkcs11ProviderName = PKCS11Utils.registerProvider(ConfigProvider.getInstance().getProperty("pkcs11config.path"));
        Signer.traceInfo();
        if (tmpOpts != null) {
            if (tmpOpts.isPrintVersion()) {
                System.out.println("JSignPdf version 1.6.4");
            }
            if (tmpOpts.isPrintHelp()) {
                Signer.printHelp();
            }
            if (tmpOpts.isListKeyStores()) {
                LOGGER.info((Object)Constants.RES.get("console.keystores"));
                for (String tmpKsType : KeyStoreUtils.getKeyStores()) {
                    System.out.println(tmpKsType);
                }
            }
            if (tmpOpts.isListKeys()) {
                String[] tmpKeyAliases = KeyStoreUtils.getKeyAliases(tmpOpts);
                LOGGER.info((Object)Constants.RES.get("console.keys"));
                for (String tmpCert : tmpKeyAliases) {
                    System.out.println(tmpCert);
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])tmpOpts.getFiles()) || !StringUtils.isEmpty((CharSequence)tmpOpts.getInFile()) && !StringUtils.isEmpty((CharSequence)tmpOpts.getOutFile())) {
                Signer.signFiles(tmpOpts);
            } else {
                boolean tmpCommand;
                boolean bl = tmpCommand = tmpOpts.isPrintVersion() || tmpOpts.isPrintHelp() || tmpOpts.isListKeyStores() || tmpOpts.isListKeys();
                if (!tmpCommand) {
                    Signer.printHelp();
                    Signer.exit(2);
                }
            }
            Signer.exit(0);
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                System.err.println("Can't set Look&Feel.");
            }
            SignPdfForm tmpForm = new SignPdfForm(3);
            tmpForm.pack();
            GuiUtils.center(tmpForm);
            tmpForm.setVisible(true);
        }
    }

    private static void traceInfo() {
        if (LOGGER.isTraceEnabled()) {
            try {
                Provider[] aProvider = Security.getProviders();
                for (int i = 0; i < aProvider.length; ++i) {
                    Provider provider = aProvider[i];
                    LOGGER.trace((Object)("Provider " + (i + 1) + " : " + provider.getName() + " " + provider.getInfo() + " :"));
                    ArrayList<Object> keyList = new ArrayList<Object>(provider.keySet());
                    try {
                        Collections.sort(keyList);
                    }
                    catch (Exception e) {
                        LOGGER.trace((Object)"Provider's properties keys can't be sorted", (Throwable)e);
                    }
                    for (String string : keyList) {
                        LOGGER.trace((Object)(string + ": " + provider.getProperty(string)));
                    }
                    LOGGER.trace((Object)"------------------------------------------------");
                }
            }
            catch (Exception e) {
                LOGGER.trace((Object)"Listing security providers failed", (Throwable)e);
            }
        }
    }

    private static void signFiles(SignerOptionsFromCmdLine anOpts) {
        SignerLogic tmpLogic = new SignerLogic(anOpts);
        if (ArrayUtils.isEmpty((Object[])anOpts.getFiles())) {
            if (!tmpLogic.signFile()) {
                Signer.exit(4);
            }
            return;
        }
        int successCount = 0;
        int failedCount = 0;
        for (String wildcardPath : anOpts.getFiles()) {
            File[] inputFiles;
            File wildcardFile = new File(wildcardPath);
            if (StringUtils.containsAny((CharSequence)wildcardFile.getName(), (char[])new char[]{'*', '?'})) {
                AndFileFilter fileFilter;
                File inputFolder = wildcardFile.getAbsoluteFile().getParentFile();
                inputFiles = inputFolder.listFiles((FileFilter)(fileFilter = new AndFileFilter(FileFileFilter.FILE, (IOFileFilter)new WildcardFileFilter(wildcardFile.getName()))));
                if (inputFiles == null) {
                    continue;
                }
            } else {
                inputFiles = new File[]{wildcardFile};
            }
            for (File inputFile : inputFiles) {
                String tmpInFile = inputFile.getPath();
                if (!inputFile.canRead()) {
                    ++failedCount;
                    System.err.println(Constants.RES.get("file.notReadable", tmpInFile));
                    continue;
                }
                anOpts.setInFile(tmpInFile);
                String tmpNameBase = inputFile.getName();
                String tmpSuffix = ".pdf";
                if (StringUtils.endsWithIgnoreCase((CharSequence)tmpNameBase, (CharSequence)tmpSuffix)) {
                    tmpSuffix = StringUtils.right((String)tmpNameBase, (int)4);
                    tmpNameBase = StringUtils.left((String)tmpNameBase, (int)(tmpNameBase.length() - 4));
                }
                StringBuilder tmpName = new StringBuilder(anOpts.getOutPath());
                tmpName.append(anOpts.getOutPrefix());
                tmpName.append(tmpNameBase).append(anOpts.getOutSuffix()).append(tmpSuffix);
                anOpts.setOutFile(tmpName.toString());
                if (tmpLogic.signFile()) {
                    ++successCount;
                    continue;
                }
                ++failedCount;
            }
        }
        if (failedCount > 0) {
            Signer.exit(successCount > 0 ? 3 : 4);
        }
    }

    private static void parseCommandLine(String[] args, SignerOptionsFromCmdLine opts) {
        try {
            opts.loadCmdLine(args);
        }
        catch (ParseException exp) {
            System.err.println("Unable to parse command line (Use -h for the help)\n" + exp.getMessage());
            Signer.exit(1);
        }
    }

    private static void exit(int exitCode) {
        PKCS11Utils.unregisterProvider(pkcs11ProviderName);
        System.exit(exitCode);
    }
}

