/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.net.Proxy;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.types.CertificationLevel;
import net.sf.jsignpdf.types.HashAlgorithm;
import net.sf.jsignpdf.types.PDFEncryption;
import net.sf.jsignpdf.types.PrintRight;
import net.sf.jsignpdf.types.RenderMode;
import net.sf.jsignpdf.types.ServerAuthentication;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignerOptionsFromCmdLine
extends BasicSignerOptions {
    static final Options OPTS = new Options();
    private String outPrefix;
    private String outSuffix = "_signed";
    private String outPath;
    private String[] files;
    private boolean printHelp = true;
    private boolean printVersion;
    private boolean listKeyStores;
    private boolean listKeys;

    public void loadCmdLine(String[] anArgs) throws ParseException {
        if (anArgs == null) {
            return;
        }
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(OPTS, anArgs);
        this.setAdvanced(true);
        if (line.hasOption("lpf")) {
            if (!line.hasOption("lp")) {
                this.props.clear();
            }
            this.props.loadProperties(line.getOptionValue("lpf"));
        }
        if (line.hasOption("lp") || line.hasOption("lpf")) {
            this.loadOptions();
        }
        if (line.hasOption("q")) {
            Logger.getRootLogger().removeAllAppenders();
        }
        this.setFiles(line.getArgs());
        this.setPrintHelp(line.hasOption("h"));
        this.setPrintVersion(line.hasOption("v"));
        this.setListKeyStores(line.hasOption("lkt"));
        this.setListKeys(line.hasOption("lk"));
        if (line.hasOption("kst")) {
            this.setKsType(line.getOptionValue("kst"));
        }
        if (line.hasOption("ksf")) {
            this.setKsFile(line.getOptionValue("ksf"));
        }
        if (line.hasOption("ksp")) {
            this.setKsPasswd(line.getOptionValue("ksp"));
        }
        if (line.hasOption("ka")) {
            this.setKeyAlias(line.getOptionValue("ka"));
        }
        if (line.hasOption("ki")) {
            this.setKeyIndex(this.getInt(line.getParsedOptionValue("ki"), this.getKeyIndex()));
        }
        if (line.hasOption("kp")) {
            this.setKeyPasswd(line.getOptionValue("kp"));
        }
        if (line.hasOption("d")) {
            this.setOutPath(line.getOptionValue("d"));
        }
        if (line.hasOption("op")) {
            this.setOutPrefix(line.getOptionValue("op"));
        }
        if (line.hasOption("os")) {
            this.setOutSuffix(line.getOptionValue("os"));
        }
        if (line.hasOption("r")) {
            this.setReason(line.getOptionValue("r"));
        }
        if (line.hasOption("l")) {
            this.setLocation(line.getOptionValue("l"));
        }
        if (line.hasOption("c")) {
            this.setContact(line.getOptionValue("c"));
        }
        this.setAppend(line.hasOption("a"));
        if (line.hasOption("cl")) {
            this.setCertLevel(line.getOptionValue("cl"));
        }
        if (line.hasOption("ha")) {
            this.setHashAlgorithm(line.getOptionValue("ha"));
        }
        if (line.hasOption("e")) {
            this.setPdfEncryption(PDFEncryption.PASSWORD);
        }
        if (line.hasOption("pe")) {
            this.setPdfEncryption(line.getOptionValue("pe"));
        }
        if (line.hasOption("opwd")) {
            this.setPdfOwnerPwd(line.getOptionValue("opwd"));
        }
        if (line.hasOption("upwd")) {
            this.setPdfUserPwd(line.getOptionValue("upwd"));
        }
        if (line.hasOption("ec")) {
            this.setPdfEncryptionCertFile(line.getOptionValue("ec"));
        }
        if (line.hasOption("pr")) {
            this.setRightPrinting(line.getOptionValue("pr"));
        }
        this.setRightCopy(!line.hasOption("disable-copy"));
        this.setRightAssembly(!line.hasOption("disable-assembly"));
        this.setRightFillIn(!line.hasOption("disable-fill"));
        this.setRightScreanReaders(!line.hasOption("disable-screen-readers"));
        this.setRightModifyAnnotations(!line.hasOption("disable-modify-annotations"));
        this.setRightModifyContents(!line.hasOption("disable-modify-content"));
        if (line.hasOption("V")) {
            this.setVisible(true);
        }
        if (line.hasOption("pg")) {
            this.setPage(this.getInt(line.getParsedOptionValue("pg"), this.getPage()));
        }
        if (line.hasOption("llx")) {
            this.setPositionLLX(this.getFloat(line.getParsedOptionValue("llx"), this.getPositionLLX()));
        }
        if (line.hasOption("lly")) {
            this.setPositionLLY(this.getFloat(line.getParsedOptionValue("lly"), this.getPositionLLY()));
        }
        if (line.hasOption("urx")) {
            this.setPositionURX(this.getFloat(line.getParsedOptionValue("urx"), this.getPositionURX()));
        }
        if (line.hasOption("ury")) {
            this.setPositionURY(this.getFloat(line.getParsedOptionValue("ury"), this.getPositionURY()));
        }
        if (line.hasOption("bg-scale")) {
            this.setBgImgScale(this.getFloat(line.getParsedOptionValue("bg-scale"), this.getBgImgScale()));
        }
        if (line.hasOption("render-mode")) {
            this.setRenderMode(line.getOptionValue("render-mode"));
        }
        if (line.hasOption("l2-text")) {
            this.setL2Text(line.getOptionValue("l2-text"));
        }
        if (line.hasOption("fs")) {
            this.setL2TextFontSize(this.getFloat(line.getParsedOptionValue("fs"), this.getL2TextFontSize()));
        }
        if (line.hasOption("l4-text")) {
            this.setL4Text(line.getOptionValue("l4-text"));
        }
        if (line.hasOption("img-path")) {
            this.setImgPath(line.getOptionValue("img-path"));
        }
        if (line.hasOption("bg-path")) {
            this.setBgImgPath(line.getOptionValue("bg-path"));
        }
        this.setAcro6Layers(!line.hasOption("disable-acrobat6-layer-mode"));
        if (line.hasOption("ts")) {
            this.setTimestamp(true);
            this.setTsaUrl(line.getOptionValue("ts"));
        }
        if (line.hasOption("ta")) {
            this.setTsaServerAuthn(line.getOptionValue("ta"));
        }
        if (line.hasOption("tsct")) {
            this.setTsaCertFileType(line.getOptionValue("tsct"));
        }
        if (line.hasOption("tscf")) {
            this.setTsaCertFile(line.getOptionValue("tscf"));
        }
        if (line.hasOption("tscp")) {
            this.setTsaCertFilePwd(line.getOptionValue("tscp"));
        }
        if (line.hasOption("tsu")) {
            this.setTsaUser(line.getOptionValue("tsu"));
        }
        if (line.hasOption("tsp")) {
            this.setTsaPasswd(line.getOptionValue("tsp"));
        }
        if (line.hasOption("tsa-policy-oid")) {
            this.setTsaPolicy(line.getOptionValue("tsa-policy-oid"));
        }
        if (line.hasOption("tsh")) {
            this.setTsaHashAlg(line.getOptionValue("tsh"));
        }
        if (line.hasOption("ocsp")) {
            this.setOcspEnabled(true);
        }
        if (line.hasOption("ocsp-server-url")) {
            this.setOcspServerUrl(line.getOptionValue("ocsp-server-url"));
        }
        if (line.hasOption("crl")) {
            this.setCrlEnabled(true);
        }
        if (line.hasOption("proxy-type")) {
            this.setProxyType(line.getOptionValue("proxy-type"));
        }
        if (line.hasOption("proxy-host")) {
            this.setProxyHost(line.getOptionValue("proxy-host"));
        }
        if (line.hasOption("proxy-port")) {
            this.setProxyPort(this.getInt(line.getParsedOptionValue("proxy-port"), this.getProxyPort()));
        }
    }

    private int getInt(Object aVal, int aDefVal) {
        if (aVal instanceof Number) {
            return ((Number)aVal).intValue();
        }
        return aDefVal;
    }

    private float getFloat(Object aVal, float aDefVal) {
        if (aVal instanceof Number) {
            return ((Number)aVal).floatValue();
        }
        return aDefVal;
    }

    public String getOutPrefix() {
        if (this.outPrefix == null) {
            this.outPrefix = "";
        }
        return this.outPrefix;
    }

    private static String getEnumValues(Enum<?>[] aEnumVals) {
        StringBuilder tmpResult = new StringBuilder();
        boolean tmpFirst = true;
        for (Enum<?> tmpEnu : aEnumVals) {
            if (tmpFirst) {
                tmpFirst = false;
            } else {
                tmpResult.append(", ");
            }
            tmpResult.append(tmpEnu.name());
        }
        return tmpResult.toString();
    }

    public void setOutPrefix(String outPrefix) {
        this.outPrefix = outPrefix;
    }

    public String getOutSuffix() {
        if (this.outSuffix == null) {
            this.outSuffix = "";
        }
        return this.outSuffix;
    }

    public void setOutSuffix(String outSuffix) {
        this.outSuffix = outSuffix;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public void setPrintHelp(boolean printHelp) {
        this.printHelp = printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public void setPrintVersion(boolean printVersion) {
        this.printVersion = printVersion;
    }

    public boolean isListKeyStores() {
        return this.listKeyStores;
    }

    public void setListKeyStores(boolean listKeyStores) {
        this.listKeyStores = listKeyStores;
    }

    public boolean isListKeys() {
        return this.listKeys;
    }

    public void setListKeys(boolean listKeys) {
        this.listKeys = listKeys;
    }

    public String getOutPath() {
        String tmpResult;
        if (StringUtils.isEmpty((CharSequence)this.outPath)) {
            tmpResult = "./";
        } else {
            tmpResult = this.outPath.replaceAll("\\\\", "/");
            if (!tmpResult.endsWith("/")) {
                tmpResult = tmpResult + "/";
            }
        }
        return tmpResult;
    }

    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }

    static {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.create();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.help"));
        OPTS.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.version"));
        OPTS.addOption(OptionBuilder.create((String)"v"));
        OptionBuilder.withLongOpt((String)"load-properties");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.loadProperties"));
        OPTS.addOption(OptionBuilder.create((String)"lp"));
        OptionBuilder.withLongOpt((String)"load-properties-file");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.loadPropertiesFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OPTS.addOption(OptionBuilder.create((String)"lpf"));
        OptionBuilder.withLongOpt((String)"list-keystore-types");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.listKsTypes"));
        OPTS.addOption(OptionBuilder.create((String)"lkt"));
        OptionBuilder.withLongOpt((String)"list-keys");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.listKeys"));
        OPTS.addOption(OptionBuilder.create((String)"lk"));
        OptionBuilder.withLongOpt((String)"keystore-type");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.ksType"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"type");
        OPTS.addOption(OptionBuilder.create((String)"kst"));
        OptionBuilder.withLongOpt((String)"keystore-file");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.ksFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OPTS.addOption(OptionBuilder.create((String)"ksf"));
        OptionBuilder.withLongOpt((String)"keystore-password");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.ksPwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OPTS.addOption(OptionBuilder.create((String)"ksp"));
        OptionBuilder.withLongOpt((String)"key-alias");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.keyAlias"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"alias");
        OPTS.addOption(OptionBuilder.create((String)"ka"));
        OptionBuilder.withLongOpt((String)"key-index");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.keyIndex"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"index");
        OPTS.addOption(OptionBuilder.create((String)"ki"));
        OptionBuilder.withLongOpt((String)"key-password");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.keyPwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OPTS.addOption(OptionBuilder.create((String)"kp"));
        OptionBuilder.withLongOpt((String)"out-directory");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.outPath"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OPTS.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"out-prefix");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.outPrefix"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"prefix");
        OPTS.addOption(OptionBuilder.create((String)"op"));
        OptionBuilder.withLongOpt((String)"out-suffix");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.outSuffix"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"suffix");
        OPTS.addOption(OptionBuilder.create((String)"os"));
        OptionBuilder.withLongOpt((String)"reason");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.reason"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"reason");
        OPTS.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"location");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.location"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"location");
        OPTS.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"contact");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.contact"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"contact");
        OPTS.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"append");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.append"));
        OPTS.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"certification-level");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.certLevel", SignerOptionsFromCmdLine.getEnumValues(CertificationLevel.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"level");
        OPTS.addOption(OptionBuilder.create((String)"cl"));
        OptionBuilder.withLongOpt((String)"hash-algorithm");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.hashAlgorithm", SignerOptionsFromCmdLine.getEnumValues(HashAlgorithm.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"algorithm");
        OPTS.addOption(OptionBuilder.create((String)"ha"));
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.quiet"));
        OPTS.addOption(OptionBuilder.create((String)"q"));
        OptionBuilder.withLongOpt((String)"encrypted");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.encrypted"));
        OPTS.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"encryption");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.encryption", SignerOptionsFromCmdLine.getEnumValues(PDFEncryption.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"mode");
        OPTS.addOption(OptionBuilder.create((String)"pe"));
        OptionBuilder.withLongOpt((String)"owner-password");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.ownerpwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OPTS.addOption(OptionBuilder.create((String)"opwd"));
        OptionBuilder.withLongOpt((String)"user-password");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.userpwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OPTS.addOption(OptionBuilder.create((String)"upwd"));
        OptionBuilder.withLongOpt((String)"encryption-certificate");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.encCert"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OPTS.addOption(OptionBuilder.create((String)"ec"));
        OptionBuilder.withLongOpt((String)"print-right");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.printRight", SignerOptionsFromCmdLine.getEnumValues(PrintRight.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"right");
        OPTS.addOption(OptionBuilder.create((String)"pr"));
        OptionBuilder.withLongOpt((String)"disable-copy");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableCopy"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"disable-assembly");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableAssembly"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"disable-fill");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableFill"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"disable-screen-readers");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableScrRead"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"disable-modify-annotations");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableAnnot"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"disable-modify-content");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableContent"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"visible-signature");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.visible"));
        OPTS.addOption(OptionBuilder.create((String)"V"));
        OptionBuilder.withLongOpt((String)"page");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.page"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"pageNumber");
        OPTS.addOption(OptionBuilder.create((String)"pg"));
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.posLLX"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"position");
        OPTS.addOption(OptionBuilder.create((String)"llx"));
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.posLLY"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"position");
        OPTS.addOption(OptionBuilder.create((String)"lly"));
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.posURX"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"position");
        OPTS.addOption(OptionBuilder.create((String)"urx"));
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.posURY"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"position");
        OPTS.addOption(OptionBuilder.create((String)"ury"));
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.imgPath"));
        OptionBuilder.withLongOpt((String)"img-path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.bgPath"));
        OptionBuilder.withLongOpt((String)"bg-path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.bgScale"));
        OptionBuilder.withLongOpt((String)"bg-scale");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"scale");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.disableAcro6Layers"));
        OptionBuilder.withLongOpt((String)"disable-acrobat6-layer-mode");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.renderMode", SignerOptionsFromCmdLine.getEnumValues(RenderMode.values())));
        OptionBuilder.withLongOpt((String)"render-mode");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"mode");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.l2Text"));
        OptionBuilder.withLongOpt((String)"l2-text");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"text");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.l2TextFontSize", String.valueOf(10.0f)));
        OptionBuilder.withLongOpt((String)"font-size");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"size");
        OPTS.addOption(OptionBuilder.create((String)"fs"));
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.l4Text"));
        OptionBuilder.withLongOpt((String)"l4-text");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"text");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"tsa-server-url");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaUrl"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"URL");
        OPTS.addOption(OptionBuilder.create((String)"ts"));
        OptionBuilder.withLongOpt((String)"tsa-authentication");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaAuthn", SignerOptionsFromCmdLine.getEnumValues(ServerAuthentication.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"method");
        OPTS.addOption(OptionBuilder.create((String)"ta"));
        OptionBuilder.withLongOpt((String)"tsa-cert-file-type");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaCertFileType"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ks-type");
        OPTS.addOption(OptionBuilder.create((String)"tsct"));
        OptionBuilder.withLongOpt((String)"tsa-cert-file");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaCertFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OPTS.addOption(OptionBuilder.create((String)"tscf"));
        OptionBuilder.withLongOpt((String)"tsa-cert-password");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaCertPasswd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OPTS.addOption(OptionBuilder.create((String)"tscp"));
        OptionBuilder.withLongOpt((String)"tsa-user");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaUser"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"username");
        OPTS.addOption(OptionBuilder.create((String)"tsu"));
        OptionBuilder.withLongOpt((String)"tsa-password");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaPwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OPTS.addOption(OptionBuilder.create((String)"tsp"));
        OptionBuilder.withLongOpt((String)"tsa-policy-oid");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaPolicy"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"policyOID");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"tsa-hash-algorithm");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.tsaHashAlg", Constants.DEFVAL_TSA_HASH_ALG));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"algorithm");
        OPTS.addOption(OptionBuilder.create((String)"tsh"));
        OptionBuilder.withLongOpt((String)"ocsp");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.ocsp"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"ocsp-server-url");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.ocspServerUrl"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"responderUrl");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"crl");
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.crl"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.proxyType", Constants.DEFVAL_PROXY_TYPE.name(), SignerOptionsFromCmdLine.getEnumValues(Proxy.Type.values())));
        OptionBuilder.withLongOpt((String)"proxy-type");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"type");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.proxyHost"));
        OptionBuilder.withLongOpt((String)"proxy-host");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"hostname");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)Constants.RES.get("hlp.proxyPort", String.valueOf(80)));
        OptionBuilder.withLongOpt((String)"proxy-port");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName((String)"port");
        OPTS.addOption(OptionBuilder.create());
    }
}

