/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.Proxy;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.types.ServerAuthentication;

public class TsaDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private BasicSignerOptions options;
    private JButton btnTsaOK;
    private JComboBox cbProxyType;
    private JComboBox cbTsaAuthn;
    private JCheckBox chkbCrlEnabled;
    private JCheckBox chkbOcspEnabled;
    private JCheckBox chkbTsaEnabled;
    private JLabel lblOcspUrl;
    private JLabel lblProxyHost;
    private JLabel lblProxyType;
    private JLabel lblTsaAuthn;
    private JLabel lblTsaHashAlg;
    private JLabel lblTsaPolicy;
    private JLabel lblTsaPwd;
    private JLabel lblTsaUrl;
    private JLabel lblTsaUser;
    private JPasswordField pfTsaPwd;
    private JPanel pnlProxy;
    private JSpinner spProxyPort;
    private JTextField tfOcspUrl;
    private JTextField tfProxyHost;
    private JTextField tfTsaHashAlg;
    private JTextField tfTsaPolicy;
    private JTextField tfTsaUrl;
    private JTextField tfTsaUser;

    public TsaDialog(Frame parent, boolean modal, BasicSignerOptions anOpts) {
        super(parent, modal);
        this.options = anOpts;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btnTsaOK);
        this.cbProxyType.setModel(new DefaultComboBoxModel<Proxy.Type>(Proxy.Type.values()));
        this.cbTsaAuthn.setModel(new DefaultComboBoxModel<ServerAuthentication>(ServerAuthentication.values()));
        this.translateLabels();
    }

    private void translateLabels() {
        this.setTitle(Constants.RES.get("gui.tsa.title"));
        this.setLabelAndMnemonic(this.chkbTsaEnabled, "gui.tsa.enabled.checkbox");
        this.setLabelAndMnemonic(this.lblTsaUrl, "gui.tsa.url.label");
        this.setLabelAndMnemonic(this.lblTsaUser, "gui.tsa.user.label");
        this.setLabelAndMnemonic(this.lblTsaAuthn, "gui.tsa.authn.label");
        this.setLabelAndMnemonic(this.lblTsaPwd, "gui.tsa.pwd.label");
        this.setLabelAndMnemonic(this.lblTsaPolicy, "gui.tsa.policy.label");
        this.setLabelAndMnemonic(this.lblTsaHashAlg, "gui.tsa.hashAlg.label");
        this.setLabelAndMnemonic(this.chkbOcspEnabled, "gui.tsa.ocspEnabled.checkbox");
        this.setLabelAndMnemonic(this.lblOcspUrl, "gui.tsa.ocspServerUrl.label");
        this.setLabelAndMnemonic(this.chkbCrlEnabled, "gui.tsa.crlEnabled.checkbox");
        this.setLabelAndMnemonic(this.pnlProxy, "gui.tsa.proxy.panel");
        this.setLabelAndMnemonic(this.lblProxyType, "gui.tsa.proxyType.label");
        this.setLabelAndMnemonic(this.lblProxyHost, "gui.tsa.proxyHost.label");
    }

    private void refreshView() {
        boolean authnVisible = this.cbTsaAuthn.getSelectedItem() != ServerAuthentication.NONE;
        this.lblTsaUser.setVisible(authnVisible);
        this.lblTsaPwd.setVisible(authnVisible);
        this.tfTsaUser.setVisible(authnVisible);
        this.pfTsaPwd.setVisible(authnVisible);
        if (this.cbTsaAuthn.getSelectedItem() == ServerAuthentication.PASSWORD) {
            this.setLabelAndMnemonic(this.lblTsaUser, "gui.tsa.user.label");
            this.setLabelAndMnemonic(this.lblTsaPwd, "gui.tsa.pwd.label");
            this.tfTsaUser.setText(this.options.getTsaUser());
            this.pfTsaPwd.setText(this.options.getTsaPasswd());
        } else if (this.cbTsaAuthn.getSelectedItem() == ServerAuthentication.CERTIFICATE) {
            this.setLabelAndMnemonic(this.lblTsaUser, "gui.tsa.certFile.label");
            this.setLabelAndMnemonic(this.lblTsaPwd, "gui.tsa.certFilePwd.label");
            this.tfTsaUser.setText(this.options.getTsaCertFile());
            this.pfTsaPwd.setText(this.options.getTsaCertFilePwd());
        } else {
            this.tfTsaUser.setText(null);
            this.pfTsaPwd.setText(null);
        }
        boolean proxyDetailsVisible = this.cbProxyType.getSelectedItem() != Proxy.Type.DIRECT;
        this.lblProxyHost.setVisible(proxyDetailsVisible);
        this.tfProxyHost.setVisible(proxyDetailsVisible);
        this.spProxyPort.setVisible(proxyDetailsVisible);
    }

    private void updateFromOptions() {
        this.chkbTsaEnabled.setSelected(this.options.isTimestamp());
        this.tfTsaUrl.setText(this.options.getTsaUrl());
        this.cbTsaAuthn.setSelectedItem((Object)this.options.getTsaServerAuthn());
        this.pfTsaPwd.setText(this.options.getTsaPasswd());
        this.tfTsaPolicy.setText(this.options.getTsaPolicy());
        this.tfTsaHashAlg.setText(this.options.getTsaHashAlg());
        this.chkbOcspEnabled.setSelected(this.options.isOcspEnabled());
        this.tfOcspUrl.setText(this.options.getOcspServerUrl());
        this.chkbCrlEnabled.setSelected(this.options.isCrlEnabled());
        this.cbProxyType.setSelectedItem((Object)this.options.getProxyType());
        this.tfProxyHost.setText(this.options.getProxyHost());
        this.spProxyPort.setValue(this.options.getProxyPort());
    }

    private void updateEnabledStatus() {
        boolean tmpTsaEnabled = this.chkbTsaEnabled.isSelected();
        this.tfTsaUrl.setEnabled(tmpTsaEnabled);
        this.cbTsaAuthn.setEnabled(tmpTsaEnabled);
        this.tfTsaUser.setEnabled(tmpTsaEnabled);
        this.pfTsaPwd.setEnabled(tmpTsaEnabled);
        this.tfTsaPolicy.setEnabled(tmpTsaEnabled);
        this.tfTsaHashAlg.setEnabled(tmpTsaEnabled);
        this.tfOcspUrl.setEnabled(this.chkbOcspEnabled.isSelected());
    }

    private void storeToOptions() {
        this.options.setTimestamp(this.chkbTsaEnabled.isSelected());
        this.options.setTsaUrl(this.tfTsaUrl.getText());
        this.options.setTsaServerAuthn((ServerAuthentication)((Object)this.cbTsaAuthn.getSelectedItem()));
        if (this.cbTsaAuthn.getSelectedItem() == ServerAuthentication.CERTIFICATE) {
            this.options.setTsaCertFile(this.tfTsaUser.getText());
            this.options.setTsaCertFilePwd(new String(this.pfTsaPwd.getPassword()));
        } else {
            this.options.setTsaUser(this.tfTsaUser.getText());
            this.options.setTsaPasswd(new String(this.pfTsaPwd.getPassword()));
        }
        this.options.setTsaPolicy(this.tfTsaPolicy.getText());
        this.options.setTsaHashAlg(this.tfTsaHashAlg.getText());
        this.options.setOcspEnabled(this.chkbOcspEnabled.isSelected());
        this.options.setOcspServerUrl(this.tfOcspUrl.getText());
        this.options.setCrlEnabled(this.chkbCrlEnabled.isSelected());
        this.options.setProxyType((Proxy.Type)((Object)this.cbProxyType.getSelectedItem()));
        this.options.setProxyHost(this.tfProxyHost.getText());
        this.options.setProxyPort((Integer)this.spProxyPort.getValue());
        this.updateFromOptions();
    }

    private void setLabelAndMnemonic(JComponent aComponent, String aKey) {
        Constants.RES.setLabelAndMnemonic(aComponent, aKey);
    }

    private void initComponents() {
        this.chkbTsaEnabled = new JCheckBox();
        this.lblTsaUrl = new JLabel();
        this.tfTsaUrl = new JTextField();
        this.lblTsaUser = new JLabel();
        this.lblTsaPwd = new JLabel();
        this.tfTsaUser = new JTextField();
        this.pfTsaPwd = new JPasswordField();
        this.chkbOcspEnabled = new JCheckBox();
        this.btnTsaOK = new JButton();
        this.chkbCrlEnabled = new JCheckBox();
        this.pnlProxy = new JPanel();
        this.lblProxyHost = new JLabel();
        this.tfProxyHost = new JTextField();
        this.lblProxyType = new JLabel();
        this.cbProxyType = new JComboBox();
        this.spProxyPort = new JSpinner();
        this.lblTsaPolicy = new JLabel();
        this.tfTsaPolicy = new JTextField();
        this.lblOcspUrl = new JLabel();
        this.tfOcspUrl = new JTextField();
        this.cbTsaAuthn = new JComboBox();
        this.lblTsaAuthn = new JLabel();
        this.lblTsaHashAlg = new JLabel();
        this.tfTsaHashAlg = new JTextField();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TsaDialog.this.formComponentShown(evt);
            }

            public void componentHidden(ComponentEvent evt) {
                TsaDialog.this.formComponentHidden(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.chkbTsaEnabled.setText("Use timestamp server");
        this.chkbTsaEnabled.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.chkbTsaEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TsaDialog.this.chkbTsaEnabledActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.chkbTsaEnabled, gridBagConstraints);
        this.lblTsaUrl.setHorizontalAlignment(2);
        this.lblTsaUrl.setLabelFor(this.tfTsaUrl);
        this.lblTsaUrl.setText("TSA URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblTsaUrl, gridBagConstraints);
        this.tfTsaUrl.setMinimumSize(new Dimension(200, 20));
        this.tfTsaUrl.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfTsaUrl, gridBagConstraints);
        this.lblTsaUser.setHorizontalAlignment(2);
        this.lblTsaUser.setLabelFor(this.tfTsaUser);
        this.lblTsaUser.setText("TSA user");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblTsaUser, gridBagConstraints);
        this.lblTsaPwd.setHorizontalAlignment(2);
        this.lblTsaPwd.setLabelFor(this.pfTsaPwd);
        this.lblTsaPwd.setText("TSA password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblTsaPwd, gridBagConstraints);
        this.tfTsaUser.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfTsaUser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.pfTsaPwd, gridBagConstraints);
        this.chkbOcspEnabled.setText("Use OCSP");
        this.chkbOcspEnabled.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.chkbOcspEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TsaDialog.this.chkbTsaEnabledActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.chkbOcspEnabled, gridBagConstraints);
        this.btnTsaOK.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/back16.png")));
        this.btnTsaOK.setText("OK");
        this.btnTsaOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TsaDialog.this.btnTsaOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 2, 2, 5);
        this.getContentPane().add((Component)this.btnTsaOK, gridBagConstraints);
        this.chkbCrlEnabled.setText("Use CRL");
        this.chkbCrlEnabled.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.chkbCrlEnabled, gridBagConstraints);
        this.pnlProxy.setBorder(BorderFactory.createTitledBorder("Proxy"));
        this.pnlProxy.setLayout(new GridBagLayout());
        this.lblProxyHost.setHorizontalAlignment(2);
        this.lblProxyHost.setLabelFor(this.tfProxyHost);
        this.lblProxyHost.setText("Proxy host/port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.pnlProxy.add((Component)this.lblProxyHost, gridBagConstraints);
        this.tfProxyHost.setMinimumSize(new Dimension(200, 20));
        this.tfProxyHost.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.pnlProxy.add((Component)this.tfProxyHost, gridBagConstraints);
        this.lblProxyType.setHorizontalAlignment(2);
        this.lblProxyType.setLabelFor(this.cbProxyType);
        this.lblProxyType.setText("Proxy type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.pnlProxy.add((Component)this.lblProxyType, gridBagConstraints);
        this.cbProxyType.setMinimumSize(new Dimension(150, 20));
        this.cbProxyType.setPreferredSize(new Dimension(150, 20));
        this.cbProxyType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TsaDialog.this.cbProxyTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.pnlProxy.add((Component)this.cbProxyType, gridBagConstraints);
        this.spProxyPort.setModel(new SpinnerNumberModel(80, 0, 65535, 1));
        this.spProxyPort.setMinimumSize(new Dimension(50, 18));
        this.spProxyPort.setPreferredSize(new Dimension(50, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlProxy.add((Component)this.spProxyPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.pnlProxy, gridBagConstraints);
        this.lblTsaPolicy.setHorizontalAlignment(2);
        this.lblTsaPolicy.setLabelFor(this.tfTsaPolicy);
        this.lblTsaPolicy.setText("TSA policy OID");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblTsaPolicy, gridBagConstraints);
        this.tfTsaPolicy.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfTsaPolicy, gridBagConstraints);
        this.lblOcspUrl.setHorizontalAlignment(2);
        this.lblOcspUrl.setLabelFor(this.tfOcspUrl);
        this.lblOcspUrl.setText("External OCSP URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblOcspUrl, gridBagConstraints);
        this.tfOcspUrl.setMinimumSize(new Dimension(200, 20));
        this.tfOcspUrl.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfOcspUrl, gridBagConstraints);
        this.cbTsaAuthn.setMinimumSize(new Dimension(150, 20));
        this.cbTsaAuthn.setPreferredSize(new Dimension(150, 20));
        this.cbTsaAuthn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TsaDialog.this.cbTsaAuthnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.cbTsaAuthn, gridBagConstraints);
        this.lblTsaAuthn.setLabelFor(this.cbTsaAuthn);
        this.lblTsaAuthn.setText("TSA authentication");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblTsaAuthn, gridBagConstraints);
        this.lblTsaHashAlg.setHorizontalAlignment(2);
        this.lblTsaHashAlg.setLabelFor(this.tfTsaHashAlg);
        this.lblTsaHashAlg.setText("TSA hash algorithm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblTsaHashAlg, gridBagConstraints);
        this.tfTsaHashAlg.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfTsaHashAlg, gridBagConstraints);
    }

    private void cbTsaAuthnActionPerformed(ActionEvent evt) {
        this.refreshView();
        this.pack();
    }

    private void cbProxyTypeActionPerformed(ActionEvent evt) {
        this.refreshView();
        this.pack();
    }

    private void btnTsaOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void chkbTsaEnabledActionPerformed(ActionEvent evt) {
        this.updateEnabledStatus();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.updateFromOptions();
        this.updateEnabledStatus();
        this.refreshView();
        this.pack();
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.storeToOptions();
    }
}

