/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.crl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLInfo {
    private static final Logger LOGGER = Logger.getLogger(CRLInfo.class);
    private CRL[] crls;
    private long byteCount = 0L;
    private BasicSignerOptions options;
    private Certificate[] certChain;

    public CRLInfo(BasicSignerOptions anOptions, Certificate[] aChain) {
        if (anOptions == null || aChain == null) {
            throw new NullPointerException();
        }
        this.options = anOptions;
        this.certChain = aChain;
    }

    public CRL[] getCrls() {
        this.initCrls();
        return this.crls;
    }

    public long getByteCount() {
        this.initCrls();
        return this.byteCount;
    }

    private void initCrls() {
        if (!this.options.isCrlEnabledX() || this.crls != null) {
            return;
        }
        LOGGER.info((Object)Constants.RES.get("console.readingCRLs"));
        HashSet<String> urls = new HashSet<String>();
        for (Certificate cert : this.certChain) {
            if (!(cert instanceof X509Certificate)) continue;
            urls.addAll(this.getCrlUrls((X509Certificate)cert));
        }
        HashSet<CRL> crlSet = new HashSet<CRL>();
        for (String urlStr : urls) {
            try {
                LOGGER.info((Object)Constants.RES.get("console.crlinfo.loadCrl", urlStr));
                URL tmpUrl = new URL(urlStr);
                CountingInputStream inStream = new CountingInputStream(tmpUrl.openConnection(this.options.createProxy()).getInputStream());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                CRL crl = cf.generateCRL((InputStream)inStream);
                long tmpBytesRead = inStream.getByteCount();
                LOGGER.info((Object)Constants.RES.get("console.crlinfo.crlSize", String.valueOf(tmpBytesRead)));
                if (!crlSet.contains(crl)) {
                    this.byteCount += tmpBytesRead;
                    crlSet.add(crl);
                } else {
                    LOGGER.info((Object)Constants.RES.get("console.crlinfo.alreadyLoaded"));
                }
                inStream.close();
            }
            catch (MalformedURLException e) {
                LOGGER.warn((Object)"", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.warn((Object)"", (Throwable)e);
            }
            catch (CertificateException e) {
                LOGGER.warn((Object)"", (Throwable)e);
            }
            catch (CRLException e) {
                LOGGER.warn((Object)"", (Throwable)e);
            }
        }
        this.crls = crlSet.toArray(new CRL[crlSet.size()]);
    }

    private Set<String> getCrlUrls(X509Certificate aCert) {
        HashSet<String> tmpResult = new HashSet<String>();
        LOGGER.info((Object)Constants.RES.get("console.crlinfo.retrieveCrlUrl", aCert.getSubjectX500Principal().getName()));
        byte[] crlDPExtension = aCert.getExtensionValue(X509Extension.cRLDistributionPoints.getId());
        if (crlDPExtension != null) {
            CRLDistPoint crlDistPoints = null;
            try {
                crlDistPoints = CRLDistPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])crlDPExtension));
            }
            catch (IOException e) {
                LOGGER.warn((Object)"", (Throwable)e);
            }
            if (crlDistPoints != null) {
                DistributionPoint[] distPoints;
                block2: for (DistributionPoint dp : distPoints = crlDistPoints.getDistributionPoints()) {
                    DistributionPointName dpName = dp.getDistributionPoint();
                    GeneralNames generalNames = (GeneralNames)dpName.getName();
                    if (generalNames == null) continue;
                    GeneralName[] generalNameArr = generalNames.getNames();
                    if (generalNameArr != null) {
                        for (GeneralName generalName : generalNameArr) {
                            ASN1String derString;
                            String uri;
                            if (generalName.getTagNo() != 6 || (uri = (derString = (ASN1String)generalName.getName()).getString()) == null || !uri.startsWith("http")) continue;
                            LOGGER.info((Object)Constants.RES.get("console.crlinfo.foundCrlUri", uri));
                            tmpResult.add(uri);
                            continue block2;
                        }
                    }
                    LOGGER.info((Object)Constants.RES.get("console.crlinfo.noUrlInDistPoint"));
                }
            }
        } else {
            LOGGER.info((Object)Constants.RES.get("console.crlinfo.distPointNotSupported"));
        }
        return tmpResult;
    }
}

