/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.extcsp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.text.MessageFormat;
import java.util.LinkedList;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.extcsp.IExternalCryptoProvider;
import net.sf.jsignpdf.types.HashAlgorithm;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFoxy
implements IExternalCryptoProvider {
    private static final Logger LOGGER = Logger.getLogger(CloudFoxy.class);

    public static CloudFoxy getInstance() {
        return new CloudFoxy();
    }

    @Override
    public String getName() {
        return "CloudFoxy";
    }

    @Override
    public Certificate[] getChain(BasicSignerOptions options) {
        Certificate[] chain = null;
        String remoteAddress = options.getKsFile();
        if (remoteAddress == null || !remoteAddress.contains(":") || options.getKeyAlias() == null) {
            return null;
        }
        int cmdId = (int)(Math.random() * 100000.0);
        String cert_chain_request = MessageFormat.format(">{0}|\n>{1}:CHAIN|", options.getKeyAlias(), cmdId);
        String[] address = options.getKsFile().split(":");
        String hostname = address[0];
        int port = Integer.parseInt(address[1]);
        try {
            Socket socket = new Socket(hostname, port);
            OutputStream output = socket.getOutputStream();
            PrintWriter writer = new PrintWriter(output, true);
            writer.println(cert_chain_request);
            InputStream input = socket.getInputStream();
            BufferedReader reader_sock = new BufferedReader(new InputStreamReader(input));
            String line = reader_sock.readLine();
            socket.close();
            if (line == null) {
                return null;
            }
            String[] certChain = line.split(":");
            if (certChain.length < 2) {
                LOGGER.error((Object)Constants.RES.get("extcsp.nocert", "-"));
                return null;
            }
            if (certChain[1].length() < 5) {
                LOGGER.error((Object)Constants.RES.get("extcsp.nocert", certChain[1]));
                return null;
            }
            chain = new Certificate[certChain.length - 1];
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            for (int i = 1; i < certChain.length; ++i) {
                byte[] decodedBytes = Base64.decode((String)certChain[i]);
                ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);
                chain[i - 1] = certFactory.generateCertificate(in);
            }
        }
        catch (UnknownHostException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.nohost", hostname, ex.getMessage()));
            return null;
        }
        catch (IOException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.iohost", ex.getMessage()));
            return null;
        }
        catch (CertificateException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.certfactory", ex.getMessage()));
        }
        return chain;
    }

    @Override
    public byte[] getSignature(BasicSignerOptions options, byte[] fingerprint) {
        MessageDigest messageDigestInner;
        byte[] signature = null;
        HashAlgorithm hashAlgorithm = options.getHashAlgorithmX();
        if (hashAlgorithm != HashAlgorithm.SHA1 && hashAlgorithm != HashAlgorithm.SHA256) {
            LOGGER.error((Object)Constants.RES.get("extcsp.unknownhashalg", options.getHashAlgorithm().getAlgorithmName()));
            return null;
        }
        try {
            messageDigestInner = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigestInner.update(fingerprint, 0, fingerprint.length);
        byte[] hashInner = messageDigestInner.digest();
        StringBuilder hex = new StringBuilder();
        for (byte one_byte : hashInner) {
            hex.append(String.format("%02X", one_byte));
        }
        int cmdId = (int)(Math.random() * 100000.0);
        String signing_request = options.getKeyPasswdStr() != null ? MessageFormat.format(">{0}:{1}|\n>{2}:SIGN:{3}|", options.getKeyAlias(), options.getKeyPasswdStr(), cmdId, hex.toString()) : MessageFormat.format(">{0}|\n>{2}:SIGN:{3}|", options.getKeyAlias(), cmdId, hex.toString());
        String[] address = options.getKsFile().split(":");
        String hostname = address[0];
        int port = Integer.parseInt(address[1]);
        try {
            Socket socket = new Socket(hostname, port);
            OutputStream output = socket.getOutputStream();
            PrintWriter writer = new PrintWriter(output, true);
            writer.println(signing_request);
            InputStream input = socket.getInputStream();
            BufferedReader reader_sock = new BufferedReader(new InputStreamReader(input));
            String line = reader_sock.readLine();
            String[] signatureParts = line.split(":");
            socket.close();
            if (signatureParts.length < 2) {
                LOGGER.error((Object)Constants.RES.get("extcsp.nosignature"));
            } else if (signatureParts[1].length() < 5) {
                LOGGER.error((Object)Constants.RES.get("extcsp.nosignatureerr", signatureParts[1]));
            } else {
                int len = signatureParts[1].length();
                signature = new byte[len / 2];
                for (int i = 0; i < len; i += 2) {
                    signature[i / 2] = (byte)((Character.digit(signatureParts[1].charAt(i), 16) << 4) + Character.digit(signatureParts[1].charAt(i + 1), 16));
                }
            }
        }
        catch (UnknownHostException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.nohost", hostname, ex.getMessage()));
        }
        catch (IOException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.iohost", ex.getMessage()));
        }
        return signature;
    }

    @Override
    public LinkedList<String> getAliasesList(BasicSignerOptions options) throws NullPointerException {
        LinkedList<String> aliasList;
        if (options.getKsFile() == null || !options.getKsFile().contains(":")) {
            throw new NullPointerException(Constants.RES.get("error.keystoreNull"));
        }
        int cmdId = (int)(Math.random() * 100000.0);
        String[] address = options.getKsFile().split(":");
        try {
            Socket socket = new Socket(address[0], Integer.parseInt(address[1]));
            String alias_request = ">all readers\n>" + cmdId + ":ALIASES";
            OutputStream output = socket.getOutputStream();
            PrintWriter writer = new PrintWriter(output, true);
            writer.println(alias_request);
            InputStream input = socket.getInputStream();
            BufferedReader reader_sock = new BufferedReader(new InputStreamReader(input));
            String aliasesRaw = reader_sock.readLine();
            socket.close();
            String[] aliases_response = aliasesRaw.split(":");
            aliasList = new LinkedList<String>();
            if (aliases_response.length >= 2) {
                String[] aliases64 = aliases_response[1].split("\\|");
                boolean partCounter = false;
                for (String each_alias : aliases64) {
                    Charset utf8Charset = Charset.forName("UTF-8");
                    String name = utf8Charset.decode(ByteBuffer.wrap(Base64.decode((String)each_alias))).toString();
                    aliasList.add(name);
                }
            }
        }
        catch (UnknownHostException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.nohost", address[0], ex.getMessage()));
            throw new NullPointerException(Constants.RES.get("error.keystoreNull"));
        }
        catch (IOException ex) {
            LOGGER.error((Object)Constants.RES.get("extcsp.iohost", ex.getMessage()));
            throw new NullPointerException(Constants.RES.get("error.keystoreNull"));
        }
        catch (Exception ex) {
            throw new NullPointerException(Constants.RES.get("error.keystoreNull"));
        }
        return aliasList;
    }
}

