/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.preview;

import com.lowagie.text.pdf.PdfReader;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decrypt.PDFPassword;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.utils.PdfUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class Pdf2Image {
    private static final int JPEDAL_MAX_IMAGE_RENDER_SIZE = 4000000;
    private BasicSignerOptions options;

    public Pdf2Image(BasicSignerOptions anOpts) {
        if (anOpts == null) {
            throw new NullPointerException("Options have to be not-null");
        }
        this.options = anOpts;
    }

    public BufferedImage getImageForPage(int aPage) {
        BufferedImage tmpResult = null;
        for (String libname : Constants.PDF2IMAGE_LIBRARIES.split("\\s*,\\s*")) {
            if ("jpedal".equals(libname)) {
                tmpResult = this.getImageUsingJPedal(aPage);
            } else if ("pdfrenderer".equals(libname)) {
                tmpResult = this.getImageUsingPdfRenderer(aPage);
            } else if ("pdfbox".equals(libname)) {
                tmpResult = this.getImageUsingPdfBox(aPage);
            }
            if (tmpResult != null) break;
        }
        return tmpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImageUsingJPedal(int aPage) {
        BufferedImage tmpResult;
        block11: {
            tmpResult = null;
            PdfReader reader = null;
            PdfDecoder pdfDecoder = null;
            try {
                reader = PdfUtils.getPdfReader(this.options.getInFile(), this.options.getPdfOwnerPwdStrX().getBytes());
                if (!(4000000.0f > reader.getPageSize(aPage).getWidth() * reader.getPageSize(aPage).getHeight())) break block11;
                pdfDecoder = new PdfDecoder();
                try {
                    pdfDecoder.openPdfFile(this.options.getInFile(), this.options.getPdfOwnerPwdStrX());
                }
                catch (PdfException e) {
                    try {
                        pdfDecoder.openPdfFile(this.options.getInFile(), "");
                    }
                    catch (PdfException e1) {
                        pdfDecoder.openPdfFile(this.options.getInFile());
                    }
                }
                tmpResult = pdfDecoder.getPageAsImage(aPage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (pdfDecoder != null) {
                    pdfDecoder.closePdfFile();
                }
            }
        }
        return tmpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImageUsingPdfRenderer(int aPage) {
        BufferedImage tmpResult = null;
        RandomAccessFile raf = null;
        try {
            File file = new File(this.options.getInFile());
            raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            PDFFile pdffile = null;
            try {
                pdffile = new PDFFile((ByteBuffer)buf, new PDFPassword(this.options.getPdfOwnerPwdStrX()));
            }
            catch (PDFParseException ppe) {
                try {
                    pdffile = new PDFFile((ByteBuffer)buf, new PDFPassword(""));
                }
                catch (PDFParseException ppe2) {
                    pdffile = new PDFFile((ByteBuffer)buf);
                }
            }
            PDFPage page = pdffile.getPage(aPage);
            Rectangle rect = new Rectangle(0, 0, (int)page.getBBox().getWidth(), (int)page.getBBox().getHeight());
            tmpResult = (BufferedImage)page.getImage(rect.width, rect.height, (Rectangle2D)rect, null, true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tmpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImageUsingPdfBox(int aPage) {
        BufferedImage tmpResult = null;
        PDDocument tmpDoc = null;
        try {
            int resolution;
            tmpDoc = PDDocument.load((String)this.options.getInFile());
            if (tmpDoc.isEncrypted()) {
                tmpDoc.decrypt(this.options.getPdfOwnerPwdStrX());
            }
            try {
                resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (HeadlessException e) {
                resolution = 96;
            }
            PDPage page = (PDPage)tmpDoc.getDocumentCatalog().getAllPages().get(aPage - 1);
            tmpResult = page.convertToImage(1, resolution);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (tmpDoc != null) {
                try {
                    tmpDoc.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tmpResult;
    }
}

