/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.utils.KeyStoreUtils;

public class DynamicX509TrustManager
implements X509TrustManager {
    private final KeyStore trustStore;
    private final TrustManagerFactory trustManagerFactory;
    private X509TrustManager trustManager;

    public DynamicX509TrustManager() {
        try {
            this.trustStore = KeyStoreUtils.createTrustStore();
            this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.reloadTrustStore();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create TrustManager.", e);
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (Constants.RELAX_SSL_SECURITY) {
            try {
                this.trustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException cx) {
                try {
                    this.trustStore.setCertificateEntry(UUID.randomUUID().toString(), chain[0]);
                    this.reloadTrustStore();
                }
                catch (Exception e) {
                    throw new CertificateException("Unable to recreate TrustManager", e);
                }
                this.trustManager.checkServerTrusted(chain, authType);
            }
        } else {
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private void reloadTrustStore() throws KeyStoreException, NoSuchAlgorithmException {
        this.trustManagerFactory.init(this.trustStore);
        TrustManager[] tms = this.trustManagerFactory.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tms[i];
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }
}

