/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.types;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import net.sf.jsignpdf.preview.FinalPropertyChangeSupport;

public class RelRect {
    public static final String PROPERTY_COORDS = "coords";
    private final Float[] coords = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
    private Dimension imageSize = new Dimension(1, 1);
    private FinalPropertyChangeSupport pcs = new FinalPropertyChangeSupport(this);

    public boolean isValid() {
        for (Float tmpCoord : this.coords) {
            if (tmpCoord != null) continue;
            return false;
        }
        return true;
    }

    public int[] getP1() {
        return this.makeImgPoint(0);
    }

    public int[] getP2() {
        return this.makeImgPoint(2);
    }

    public void setStartPoint(Point aPoint) {
        this.setRelPoint(aPoint, 0);
    }

    public Float[] getCoords() {
        return this.coords;
    }

    public void setEndPoint(Point aPoint) {
        this.setRelPoint(aPoint, 2);
    }

    public void setImgSize(int newWidth, int newHeight) {
        if (newWidth < 1) {
            newWidth = 1;
        }
        if (newHeight < 1) {
            newHeight = 1;
        }
        this.imageSize.setSize(newWidth, newHeight);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private int[] makeImgPoint(int coordsOffset) {
        int x = Math.round(this.coords[coordsOffset].floatValue() * (float)this.imageSize.width);
        int y = this.imageSize.height - Math.round(this.coords[coordsOffset + 1].floatValue() * (float)this.imageSize.height);
        return new int[]{x, y};
    }

    private void setRelPoint(Point point, int offset) {
        Float[] oldVal = Arrays.copyOf(this.coords, this.coords.length);
        if (point == null) {
            this.coords[offset] = null;
            this.coords[offset + 1] = null;
        } else {
            this.coords[offset] = Float.valueOf((float)point.x / (float)this.imageSize.width);
            this.coords[offset + 1] = Float.valueOf(1.0f - (float)point.y / (float)this.imageSize.height);
        }
        this.pcs.firePropertyChange(PROPERTY_COORDS, oldVal, this.coords);
    }
}

