/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PKCS11Utils {
    private static final Logger LOGGER = Logger.getLogger(PKCS11Utils.class);

    public static String registerProvider(String configPath) {
        if (StringUtils.isEmpty((CharSequence)configPath)) {
            return null;
        }
        LOGGER.debug((Object)("Registering SunPKCS11 provider from configuration in " + configPath));
        File cfgFile = new File(configPath);
        String absolutePath = cfgFile.getAbsolutePath();
        if (cfgFile.isFile()) {
            try {
                Provider pkcs11Provider = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(String.class).newInstance(absolutePath);
                Security.addProvider(pkcs11Provider);
                String name = pkcs11Provider.getName();
                LOGGER.debug((Object)("SunPKCS11 provider registered with name " + name));
                return name;
            }
            catch (Exception e) {
                System.err.println("Unable to register SunPKCS11 security provider.");
                e.printStackTrace();
            }
        } else {
            System.err.println("The PKCS#11 provider is not registered. Configuration file doesn't exist: " + absolutePath);
        }
        return null;
    }

    public static void unregisterProvider(String providerName) {
        if (providerName != null) {
            LOGGER.debug((Object)("Removing security provider with name " + providerName));
            Security.removeProvider(providerName);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

