/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.utils.ConvertUtils;
import net.sf.jsignpdf.utils.KeyStoreUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PropertyProvider {
    public static final String NS_NULL_VALUE = "$$NULL$$";
    private static final Logger LOGGER = Logger.getLogger(KeyStoreUtils.class);
    public static final String PROPERTY_FILE = Constants.USER_HOME + "/" + ".JSignPdf";
    private static PropertyProvider provider = new PropertyProvider();
    private Properties properties = new Properties();

    protected PropertyProvider() {
        try {
            this.loadDefault();
        }
        catch (ProperyProviderException e) {
            LOGGER.warn((Object)e);
        }
    }

    public static PropertyProvider getInstance() {
        return provider;
    }

    public void loadProperties(String aFileName) throws ProperyProviderException {
        if (aFileName == null) {
            throw new ProperyProviderException("Property filename is null!");
        }
        this.loadProperties(new File(aFileName));
    }

    public void loadProperties(File aFile) throws ProperyProviderException {
        if (aFile != null && aFile.canRead()) {
            try {
                this.properties.load(new FileInputStream(aFile));
            }
            catch (Exception e) {
                throw new ProperyProviderException("Properties cannot be loaded", e);
            }
        } else {
            throw new ProperyProviderException("Property file " + aFile.getPath() + " doesn't exist.");
        }
    }

    public void loadProperties(InputStream anIS) throws ProperyProviderException {
        if (anIS != null) {
            try {
                this.properties.load(anIS);
            }
            catch (Exception e) {
                throw new ProperyProviderException("Properties cannot be loaded", e);
            }
        } else {
            throw new ProperyProviderException("InputStream can't be null.");
        }
    }

    public void setProperty(String anExpr) throws ProperyProviderException {
        int tmpPos;
        if (anExpr == null || (tmpPos = anExpr.indexOf(61)) <= -1) {
            throw new ProperyProviderException("Wrong setProperty(...) expression.");
        }
        this.setProperty(anExpr.substring(0, tmpPos), anExpr.substring(tmpPos + 1));
    }

    public void setProperty(String aKey, String aValue) {
        this.properties.setProperty(aKey, aValue == null ? "" : aValue);
    }

    public void setPropNullSensitive(String aKey, String aValue) {
        this.setProperty(aKey, aValue == null ? NS_NULL_VALUE : aValue);
    }

    public void setProperty(String aKey, boolean aValue) {
        this.properties.setProperty(aKey, String.valueOf(aValue));
    }

    public void setProperty(String aKey, int aValue) {
        this.properties.setProperty(aKey, String.valueOf(aValue));
    }

    public void setProperty(String aKey, float aValue) {
        this.properties.setProperty(aKey, String.valueOf(aValue));
    }

    public void removeProperty(String aKey) {
        this.properties.remove(aKey);
    }

    public String getProperty(String aKey) {
        return this.properties.getProperty(aKey);
    }

    public String getPropNullSensitive(String aKey) {
        String tmpValue = this.getProperty(aKey);
        return NS_NULL_VALUE.equals(tmpValue) ? null : tmpValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.clear();
        }
    }

    public void loadDefault() throws ProperyProviderException {
        this.loadProperties(PROPERTY_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(File aFile) throws ProperyProviderException {
        block6: {
            if (aFile != null) {
                try {
                    Properties properties = this.properties;
                    synchronized (properties) {
                        this.properties.store(new FileOutputStream(aFile), "Properties saved by PropertyProvider");
                        break block6;
                    }
                }
                catch (Exception e) {
                    throw new ProperyProviderException("Properties cannot be stored", e);
                }
            }
            throw new ProperyProviderException("Property-file is null!");
        }
    }

    public void saveProperties(String aFileName) throws ProperyProviderException {
        if (aFileName == null) {
            throw new ProperyProviderException("Property filename is null!");
        }
        this.saveProperties(new File(aFileName));
    }

    public void saveDefault() throws ProperyProviderException {
        this.saveProperties(PROPERTY_FILE);
    }

    public int getAsInt(String aKey) {
        return this.getAsInt(aKey, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAsInt(String aKey, int aDefault) {
        int tmpResult = aDefault;
        Properties properties = this.properties;
        synchronized (properties) {
            if (this.properties.containsKey(aKey)) {
                tmpResult = ConvertUtils.toInt(this.properties.getProperty(aKey), aDefault);
            }
        }
        return tmpResult;
    }

    public float getAsFloat(String aKey) {
        return this.getAsFloat(aKey, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getAsFloat(String aKey, float aDefault) {
        float tmpResult = aDefault;
        Properties properties = this.properties;
        synchronized (properties) {
            if (this.properties.containsKey(aKey)) {
                tmpResult = ConvertUtils.toFloat(this.properties.getProperty(aKey), aDefault);
            }
        }
        return tmpResult;
    }

    public long getAsLong(String aKey) {
        String tmpValue = this.properties.getProperty(aKey, "0");
        return Long.parseLong(tmpValue);
    }

    public boolean getAsBool(String aKey) {
        return this.getAsBool(aKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAsBool(String aKey, boolean aDefault) {
        boolean tmpResult = aDefault;
        Properties properties = this.properties;
        synchronized (properties) {
            if (this.properties.containsKey(aKey)) {
                tmpResult = ConvertUtils.toBoolean(this.properties.getProperty(aKey), aDefault);
            }
        }
        return tmpResult;
    }

    public boolean exists(String aKey) {
        return this.properties.containsKey(aKey);
    }

    public void checkMandatory(String aKey) throws ProperyProviderException {
        if (!this.properties.containsKey(aKey)) {
            throw new ProperyProviderException("Mandatory property '" + aKey + "' is missing!");
        }
    }

    public String getProperty(String aKey, String aDefault) {
        return this.properties.getProperty(aKey, aDefault);
    }

    public String getNotEmptyProperty(String aKey, String aDefault) {
        String tmpVal = this.properties.getProperty(aKey);
        return StringUtils.isEmpty((CharSequence)tmpVal) ? aDefault : tmpVal;
    }

    public static class ProperyProviderException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ProperyProviderException() {
        }

        public ProperyProviderException(String aMessage) {
            super(aMessage);
        }

        public ProperyProviderException(Throwable aCause) {
            super(aCause);
        }

        public ProperyProviderException(String aMessage, Throwable aCause) {
            super(aMessage, aCause);
        }
    }
}

