/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(ResourceProvider.class);
    private ResourceBundle bundle;

    public ResourceProvider(ResourceBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("ResourceBundle must be not-null.");
        }
        this.bundle = bundle;
    }

    public void setLabelAndMnemonic(JComponent aComponent, String aKey) {
        String tmpLabelText = this.get(aKey);
        int tmpMnemIndex = this.getMnemonicIndex(aKey);
        if (aComponent instanceof JLabel) {
            JLabel tmpLabel = (JLabel)aComponent;
            tmpLabel.setText(tmpLabelText);
            if (tmpMnemIndex > -1) {
                tmpLabel.setDisplayedMnemonic(tmpLabelText.toLowerCase().charAt(tmpMnemIndex));
                tmpLabel.setDisplayedMnemonicIndex(tmpMnemIndex);
            }
        } else if (aComponent instanceof AbstractButton) {
            AbstractButton tmpBtn = (AbstractButton)aComponent;
            tmpBtn.setText(tmpLabelText);
            if (tmpMnemIndex > -1) {
                tmpBtn.setMnemonic(tmpLabelText.toLowerCase().charAt(tmpMnemIndex));
            }
        } else if (aComponent instanceof JPanel) {
            JPanel panel = (JPanel)aComponent;
            if (panel.getBorder() instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)panel.getBorder();
                titledBorder.setTitle(tmpLabelText);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String get(String aKey) {
        String tmpMessage = null;
        try {
            tmpMessage = this.bundle.getString(aKey);
        }
        catch (MissingResourceException e) {
            LOGGER.warn((Object)("Missing resource " + aKey), (Throwable)e);
        }
        tmpMessage = tmpMessage == null ? aKey : tmpMessage.replaceAll("&([^&])", "$1");
        return tmpMessage;
    }

    public int getMnemonicIndex(String aKey) {
        String tmpMessage = null;
        try {
            tmpMessage = this.bundle.getString(aKey);
        }
        catch (MissingResourceException e) {
            LOGGER.warn((Object)("Missing resource " + aKey), (Throwable)e);
        }
        int tmpResult = -1;
        if (tmpMessage != null) {
            int tmpPos;
            int searchFrom = 0;
            int tmpDoubles = 0;
            int tmpLen = tmpMessage.length();
            do {
                if ((tmpPos = tmpMessage.indexOf(38, searchFrom)) == tmpLen - 1) {
                    tmpPos = -1;
                }
                if (tmpPos <= -1) continue;
                if (tmpMessage.charAt(tmpPos + 1) != '&') {
                    tmpResult = tmpPos - tmpDoubles;
                    continue;
                }
                searchFrom = tmpPos + 2;
                ++tmpDoubles;
            } while (tmpPos != -1 && tmpResult == -1 && searchFrom < tmpLen);
        }
        return tmpResult;
    }

    public String get(String aKey, String ... anArgs) {
        String tmpMessage = this.get(aKey);
        if (aKey == tmpMessage || anArgs == null || anArgs.length == 0) {
            return tmpMessage;
        }
        MessageFormat tmpFormat = new MessageFormat(tmpMessage);
        return tmpFormat.format(anArgs);
    }
}

