/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.verify;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.jsignpdf.verify.CertificateWithAlias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificatesTableModel
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_ALIAS = 0;
    public static final int COLUMN_DN = 1;
    public static final int COLUMN_VALID_FROM = 2;
    public static final int COLUMN_VALID_TO = 3;
    private List<CertificateWithAlias> data = Collections.synchronizedList(new ArrayList());

    public void addRow(String anAlias, X509Certificate aCertif) {
        if (aCertif == null) {
            throw new NullPointerException("Certificate can't be null.");
        }
        this.data.add(new CertificateWithAlias(anAlias, aCertif));
        int tmpPos = this.data.size() - 1;
        this.fireTableRowsInserted(tmpPos, tmpPos);
    }

    public void clearModel() {
        if (!this.data.isEmpty()) {
            int tmpLastPos = this.data.size() - 1;
            this.data.clear();
            this.fireTableRowsDeleted(0, tmpLastPos);
        }
    }

    public List<CertificateWithAlias> getCertificates() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CertificateWithAlias tmpCert = this.data.get(rowIndex);
        Object tmpResult = null;
        switch (columnIndex) {
            case 0: {
                tmpResult = tmpCert.getAlias();
                break;
            }
            case 1: {
                tmpResult = tmpCert.getCertificate().getIssuerX500Principal().getName();
                break;
            }
            case 2: {
                tmpResult = tmpCert.getCertificate().getNotBefore();
                break;
            }
            case 3: {
                tmpResult = tmpCert.getCertificate().getNotAfter();
            }
        }
        return tmpResult;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class tmpResult;
        switch (columnIndex) {
            case 2: 
            case 3: {
                tmpResult = Date.class;
                break;
            }
            default: {
                tmpResult = String.class;
            }
        }
        return tmpResult;
    }

    @Override
    public String getColumnName(int column) {
        String tmpResult = null;
        switch (column) {
            case 0: {
                tmpResult = "Alias";
                break;
            }
            case 1: {
                tmpResult = "DN";
                break;
            }
            case 2: {
                tmpResult = "Valid from";
                break;
            }
            case 3: {
                tmpResult = "Valid to";
            }
        }
        return tmpResult;
    }
}

