/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.verify;

import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.jsignpdf.utils.PdfUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class SignatureCounter {
    public static void main(String[] args) {
        Option optHelp = new Option("h", "help", false, "print this message");
        Option optDebug = new Option("d", "debug", false, "enables debug output");
        Option optNames = new Option("n", "names", false, "print comma separated signature names instead of the count");
        Option optPasswd = new Option("p", "password", true, "set password for opening PDF");
        optPasswd.setArgName("password");
        Options options = new Options();
        options.addOption(optHelp);
        options.addOption(optDebug);
        options.addOption(optNames);
        options.addOption(optPasswd);
        CommandLine line = null;
        try {
            PosixParser parser = new PosixParser();
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Unable to parse command line (Use -h for the help)\n" + exp.getMessage());
            System.exit(1);
        }
        String[] tmpArgs = line.getArgs();
        if (line.hasOption("h") || args == null || args.length == 0) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(70, "java -jar SignatureCounter.jar [file1.pdf [file2.pdf ...]]", "JSignPdf SignatureCounter is a command line tool which prints count of signatures in given PDF document.", options, null, true);
        } else {
            byte[] tmpPasswd = null;
            if (line.hasOption("p")) {
                tmpPasswd = line.getOptionValue("p").getBytes();
            }
            boolean debug = line.hasOption("d");
            boolean names = line.hasOption("n");
            for (String tmpFilePath : tmpArgs) {
                File tmpFile;
                if (debug) {
                    System.out.print("Counting signatures in " + tmpFilePath + ": ");
                }
                if (!(tmpFile = new File(tmpFilePath)).canRead()) {
                    System.err.println("Couldn't read the file. Check the path and permissions: " + tmpFilePath);
                    System.exit(5);
                }
                try {
                    PdfReader pdfReader = PdfUtils.getPdfReader(tmpFilePath, tmpPasswd);
                    List sigNames = pdfReader.getAcroFields().getSignatureNames();
                    if (names) {
                        boolean isNotFirst = false;
                        for (String sig : sigNames) {
                            if (isNotFirst) {
                                System.out.println(",");
                            } else {
                                isNotFirst = true;
                            }
                            System.out.println(sig);
                        }
                        continue;
                    }
                    System.out.println(sigNames.size());
                    if (!debug) continue;
                    System.out.println("Signature names: " + sigNames);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(6);
                }
            }
        }
    }
}

