/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.verify;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.OcspClientBouncyCastle;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsignpdf.utils.KeyStoreUtils;
import net.sf.jsignpdf.utils.PdfUtils;
import net.sf.jsignpdf.verify.SignatureVerification;
import net.sf.jsignpdf.verify.VerificationResult;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierLogic {
    private KeyStore kall;
    private boolean failFast;

    public VerifierLogic(String aType, String aKeyStore, String aPasswd) {
        this.reinitKeystore(aType, aKeyStore, aPasswd);
    }

    public Exception addX509CertFile(String aPath) {
        try {
            CertificateFactory tmpCertFac = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> tmpCertCol = tmpCertFac.generateCertificates(new FileInputStream(aPath));
            for (X509Certificate x509Certificate : tmpCertCol) {
                this.kall.setCertificateEntry(x509Certificate.getSerialNumber().toString(36), x509Certificate);
            }
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public void reinitKeystore(String aKsType, String aKeyStore, String aPasswd) {
        try {
            this.kall = KeyStoreUtils.createKeyStore();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        KeyStore ksToImport = KeyStoreUtils.loadKeyStore(aKsType, aKeyStore, aPasswd);
        if (ksToImport != null) {
            KeyStoreUtils.copyCertificates(ksToImport, this.kall);
        }
    }

    public VerificationResult verify(String aFileName, byte[] aPassword) {
        try {
            return this.verify(PdfUtils.getPdfReader(aFileName, aPassword));
        }
        catch (Exception e) {
            VerificationResult tmpResult = new VerificationResult();
            tmpResult.setException(e);
            return tmpResult;
        }
    }

    public VerificationResult verify(byte[] content, byte[] aPassword) {
        try {
            return this.verify(PdfUtils.getPdfReader(content, aPassword));
        }
        catch (Exception e) {
            VerificationResult tmpResult = new VerificationResult();
            tmpResult.setException(e);
            return tmpResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerificationResult verify(PdfReader tmpReader) {
        VerificationResult tmpResult = new VerificationResult();
        try {
            AcroFields tmpAcroFields = tmpReader.getAcroFields();
            List tmpNames = tmpAcroFields.getSignatureNames();
            tmpResult.setTotalRevisions(tmpAcroFields.getTotalRevisions());
            int lastSignatureIdx = tmpNames.size() - 1;
            if (lastSignatureIdx < 0) {
                tmpResult.setWithoutSignature();
            }
            for (int i = lastSignatureIdx; i >= 0; --i) {
                String verifyCertificate;
                String certificateAlias;
                String name = (String)tmpNames.get(i);
                SignatureVerification tmpVerif = new SignatureVerification(name);
                tmpVerif.setLastSignature(i == lastSignatureIdx);
                tmpVerif.setWholeDocument(tmpAcroFields.signatureCoversWholeDocument(name));
                tmpVerif.setRevision(tmpAcroFields.getRevision(name));
                PdfPKCS7 pk = tmpAcroFields.verifySignature(name);
                TimeStampToken tst = pk.getTimeStampToken();
                tmpVerif.setTsTokenPresent(tst != null);
                tmpVerif.setTsTokenValidationResult(this.validateTimeStampToken(tst));
                tmpVerif.setDate(pk.getTimeStampDate() != null ? pk.getTimeStampDate() : pk.getSignDate());
                tmpVerif.setLocation(pk.getLocation());
                tmpVerif.setReason(pk.getReason());
                tmpVerif.setSignName(pk.getSignName());
                Certificate[] pkc = pk.getCertificates();
                PdfPKCS7.X509Name tmpX509Name = PdfPKCS7.getSubjectFields((X509Certificate)pk.getSigningCertificate());
                tmpVerif.setSubject(tmpX509Name.toString());
                tmpVerif.setModified(!pk.verify());
                tmpVerif.setOcspPresent(pk.getOcsp() != null);
                tmpVerif.setOcspValid(pk.isRevocationValid());
                tmpVerif.setCrlPresent(pk.getCRLs() != null && pk.getCRLs().size() > 0);
                tmpVerif.setFails(PdfPKCS7.verifyCertificates((Certificate[])pkc, (KeyStore)this.kall, (Collection)pk.getCRLs(), (Calendar)tmpVerif.getDate()));
                tmpVerif.setSigningCertificate(pk.getSigningCertificate());
                List<Certificate> certList = Arrays.asList(pkc);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                CertPath cp = cf.generateCertPath(certList);
                tmpVerif.setCertPath(cp);
                if (!tmpVerif.isOcspValid()) {
                    String url = PdfPKCS7.getOCSPURL((X509Certificate)pk.getSigningCertificate());
                    tmpVerif.setOcspInCertPresent(url != null);
                    if (url != null) {
                        tmpVerif.setOcspInCertValid(VerifierLogic.validateCertificateOCSP(pk.getSignCertificateChain(), url));
                    }
                }
                if ((certificateAlias = this.kall.getCertificateAlias(pk.getSigningCertificate())) != null && (verifyCertificate = PdfPKCS7.verifyCertificate((X509Certificate)pk.getSigningCertificate(), (Collection)pk.getCRLs(), (Calendar)tmpVerif.getDate())) == null) {
                    tmpVerif.setSignCertTrustedAndValid(true);
                }
                InputStream revision = tmpAcroFields.extractRevision(name);
                try {
                    PdfReader revisionReader = new PdfReader(revision);
                    tmpVerif.setCertLevelCode(revisionReader.getCertificationLevel());
                }
                finally {
                    if (revision != null) {
                        revision.close();
                    }
                }
                tmpResult.addVerification(tmpVerif);
                if (!this.failFast || !tmpVerif.containsError()) continue;
                return tmpResult;
            }
        }
        catch (Exception e) {
            tmpResult.setException(e);
        }
        return tmpResult;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public InputStream extractRevision(String aFileName, byte[] aPassword, String aSignatureName) throws IOException {
        PdfReader tmpReader = PdfUtils.getPdfReader(aFileName, aPassword);
        AcroFields tmpAcroFields = tmpReader.getAcroFields();
        return tmpAcroFields.extractRevision(aSignatureName);
    }

    public KeyStore getKeyStore() {
        return this.kall;
    }

    public Exception validateTimeStampToken(TimeStampToken token) {
        if (token == null) {
            return null;
        }
        try {
            SignerId signer = token.getSID();
            X509Certificate certificate = null;
            X500Name sign_cert_issuer = signer.getIssuer();
            BigInteger sign_cert_serial = signer.getSerialNumber();
            CertStore store = token.getCertificatesAndCRLs("Collection", "BC");
            Collection<? extends Certificate> certs = store.getCertificates(null);
            for (X509Certificate x509Certificate : certs) {
                if (!x509Certificate.getIssuerX500Principal().equals(sign_cert_issuer) || !x509Certificate.getSerialNumber().equals(sign_cert_serial)) continue;
                certificate = x509Certificate;
                break;
            }
            if (certificate == null) {
                throw new TSPException("Missing signing certificate for TSA.");
            }
            if (certs.size() == 1) {
                boolean bl = PdfPKCS7.verifyTimestampCertificates((TimeStampToken)token, (KeyStore)this.kall, null);
                if (!bl) {
                    throw new Exception("Timestamp certificate can't be verified.");
                }
            } else {
                int n = certs.size();
                Certificate[] array = certs.toArray(new Certificate[n]);
                Certificate[] certArray = new Certificate[n];
                for (int i = 0; i < n; ++i) {
                    certArray[i] = array[n - 1 - i];
                }
                Object[] verifyCertificates = PdfPKCS7.verifyCertificates((Certificate[])certArray, (KeyStore)this.kall, null, null);
                if (verifyCertificates != null) {
                    throw new Exception("Timestamp certificate can't be verified.");
                }
            }
            SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().build(certificate);
            token.validate(signerInformationVerifier);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    private static boolean validateCertificateOCSP(Certificate[] pkc, String url) {
        if (pkc.length < 2) {
            return false;
        }
        try {
            X509Certificate sigcer = (X509Certificate)pkc[0];
            X509Certificate isscer = (X509Certificate)pkc[1];
            OcspClientBouncyCastle ocspClient = new OcspClientBouncyCastle(sigcer, isscer, url);
            byte[] encoded = ocspClient.getEncoded();
            ASN1InputStream inp = new ASN1InputStream(encoded);
            BasicOCSPResponse resp = BasicOCSPResponse.getInstance((Object)inp.readObject());
            BasicOCSPResp basicResp = new BasicOCSPResp(resp);
            SingleResp sr = basicResp.getResponses()[0];
            CertificateID cid = sr.getCertID();
            CertificateID tis = new CertificateID("1.3.14.3.2.26", isscer, sigcer.getSerialNumber());
            return tis.equals((Object)cid);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, Integer> getValidationCodes(VerificationResult verResult) {
        HashMap<String, Integer> validationCodes = new HashMap<String, Integer>();
        for (SignatureVerification verification : verResult.getVerifications()) {
            validationCodes.put(verification.getName(), verification.getValidationCode());
        }
        return validationCodes;
    }
}

