/*
 * Decompiled with CFR 0.152.
 */
package com.mlsc;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;

public class DBClient {
    private DataSource dataSource;

    public void init(String url, String username, String passwd) {
        try {
            Properties p = new Properties();
            p.put("url", url);
            if (username != null && !username.trim().equals("") && passwd != null && !passwd.trim().equals("")) {
                p.put("username", username);
                p.put("password", passwd);
            }
            p.put("driverClassName", "org.apache.phoenix.jdbc.PhoenixDriver");
            p.put("defaultAutoCommit", "false");
            p.put("defaultReadOnly", "false");
            p.put("minIdle", "1");
            p.put("maxActive", "200");
            p.put("initialSize", "2");
            p.put("testWhileIdle", "true");
            p.put("validationQuery", "select * from test");
            p.put("testOnBorrow", "false");
            p.put("testOnReturn", "false");
            p.put("maxWait", "60000");
            p.put("minEvictableIdleTimeMillis", "300000");
            p.put("timeBetweenEvictionRunsMillis", "60000");
            this.dataSource = DruidDataSourceFactory.createDataSource((Properties)p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean upsertMuti(String[] sqls) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            Statement stmt = conn.createStatement();
            String[] stringArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String sql = stringArray[n2];
                stmt.execute(sql);
                ++n2;
            }
            conn.commit();
            stmt.close();
            conn.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean upsert(String sql) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            conn.commit();
            stmt.close();
            conn.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static String join(String join, Collection<String> strCol) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String a : strCol) {
            if (++i == strCol.size()) {
                sb.append(a);
                continue;
            }
            sb.append(a).append(join);
        }
        return new String(sb);
    }

    public String[] query(String sql) {
        ArrayList<String> lsResults = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            ResultSet rs = conn.createStatement().executeQuery(sql);
            ResultSetMetaData data = rs.getMetaData();
            int numberOfColumns = data.getColumnCount();
            ArrayList<String> lsRows = new ArrayList<String>();
            int i = 1;
            while (i <= numberOfColumns) {
                lsRows.add(data.getColumnName(i));
                ++i;
            }
            lsResults.add(DBClient.join("\t", lsRows));
            lsRows.clear();
            while (rs.next()) {
                i = 1;
                while (i <= numberOfColumns) {
                    lsRows.add(rs.getString(i));
                    ++i;
                }
                lsResults.add(DBClient.join("\t", lsRows));
                lsRows.clear();
            }
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return lsResults.toArray(new String[lsResults.size()]);
    }

    public static void main(String[] args) {
        DBClient pc = new DBClient();
        pc.init("jdbc:phoenix:192.168.252.131,192.168.252.132,192.168.252.133", null, null);
        String[] stringArray = pc.query("select * from airreal limit 1");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            System.out.println(a);
            ++n2;
        }
    }
}

