/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PerformanceEvaluationCommons;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class HFilePerformanceEvaluation {
    private static final int ROW_LENGTH = 10;
    private static final int ROW_COUNT = 1000000;
    private static final int RFILE_BLOCKSIZE = 8192;
    static final Log LOG = LogFactory.getLog(HFilePerformanceEvaluation.class.getName());

    static byte[] format(int i) {
        String v = Integer.toString(i);
        return Bytes.toBytes("0000000000".substring(v.length()) + v);
    }

    static ImmutableBytesWritable format(int i, ImmutableBytesWritable w) {
        w.set(HFilePerformanceEvaluation.format(i));
        return w;
    }

    private void runBenchmarks() throws Exception {
        Path mf;
        final Configuration conf = new Configuration();
        final FileSystem fs = FileSystem.get(conf);
        if (fs.exists(mf = fs.makeQualified(new Path("performanceevaluation.mapfile")))) {
            fs.delete(mf, true);
        }
        this.runBenchmark(new SequentialWriteBenchmark(conf, fs, mf, 1000000), 1000000);
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new UniformRandomSmallScan(conf, fs, mf, 1000000), 1000000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new UniformRandomReadBenchmark(conf, fs, mf, 1000000), 1000000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new GaussianRandomReadBenchmark(conf, fs, mf, 1000000), 1000000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    HFilePerformanceEvaluation.this.runBenchmark(new SequentialReadBenchmark(conf, fs, mf, 1000000), 1000000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void runBenchmark(RowOrientedBenchmark benchmark, int rowCount) throws Exception {
        LOG.info("Running " + benchmark.getClass().getSimpleName() + " for " + rowCount + " rows.");
        long elapsedTime = benchmark.run();
        LOG.info("Running " + benchmark.getClass().getSimpleName() + " for " + rowCount + " rows took " + elapsedTime + "ms.");
    }

    public static void main(String[] args) throws Exception {
        new HFilePerformanceEvaluation().runBenchmarks();
    }

    static class GaussianRandomReadBenchmark
    extends ReadBenchmark {
        private RandomData randomData = new RandomDataImpl();

        public GaussianRandomReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            HFileScanner scanner = this.reader.getScanner(false, true);
            byte[] gaussianRandomRowBytes = this.getGaussianRandomRowBytes();
            scanner.seekTo(gaussianRandomRowBytes);
            for (int ii = 0; ii < 30; ++ii) {
                if (!scanner.next()) {
                    LOG.info("NOTHING FOLLOWS");
                    return;
                }
                scanner.getKey();
                scanner.getValue();
            }
        }

        private byte[] getGaussianRandomRowBytes() {
            int r = (int)this.randomData.nextGaussian((double)this.totalRows / 2.0, (double)this.totalRows / 10.0);
            return HFilePerformanceEvaluation.format(Math.min(this.totalRows, Math.max(r, 0)));
        }
    }

    static class UniformRandomSmallScan
    extends ReadBenchmark {
        private Random random = new Random();

        public UniformRandomSmallScan(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows / 10);
        }

        @Override
        void doRow(int i) throws Exception {
            byte[] b;
            HFileScanner scanner = this.reader.getScanner(false, false);
            if (scanner.seekTo(b = this.getRandomRow()) != 0) {
                LOG.info("Nonexistent row: " + new String(b));
                return;
            }
            ByteBuffer k = scanner.getKey();
            PerformanceEvaluationCommons.assertKey(b, k);
            for (int ii = 0; ii < 30; ++ii) {
                if (!scanner.next()) {
                    LOG.info("NOTHING FOLLOWS");
                    return;
                }
                ByteBuffer v = scanner.getValue();
                PerformanceEvaluationCommons.assertValueSize(v.limit(), 10);
            }
        }

        private byte[] getRandomRow() {
            return HFilePerformanceEvaluation.format(this.random.nextInt(this.totalRows));
        }
    }

    static class UniformRandomReadBenchmark
    extends ReadBenchmark {
        private Random random = new Random();

        public UniformRandomReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            byte[] b;
            HFileScanner scanner = this.reader.getScanner(false, true);
            if (scanner.seekTo(b = this.getRandomRow()) < 0) {
                LOG.info("Not able to seekTo " + new String(b));
                return;
            }
            ByteBuffer k = scanner.getKey();
            PerformanceEvaluationCommons.assertKey(b, k);
            ByteBuffer v = scanner.getValue();
            PerformanceEvaluationCommons.assertValueSize(v.limit(), 10);
        }

        private byte[] getRandomRow() {
            return HFilePerformanceEvaluation.format(this.random.nextInt(this.totalRows));
        }
    }

    static class SequentialReadBenchmark
    extends ReadBenchmark {
        private HFileScanner scanner;

        public SequentialReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            super.setUp();
            this.scanner = this.reader.getScanner(false, false);
            this.scanner.seekTo();
        }

        @Override
        void doRow(int i) throws Exception {
            if (this.scanner.next()) {
                ByteBuffer k = this.scanner.getKey();
                PerformanceEvaluationCommons.assertKey(HFilePerformanceEvaluation.format(i + 1), k);
                ByteBuffer v = this.scanner.getValue();
                PerformanceEvaluationCommons.assertValueSize(v.limit(), 10);
            }
        }

        @Override
        protected int getReportingPeriod() {
            return this.totalRows;
        }
    }

    static abstract class ReadBenchmark
    extends RowOrientedBenchmark {
        protected HFile.Reader reader;

        public ReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            this.reader = HFile.createReader(this.fs, this.mf, new CacheConfig(this.conf), this.conf);
            this.reader.loadFileInfo();
        }

        @Override
        void tearDown() throws Exception {
            this.reader.close();
        }
    }

    static class SequentialWriteBenchmark
    extends RowOrientedBenchmark {
        protected HFile.Writer writer;
        private Random random = new Random();
        private byte[] bytes = new byte[10];

        public SequentialWriteBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            HFileContext hFileContext = new HFileContextBuilder().withBlockSize(8192).build();
            this.writer = HFile.getWriterFactoryNoCache(this.conf).withPath(this.fs, this.mf).withFileContext(hFileContext).withComparator(new KeyValue.RawBytesComparator()).create();
        }

        @Override
        void doRow(int i) throws Exception {
            this.writer.append(HFilePerformanceEvaluation.format(i), this.generateValue());
        }

        private byte[] generateValue() {
            this.random.nextBytes(this.bytes);
            return this.bytes;
        }

        @Override
        protected int getReportingPeriod() {
            return this.totalRows;
        }

        @Override
        void tearDown() throws Exception {
            this.writer.close();
        }
    }

    static abstract class RowOrientedBenchmark {
        protected final Configuration conf;
        protected final FileSystem fs;
        protected final Path mf;
        protected final int totalRows;

        public RowOrientedBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            this.conf = conf;
            this.fs = fs;
            this.mf = mf;
            this.totalRows = totalRows;
        }

        void setUp() throws Exception {
        }

        abstract void doRow(int var1) throws Exception;

        protected int getReportingPeriod() {
            return this.totalRows / 10;
        }

        void tearDown() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long run() throws Exception {
            long elapsedTime;
            this.setUp();
            long startTime = System.currentTimeMillis();
            try {
                for (int i = 0; i < this.totalRows; ++i) {
                    if (i > 0 && i % this.getReportingPeriod() == 0) {
                        LOG.info("Processed " + i + " rows.");
                    }
                    this.doRow(i);
                }
                elapsedTime = System.currentTimeMillis() - startTime;
            }
            finally {
                this.tearDown();
            }
            return elapsedTime;
        }
    }
}

