/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

class MockRegionServerServices
implements RegionServerServices {
    private final Map<String, HRegion> regions = new HashMap<String, HRegion>();
    private boolean stopping = false;
    private final ConcurrentSkipListMap<byte[], Boolean> rit = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private HFileSystem hfs = null;
    private ZooKeeperWatcher zkw = null;
    private ServerName serverName = null;
    private RpcServerInterface rpcServer = null;
    private volatile boolean abortRequested;

    MockRegionServerServices(ZooKeeperWatcher zkw) {
        this.zkw = zkw;
    }

    MockRegionServerServices(ZooKeeperWatcher zkw, ServerName serverName) {
        this.zkw = zkw;
        this.serverName = serverName;
    }

    MockRegionServerServices() {
        this(null);
    }

    @Override
    public boolean removeFromOnlineRegions(HRegion r, ServerName destination) {
        return this.regions.remove(r.getRegionInfo().getEncodedName()) != null;
    }

    @Override
    public HRegion getFromOnlineRegions(String encodedRegionName) {
        return this.regions.get(encodedRegionName);
    }

    @Override
    public List<HRegion> getOnlineRegions(TableName tableName) throws IOException {
        return null;
    }

    @Override
    public void addToOnlineRegions(HRegion r) {
        this.regions.put(r.getRegionInfo().getEncodedName(), r);
    }

    @Override
    public void postOpenDeployTasks(HRegion r, CatalogTracker ct) throws KeeperException, IOException {
        this.addToOnlineRegions(r);
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return this.rpcServer;
    }

    public void setRpcServer(RpcServerInterface rpc) {
        this.rpcServer = rpc;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.rit;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return null;
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return null;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return null;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zkw;
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    @Override
    public TableLockManager getTableLockManager() {
        return new TableLockManager.NullTableLockManager();
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    @Override
    public void abort(String why, Throwable e) {
        this.abortRequested = true;
        this.stop(why);
    }

    @Override
    public void stop(String why) {
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    @Override
    public boolean isAborted() {
        return this.abortRequested;
    }

    @Override
    public HFileSystem getFileSystem() {
        return this.hfs;
    }

    public void setFileSystem(FileSystem hfs) {
        this.hfs = (HFileSystem)hfs;
    }

    @Override
    public Leases getLeases() {
        return null;
    }

    @Override
    public HLog getWAL(HRegionInfo regionInfo) throws IOException {
        return null;
    }

    @Override
    public ExecutorService getExecutorService() {
        return null;
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    @Override
    public Map<String, HRegion> getRecoveringRegions() {
        return null;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param) {
        return 0;
    }

    @Override
    public ServerNonceManager getNonceManager() {
        return null;
    }
}

