/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellUtil {
    @Test
    public void testOverlappingKeys() {
        byte[] empty = HConstants.EMPTY_BYTE_ARRAY;
        byte[] a = Bytes.toBytes("a");
        byte[] b = Bytes.toBytes("b");
        byte[] c = Bytes.toBytes("c");
        byte[] d = Bytes.toBytes("d");
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, c, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(b, c, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, c, b, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, d, b, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(b, c, a, d));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, b, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, b, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, empty, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, empty, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, empty));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, empty, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(a, b, c, d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, d, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, c, d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, c, empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, d, empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, d, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, empty, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(d, empty, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, empty, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, empty, a));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(a, b, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(empty, b, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(empty, a, b, c));
    }
}

