/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.RandomStringGenerator;
import org.apache.hadoop.hbase.RandomStringGeneratorImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestCompatibilitySingletonFactory {
    private static final int ITERATIONS = 100000;
    private static final Random RANDOM = new Random();

    @Test
    public void testGetInstance() throws Exception {
        ArrayList<TestCompatibilitySingletonFactoryCallable> callables = new ArrayList<TestCompatibilitySingletonFactoryCallable>(100000);
        ArrayList resultStrings = new ArrayList(100000);
        for (int i = 0; i < 100000; ++i) {
            callables.add(new TestCompatibilitySingletonFactoryCallable());
        }
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        List futures = executorService.invokeAll(callables);
        for (Future f : futures) {
            resultStrings.add(f.get());
        }
        String firstString = (String)resultStrings.get(0);
        for (String s : resultStrings) {
            Assert.assertEquals((Object)firstString, (Object)s);
        }
        Assert.assertNotEquals((Object)new RandomStringGeneratorImpl().getRandString(), (Object)firstString);
    }

    private class TestCompatibilitySingletonFactoryCallable
    implements Callable<String> {
        private TestCompatibilitySingletonFactoryCallable() {
        }

        @Override
        public String call() throws Exception {
            Thread.sleep(RANDOM.nextInt(10));
            RandomStringGenerator instance = CompatibilitySingletonFactory.getInstance(RandomStringGenerator.class);
            return instance.getRandString();
        }
    }
}

