/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestFullLogReconstruction {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLE_NAME = Bytes.toBytes("tabletest");
    private static final byte[] FAMILY = Bytes.toBytes("family");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setBoolean("dfs.support.append", true);
        c.setInt("heartbeat.recheck.interval", 5000);
        c.setInt("dfs.heartbeat.interval", 1);
        c.setInt("dfs.socket.timeout", 5000);
        c.setInt("ipc.client.connect.max.retries", 1);
        c.setInt("dfs.client.block.recovery.retries", 1);
        c.setInt("zookeeper.session.timeout", 1000);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(timeout=300000L)
    public void testReconstruction() throws Exception {
        HTable table = TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.createMultiRegions(table, Bytes.toBytes("family"));
        int initialCount = TEST_UTIL.loadTable(table, FAMILY);
        int count = TEST_UTIL.countRows(table);
        Assert.assertEquals((long)initialCount, (long)count);
        for (int i = 0; i < 4; ++i) {
            TEST_UTIL.loadTable(table, FAMILY);
        }
        TEST_UTIL.expireRegionServerSession(0);
        int newCount = TEST_UTIL.countRows(table);
        Assert.assertEquals((long)count, (long)newCount);
        table.close();
    }
}

