/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestServerLoad {
    @Test
    public void testRegionLoadAggregation() {
        ServerLoad sl = new ServerLoad(this.createServerLoadProto());
        Assert.assertEquals((long)13L, (long)sl.getStores());
        Assert.assertEquals((long)114L, (long)sl.getStorefiles());
        Assert.assertEquals((long)129L, (long)sl.getStoreUncompressedSizeMB());
        Assert.assertEquals((long)504L, (long)sl.getRootIndexSizeKB());
        Assert.assertEquals((long)820L, (long)sl.getStorefileSizeInMB());
        Assert.assertEquals((long)82L, (long)sl.getStorefileIndexSizeInMB());
        Assert.assertEquals((long)0L, (long)sl.getReadRequestsCount());
    }

    @Test
    public void testToString() {
        ServerLoad sl = new ServerLoad(this.createServerLoadProto());
        String slToString = sl.toString();
        Assert.assertTrue((boolean)slToString.contains("numberOfStores=13"));
        Assert.assertTrue((boolean)slToString.contains("numberOfStorefiles=114"));
        Assert.assertTrue((boolean)slToString.contains("storefileUncompressedSizeMB=129"));
        Assert.assertTrue((boolean)slToString.contains("storefileSizeMB=820"));
        Assert.assertTrue((boolean)slToString.contains("rootIndexSizeKB=504"));
        Assert.assertTrue((boolean)slToString.contains("coprocessors=[]"));
    }

    private ClusterStatusProtos.ServerLoad createServerLoadProto() {
        HBaseProtos.RegionSpecifier rSpecOne = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME).setValue(ByteString.copyFromUtf8("ASDFGQWERT")).build();
        HBaseProtos.RegionSpecifier rSpecTwo = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME).setValue(ByteString.copyFromUtf8("QWERTYUIOP")).build();
        ClusterStatusProtos.RegionLoad rlOne = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rSpecOne).setStores(10).setStorefiles(101).setStoreUncompressedSizeMB(106).setStorefileSizeMB(520).setStorefileIndexSizeMB(42).setRootIndexSizeKB(201).build();
        ClusterStatusProtos.RegionLoad rlTwo = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rSpecTwo).setStores(3).setStorefiles(13).setStoreUncompressedSizeMB(23).setStorefileSizeMB(300).setStorefileIndexSizeMB(40).setRootIndexSizeKB(303).build();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().addRegionLoads(rlOne).addRegionLoads(rlTwo).build();
        return sl;
    }
}

