/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HFileArchiveTableMonitor {
    private static final Log LOG = LogFactory.getLog(HFileArchiveTableMonitor.class);
    private final Set<String> archivedTables = new TreeSet<String>();

    public synchronized void setArchiveTables(List<String> tables) {
        this.archivedTables.clear();
        this.archivedTables.addAll(tables);
    }

    public synchronized void addTable(String table) {
        if (this.shouldArchiveTable(table)) {
            LOG.debug("Already archiving table: " + table + ", ignoring it");
            return;
        }
        this.archivedTables.add(table);
    }

    public synchronized void removeTable(String table) {
        this.archivedTables.remove(table);
    }

    public synchronized void clearArchive() {
        this.archivedTables.clear();
    }

    public synchronized boolean shouldArchiveTable(String tableName) {
        return this.archivedTables.contains(tableName);
    }
}

