/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaMigrationConvertingToPB;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.migration.NamespaceUpgrade;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
@Deprecated
public class TestMetaMigrationConvertingToPB {
    static final Log LOG = LogFactory.getLog(TestMetaMigrationConvertingToPB.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TESTTABLE = "TestTable";
    private static final int ROW_COUNT = 100;
    private static final int REGION_COUNT = 9;
    private static final int META_VERSION_092 = 0;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(1);
        Path testdir = TEST_UTIL.getDataTestDir("TestMetaMigrationConvertToPB");
        File untar = TestMetaMigrationConvertingToPB.untar(new File(testdir.toString()));
        Configuration conf = TEST_UTIL.getConfiguration();
        FsShell shell = new FsShell(conf);
        FileSystem fs = FileSystem.get(conf);
        Path hbaseRootDir = TEST_UTIL.getDefaultRootDirPath();
        if (!fs.isDirectory(hbaseRootDir.getParent())) {
            fs.mkdirs(hbaseRootDir.getParent());
        }
        TestMetaMigrationConvertingToPB.doFsCommand(shell, new String[]{"-put", untar.toURI().toString(), hbaseRootDir.toString()});
        TestMetaMigrationConvertingToPB.doFsCommand(shell, new String[]{"-mv", new Path(hbaseRootDir, "-META-").toString(), new Path(hbaseRootDir, ".META.").toString()});
        TestMetaMigrationConvertingToPB.doFsCommand(shell, new String[]{"-lsr", "/"});
        Configuration toolConf = TEST_UTIL.getConfiguration();
        conf.set("hbase.rootdir", TEST_UTIL.getDefaultRootDirPath().toString());
        ToolRunner.run(toolConf, new NamespaceUpgrade(), new String[]{"--upgrade"});
        TEST_UTIL.startMiniHBaseCluster(1, 1);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TESTTABLE);
        ResultScanner scanner = t.getScanner(new Scan());
        int count = 0;
        while (scanner.next() != null) {
            ++count;
        }
        junit.framework.Assert.assertEquals((int)100, (int)count);
        scanner.close();
        t.close();
    }

    private static File untar(File testdir) throws IOException {
        String datafile = "TestMetaMigrationConvertToPB";
        String srcTarFile = System.getProperty("project.build.testSourceDirectory", "src/test") + File.separator + "data" + File.separator + "TestMetaMigrationConvertToPB" + ".tgz";
        File homedir = new File(testdir.toString());
        File tgtUntarDir = new File(homedir, "TestMetaMigrationConvertToPB");
        if (tgtUntarDir.exists() && !FileUtil.fullyDelete(tgtUntarDir)) {
            throw new IOException("Failed delete of " + tgtUntarDir.toString());
        }
        LOG.info("Untarring " + srcTarFile + " into " + homedir.toString());
        FileUtil.unTar(new File(srcTarFile), homedir);
        junit.framework.Assert.assertTrue((boolean)tgtUntarDir.exists());
        return tgtUntarDir;
    }

    private static void doFsCommand(FsShell shell, String[] args) throws Exception {
        int errcode = shell.run(args);
        if (errcode != 0) {
            throw new IOException("Failed put; errcode=" + errcode);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaUpdatedFlagInROOT() throws Exception {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        boolean metaUpdated = MetaMigrationConvertingToPB.isMetaTableUpdated(master.getCatalogTracker());
        Assert.assertEquals((Object)true, (Object)metaUpdated);
        this.verifyMetaRowsAreUpdated(master.getCatalogTracker());
    }

    @Test
    public void testMetaMigration() throws Exception {
        LOG.info("Starting testMetaMigration");
        byte[] FAMILY = Bytes.toBytes("family");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testMetaMigration"));
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        Configuration conf = TEST_UTIL.getConfiguration();
        byte[][] regionNames = new byte[][]{HConstants.EMPTY_START_ROW, Bytes.toBytes("region_a"), Bytes.toBytes("region_b")};
        this.createMultiRegionsWithWritableSerialization(conf, htd.getTableName().getName(), (byte[][])regionNames);
        CatalogTracker ct = TEST_UTIL.getMiniHBaseCluster().getMaster().getCatalogTracker();
        this.undoVersionInRoot(ct);
        MetaReader.fullScanMetaAndPrint(ct);
        LOG.info("Meta Print completed.testMetaMigration");
        long numMigratedRows = MetaMigrationConvertingToPB.updateMeta(TEST_UTIL.getHBaseCluster().getMaster());
        MetaReader.fullScanMetaAndPrint(ct);
        Assert.assertEquals((long)regionNames.length, (long)numMigratedRows);
        boolean metaUpdated = MetaMigrationConvertingToPB.isMetaTableUpdated(TEST_UTIL.getMiniHBaseCluster().getMaster().getCatalogTracker());
        Assert.assertEquals((Object)true, (Object)metaUpdated);
        this.verifyMetaRowsAreUpdated(ct);
    }

    @Test
    public void testMasterCrashDuringMetaMigration() throws Exception {
        byte[] FAMILY = Bytes.toBytes("family");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testMasterCrashDuringMetaMigration"));
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        Configuration conf = TEST_UTIL.getConfiguration();
        this.createMultiRegionsWithPBSerialization(conf, htd.getTableName().getName(), 10);
        this.createMultiRegionsWithWritableSerialization(conf, htd.getTableName().getName(), 10);
        CatalogTracker ct = TEST_UTIL.getMiniHBaseCluster().getMaster().getCatalogTracker();
        this.undoVersionInRoot(ct);
        MetaReader.fullScanMetaAndPrint(ct);
        LOG.info("Meta Print completed.testUpdatesOnMetaWithLegacyHRI");
        long numMigratedRows = MetaMigrationConvertingToPB.updateMetaIfNecessary(TEST_UTIL.getHBaseCluster().getMaster());
        Assert.assertEquals((long)numMigratedRows, (long)10L);
        boolean metaUpdated = MetaMigrationConvertingToPB.isMetaTableUpdated(TEST_UTIL.getMiniHBaseCluster().getMaster().getCatalogTracker());
        Assert.assertEquals((Object)true, (Object)metaUpdated);
        this.verifyMetaRowsAreUpdated(ct);
        LOG.info("END testMasterCrashDuringMetaMigration");
    }

    void verifyMetaRowsAreUpdated(CatalogTracker catalogTracker) throws IOException {
        List<Result> results = MetaReader.fullScan(catalogTracker);
        Assert.assertTrue((results.size() >= 9 ? 1 : 0) != 0);
        for (Result result : results) {
            byte[] splitB;
            byte[] hriBytes = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            Assert.assertTrue((hriBytes != null && hriBytes.length > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)MetaMigrationConvertingToPB.isMigrated(hriBytes));
            byte[] splitA = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER);
            if (splitA != null && splitA.length > 0) {
                Assert.assertTrue((boolean)MetaMigrationConvertingToPB.isMigrated(splitA));
            }
            if ((splitB = result.getValue(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER)) == null || splitB.length <= 0) continue;
            Assert.assertTrue((boolean)MetaMigrationConvertingToPB.isMigrated(splitB));
        }
    }

    private void undoVersionInRoot(CatalogTracker ct) throws IOException {
        Put p = new Put(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
        p.add(HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, Bytes.toBytes(0));
        LOG.info("Downgraded -ROOT- meta version=0");
    }

    public int createMultiRegionsWithWritableSerialization(Configuration c, byte[] tableName, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes("aaaaa");
        byte[] endKey = Bytes.toBytes("zzzzz");
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            regionStartKeys[i + 1] = splitKeys[i];
        }
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegionsWithWritableSerialization(c, tableName, (byte[][])regionStartKeys);
    }

    public int createMultiRegionsWithWritableSerialization(Configuration c, byte[] tableName, byte[][] startKeys) throws IOException {
        return this.createMultiRegionsWithWritableSerialization(c, TableName.valueOf(tableName), startKeys);
    }

    public int createMultiRegionsWithWritableSerialization(Configuration c, TableName tableName, byte[][] startKeys) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, TableName.META_TABLE_NAME);
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(tableName, startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.setDurability(Durability.SKIP_WAL);
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, this.getBytes(hri));
            put.add(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, this.getBytes(hri));
            put.add(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, this.getBytes(hri));
            meta.put(put);
            LOG.info("createMultiRegionsWithWritableSerialization: PUT inserted " + hri.toString());
            newRegions.add(hri);
            ++count;
        }
        meta.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private byte[] getBytes(HRegionInfo hri) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            hri.write(out);
            byte[] byArray = out.getData();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    int createMultiRegionsWithPBSerialization(Configuration c, byte[] tableName, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes("aaaaa");
        byte[] endKey = Bytes.toBytes("zzzzz");
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            regionStartKeys[i + 1] = splitKeys[i];
        }
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegionsWithPBSerialization(c, tableName, (byte[][])regionStartKeys);
    }

    int createMultiRegionsWithPBSerialization(Configuration c, byte[] tableName, byte[][] startKeys) throws IOException {
        return this.createMultiRegionsWithPBSerialization(c, TableName.valueOf(tableName), startKeys);
    }

    int createMultiRegionsWithPBSerialization(Configuration c, TableName tableName, byte[][] startKeys) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, TableName.META_TABLE_NAME);
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(tableName, startKeys[i], startKeys[j]);
            Put put = MetaEditor.makePutFromRegionInfo(hri);
            put.setDurability(Durability.SKIP_WAL);
            meta.put(put);
            LOG.info("createMultiRegionsWithPBSerialization: PUT inserted " + hri.toString());
            newRegions.add(hri);
            ++count;
        }
        meta.close();
        return count;
    }
}

