/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Append
extends Mutation {
    private static final String RETURN_RESULTS = "_rr_";

    public void setReturnResults(boolean returnResults) {
        this.setAttribute(RETURN_RESULTS, Bytes.toBytes(returnResults));
    }

    public boolean isReturnResults() {
        byte[] v = this.getAttribute(RETURN_RESULTS);
        return v == null ? true : Bytes.toBoolean(v);
    }

    public Append(byte[] row) {
        this(row, 0, row.length);
    }

    public Append(byte[] rowArray, int rowOffset, int rowLength) {
        Append.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy(rowArray, rowOffset, rowLength);
    }

    public Append add(byte[] family, byte[] qualifier, byte[] value) {
        KeyValue kv = new KeyValue(this.row, family, qualifier, this.ts, KeyValue.Type.Put, value);
        return this.add(kv);
    }

    public Append add(Cell cell) {
        KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
        byte[] family = kv.getFamily();
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }
}

