/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CoprocessorHConnection
implements HConnection {
    private HConnection delegate;
    private ServerName serverName;
    private HRegionServer server;

    public static HConnection getConnectionForEnvironment(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment e;
        RegionServerServices services;
        HConnection connection = HConnectionManager.createConnection(env.getConfiguration());
        if (env instanceof RegionCoprocessorEnvironment && (services = (e = (RegionCoprocessorEnvironment)env).getRegionServerServices()) instanceof HRegionServer) {
            return new CoprocessorHConnection(connection, (HRegionServer)services);
        }
        return connection;
    }

    public CoprocessorHConnection(HConnection delegate, HRegionServer server) {
        this.server = server;
        this.serverName = server.getServerName();
        this.delegate = delegate;
    }

    @Override
    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        if (!this.serverName.equals(serverName)) {
            return this.delegate.getClient(serverName);
        }
        final BlockingService blocking = ClientProtos.ClientService.newReflectiveBlockingService(this.server);
        final RpcServerInterface rpc = this.server.getRpcServer();
        final MonitoredRPCHandler status = TaskMonitor.get().createRPCStatus(Thread.currentThread().getName());
        status.pause("Setting up server-local call");
        final long timestamp = EnvironmentEdgeManager.currentTimeMillis();
        BlockingRpcChannel channel = new BlockingRpcChannel(){

            @Override
            public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
                try {
                    return rpc.call(blocking, method, request, null, timestamp, status).getFirst();
                }
                catch (IOException e) {
                    throw new ServiceException(e);
                }
            }
        };
        return ClientProtos.ClientService.newBlockingStub(channel);
    }

    @Override
    public void abort(String why, Throwable e) {
        this.delegate.abort(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.delegate.isAborted();
    }

    @Override
    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public HTableInterface getTable(String tableName) throws IOException {
        return this.delegate.getTable(tableName);
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws IOException {
        return this.delegate.getTable(tableName);
    }

    @Override
    public HTableInterface getTable(TableName tableName) throws IOException {
        return this.delegate.getTable(tableName);
    }

    @Override
    public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
        return this.delegate.getTable(tableName, pool);
    }

    @Override
    public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
        return this.delegate.getTable(tableName, pool);
    }

    @Override
    public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.delegate.getTable(tableName, pool);
    }

    @Override
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.delegate.isMasterRunning();
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.delegate.isTableEnabled(tableName);
    }

    @Override
    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.delegate.isTableEnabled(tableName);
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.delegate.isTableDisabled(tableName);
    }

    @Override
    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.delegate.isTableDisabled(tableName);
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.delegate.isTableAvailable(tableName);
    }

    @Override
    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.delegate.isTableAvailable(tableName);
    }

    @Override
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.delegate.isTableAvailable(tableName, splitKeys);
    }

    @Override
    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.delegate.isTableAvailable(tableName, splitKeys);
    }

    @Override
    public HTableDescriptor[] listTables() throws IOException {
        return this.delegate.listTables();
    }

    @Override
    public String[] getTableNames() throws IOException {
        return this.delegate.getTableNames();
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        return this.delegate.listTableNames();
    }

    @Override
    public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
        return this.delegate.getHTableDescriptor(tableName);
    }

    @Override
    public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
        return this.delegate.getHTableDescriptor(tableName);
    }

    @Override
    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        return this.delegate.locateRegion(tableName, row);
    }

    @Override
    public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.delegate.locateRegion(tableName, row);
    }

    @Override
    public void clearRegionCache() {
        this.delegate.clearRegionCache();
    }

    @Override
    public void clearRegionCache(TableName tableName) {
        this.delegate.clearRegionCache(tableName);
    }

    @Override
    public void clearRegionCache(byte[] tableName) {
        this.delegate.clearRegionCache(tableName);
    }

    @Override
    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.delegate.relocateRegion(tableName, row);
    }

    @Override
    public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.delegate.relocateRegion(tableName, row);
    }

    @Override
    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.delegate.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Override
    public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.delegate.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Override
    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        return this.delegate.locateRegion(regionName);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.delegate.locateRegions(tableName);
    }

    @Override
    public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
        return this.delegate.locateRegions(tableName);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        return this.delegate.locateRegions(tableName, useCache, offlined);
    }

    @Override
    public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
        return this.delegate.locateRegions(tableName, useCache, offlined);
    }

    @Override
    public MasterProtos.MasterService.BlockingInterface getMaster() throws IOException {
        return this.delegate.getMaster();
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return this.delegate.getAdmin(serverName);
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean getMaster) throws IOException {
        return this.delegate.getAdmin(serverName, getMaster);
    }

    @Override
    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.delegate.getRegionLocation(tableName, row, reload);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
        return this.delegate.getRegionLocation(tableName, row, reload);
    }

    @Override
    public void processBatch(List<? extends Row> actions, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.delegate.processBatch(actions, tableName, pool, results);
    }

    @Override
    public void processBatch(List<? extends Row> actions, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.delegate.processBatch(actions, tableName, pool, results);
    }

    @Override
    public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.delegate.processBatchCallback(list, tableName, pool, results, callback);
    }

    @Override
    public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.delegate.processBatchCallback(list, tableName, pool, results, callback);
    }

    @Override
    public void setRegionCachePrefetch(TableName tableName, boolean enable) {
        this.delegate.setRegionCachePrefetch(tableName, enable);
    }

    @Override
    public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
        this.delegate.setRegionCachePrefetch(tableName, enable);
    }

    @Override
    public boolean getRegionCachePrefetch(TableName tableName) {
        return this.delegate.getRegionCachePrefetch(tableName);
    }

    @Override
    public boolean getRegionCachePrefetch(byte[] tableName) {
        return this.delegate.getRegionCachePrefetch(tableName);
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        return this.delegate.getCurrentNrHRS();
    }

    @Override
    public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        return this.delegate.getHTableDescriptorsByTableName(tableNames);
    }

    @Override
    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        return this.delegate.getHTableDescriptors(tableNames);
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void clearCaches(ServerName sn) {
        this.delegate.clearCaches(sn);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void deleteCachedRegionLocation(HRegionLocation location) {
        this.delegate.deleteCachedRegionLocation(location);
    }

    @Override
    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        return this.delegate.getKeepAliveMasterService();
    }

    @Override
    public boolean isDeadServer(ServerName serverName) {
        return this.delegate.isDeadServer(serverName);
    }

    @Override
    public NonceGenerator getNonceGenerator() {
        return null;
    }
}

