/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.mockito.Mockito;

public class HConnectionTestingUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getMockedConnection(Configuration conf) throws ZooKeeperConnectionException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionManager.HConnectionImplementation> map = HConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionManager.HConnectionImplementation connection = HConnectionManager.CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionManager.HConnectionImplementation)Mockito.mock(HConnectionManager.HConnectionImplementation.class);
                Mockito.when((Object)connection.getConfiguration()).thenReturn((Object)conf);
                HConnectionManager.CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    public static HConnection getMockedConnectionAndDecorate(Configuration conf, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client, ServerName sn, HRegionInfo hri) throws IOException {
        HConnection c = HConnectionTestingUtility.getMockedConnection(conf);
        ((HConnection)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(hri, sn);
        Mockito.when((Object)c.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        if (admin != null) {
            Mockito.when((Object)c.getAdmin((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)admin);
        }
        if (client != null) {
            Mockito.when((Object)c.getClient((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)client);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getSpiedConnection(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionManager.HConnectionImplementation> map = HConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionManager.HConnectionImplementation connection = HConnectionManager.CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionManager.HConnectionImplementation)Mockito.spy((Object)new HConnectionManager.HConnectionImplementation(conf, true));
                HConnectionManager.CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getConnectionCount() {
        Map<HConnectionKey, HConnectionManager.HConnectionImplementation> map = HConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            return HConnectionManager.CONNECTION_INSTANCES.size();
        }
    }
}

