/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class MetaScanner {
    private static final Log LOG = LogFactory.getLog(MetaScanner.class);

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(configuration, visitor, null, null, Integer.MAX_VALUE);
    }

    public static void metaScan(Configuration configuration, HConnection connection, MetaScannerVisitor visitor, TableName userTableName) throws IOException {
        MetaScanner.metaScan(configuration, connection, visitor, userTableName, null, Integer.MAX_VALUE, TableName.META_TABLE_NAME);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, TableName userTableName, byte[] row, int rowLimit) throws IOException {
        MetaScanner.metaScan(configuration, null, visitor, userTableName, row, rowLimit, TableName.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaScan(Configuration configuration, HConnection connection, MetaScannerVisitor visitor, TableName tableName, byte[] row, int rowLimit, TableName metaTableName) throws IOException {
        int rowUpperLimit = rowLimit > 0 ? rowLimit : Integer.MAX_VALUE;
        HTable metaTable = connection == null ? new HTable(configuration, TableName.META_TABLE_NAME, null) : new HTable(TableName.META_TABLE_NAME, connection, null);
        ResultScanner scanner = null;
        try {
            byte[] startRow;
            if (row != null) {
                byte[] searchRow = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
                Result startRowResult = metaTable.getRowOrBefore(searchRow, HConstants.CATALOG_FAMILY);
                if (startRowResult == null) {
                    throw new TableNotFoundException("Cannot find row in " + TableName.META_TABLE_NAME.getNameAsString() + " for table: " + tableName + ", row=" + Bytes.toStringBinary(searchRow));
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(startRowResult);
                if (regionInfo == null) {
                    throw new IOException("HRegionInfo was null or empty in Meta for " + tableName + ", row=" + Bytes.toStringBinary(searchRow));
                }
                byte[] rowBefore = regionInfo.getStartKey();
                startRow = HRegionInfo.createRegionName(tableName, rowBefore, "00000000000000", false);
            } else {
                startRow = tableName == null || tableName.getName().length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "00000000000000", false);
            }
            Scan scan = new Scan(startRow).addFamily(HConstants.CATALOG_FAMILY);
            int scannerCaching = configuration.getInt(HConstants.HBASE_META_SCANNER_CACHING, HConstants.DEFAULT_HBASE_META_SCANNER_CACHING);
            if (rowUpperLimit <= scannerCaching) {
                scan.setSmall(true);
            }
            int rows = Math.min(rowLimit, scannerCaching);
            scan.setCaching(rows);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Scanning " + metaTableName.getNameAsString() + " starting at row=" + Bytes.toStringBinary(startRow) + " for max=" + rowUpperLimit + " with caching=" + rows);
            }
            scanner = metaTable.getScanner(scan);
            Result result = null;
            int processedRows = 0;
            while ((result = scanner.next()) != null) {
                if (visitor != null && !visitor.processRow(result)) {
                } else if (++processedRows < rowUpperLimit) continue;
                break;
            }
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Throwable t) {
                    LOG.debug("Got exception in closing the result scanner", t);
                }
            }
            if (visitor != null) {
                try {
                    visitor.close();
                }
                catch (Throwable t) {
                    LOG.debug("Got exception in closing the meta scanner visitor", t);
                }
            }
            if (metaTable != null) {
                try {
                    metaTable.close();
                }
                catch (Throwable t) {
                    LOG.debug("Got exception in closing the meta table", t);
                }
            }
        }
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        return HRegionInfo.getHRegionInfo(data);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf, final boolean offlined) throws IOException {
        final ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        DefaultMetaScannerVisitor visitor = new DefaultMetaScannerVisitor(){

            @Override
            public boolean processRowInternal(Result result) throws IOException {
                if (result == null || result.isEmpty()) {
                    return true;
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(result);
                if (regionInfo == null) {
                    LOG.warn("Null REGIONINFO_QUALIFIER: " + result);
                    return true;
                }
                if (regionInfo.isOffline() && !offlined) {
                    return true;
                }
                regions.add(regionInfo);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor);
        return regions;
    }

    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Configuration conf, HConnection connection, TableName tableName, boolean offlined) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        TableMetaScannerVisitor visitor = new TableMetaScannerVisitor(tableName){

            @Override
            public boolean processRowInternal(Result rowResult) throws IOException {
                HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
                ServerName serverName = HRegionInfo.getServerName(rowResult);
                regions.put(new UnmodifyableHRegionInfo(info), serverName);
                return true;
            }
        };
        MetaScanner.metaScan(conf, connection, visitor, tableName);
        return regions;
    }

    public static abstract class TableMetaScannerVisitor
    extends DefaultMetaScannerVisitor {
        private TableName tableName;

        public TableMetaScannerVisitor(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public final boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.getTable().equals(this.tableName)) {
                return false;
            }
            return super.processRow(rowResult);
        }
    }

    public static abstract class DefaultMetaScannerVisitor
    extends MetaScannerVisitorBase {
        public abstract boolean processRowInternal(Result var1) throws IOException;

        @Override
        public boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.processRowInternal(rowResult);
            }
            return true;
        }
    }

    public static abstract class MetaScannerVisitorBase
    implements MetaScannerVisitor {
        @Override
        public void close() throws IOException {
        }
    }

    public static interface MetaScannerVisitor
    extends Closeable {
        public boolean processRow(Result var1) throws IOException;
    }
}

