/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class MultiResponse {
    private Map<byte[], List<Pair<Integer, Object>>> results = new TreeMap<byte[], List<Pair<Integer, Object>>>(Bytes.BYTES_COMPARATOR);
    private Map<byte[], Throwable> exceptions = new TreeMap<byte[], Throwable>(Bytes.BYTES_COMPARATOR);

    public int size() {
        int size = 0;
        for (List<Pair<Integer, Object>> c : this.results.values()) {
            size += c.size();
        }
        return size;
    }

    public void add(byte[] regionName, Pair<Integer, Object> r) {
        List<Pair<Integer, Object>> rs = this.results.get(regionName);
        if (rs == null) {
            rs = new ArrayList<Pair<Integer, Object>>();
            this.results.put(regionName, rs);
        }
        rs.add(r);
    }

    public void add(byte[] regionName, int originalIndex, Object resOrEx) {
        this.add(regionName, new Pair<Integer, Object>(originalIndex, resOrEx));
    }

    public Map<byte[], List<Pair<Integer, Object>>> getResults() {
        return this.results;
    }

    public void addException(byte[] regionName, Throwable ie) {
        this.exceptions.put(regionName, ie);
    }

    public Throwable getException(byte[] regionName) {
        return this.exceptions.get(regionName);
    }

    public Map<byte[], Throwable> getExceptions() {
        return this.exceptions;
    }
}

