/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtilsForTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAdmin {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(timeout=300000L)
    public void testSplitFlushCompactUnknownTable() throws InterruptedException {
        String unknowntable = "fubar";
        IOException exception = null;
        try {
            this.admin.compact("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.flush("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.split("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDeleteEditUnknownColumnFamilyAndOrTable() throws IOException {
        String nonexistent = "nonexistent";
        HColumnDescriptor nonexistentHcd = new HColumnDescriptor("nonexistent");
        IOException exception = null;
        try {
            this.admin.addColumn("nonexistent", nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteColumn("nonexistent", "nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.disableTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.enableTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.modifyColumn("nonexistent", nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("nonexistent"));
            this.admin.modifyTable(htd.getTableName(), htd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        String tableName = "testDeleteEditUnknownColumnFamilyAndOrTable" + System.currentTimeMillis();
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(tableName));
        htd.addFamily(new HColumnDescriptor("cf"));
        this.admin.createTable(htd);
        try {
            exception = null;
            try {
                this.admin.deleteColumn(htd.getTableName(), nonexistentHcd.getName());
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
            exception = null;
            try {
                this.admin.modifyColumn(htd.getTableName(), nonexistentHcd);
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
        }
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes("row");
        byte[] qualifier = Bytes.toBytes("qualifier");
        byte[] value = Bytes.toBytes("value");
        byte[] table = Bytes.toBytes("testDisableAndEnableTable");
        HTable ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        this.admin.disableTable(ht.getName());
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isDisabledTable(ht.getName()));
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(table);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isEnabledTable(ht.getName()));
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht.close();
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableTables() throws IOException {
        byte[] row = Bytes.toBytes("row");
        byte[] qualifier = Bytes.toBytes("qualifier");
        byte[] value = Bytes.toBytes("value");
        byte[] table1 = Bytes.toBytes("testDisableAndEnableTable1");
        byte[] table2 = Bytes.toBytes("testDisableAndEnableTable2");
        HTable ht1 = TEST_UTIL.createTable(table1, HConstants.CATALOG_FAMILY);
        HTable ht2 = TEST_UTIL.createTable(table2, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht1.put(put);
        ht2.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht1.get(get);
        ht2.get(get);
        this.admin.disableTables("testDisableAndEnableTable.*");
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht1.get(get);
            ht2.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTables("testDisableAndEnableTable.*");
        try {
            ht1.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        try {
            ht2.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht1.close();
        ht2.close();
    }

    @Test(timeout=300000L)
    public void testCreateTable() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(Bytes.toBytes("testCreateTable"), HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isEnabledTable(TableName.valueOf("testCreateTable")));
    }

    @Test(timeout=300000L)
    public void testGetTableDescriptor() throws IOException {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("myTestTable"));
        htd.addFamily(fam1);
        htd.addFamily(fam2);
        htd.addFamily(fam3);
        this.admin.createTable(htd);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), "myTestTable");
        HTableDescriptor confirmedHtd = table.getTableDescriptor();
        Assert.assertEquals((long)htd.compareTo(confirmedHtd), (long)0L);
        table.close();
    }

    @Test(timeout=300000L)
    public void testHColumnValidName() {
        try {
            new HColumnDescriptor("\\test\\abc");
        }
        catch (IllegalArgumentException iae) {
            boolean exceptionThrown = true;
            Assert.assertTrue((boolean)exceptionThrown);
        }
    }

    @Test(timeout=300000L)
    public void testOnlineChangeTableSchema() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf("changeTableSchemaOnline");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals(copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        HTableDescriptor modifiedHtd = this.admin.getTableDescriptor(tableName);
        Assert.assertFalse((boolean)htd.equals(modifiedHtd));
        Assert.assertTrue((boolean)copy.equals(modifiedHtd));
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)"anyoldkey", (Object)modifiedHtd.getValue("anyoldkey"));
        int countOfFamilies = modifiedHtd.getFamilies().size();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        HColumnDescriptor hcd = modifiedHtd.getFamilies().iterator().next();
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd.setMaxVersions(newMaxVersions);
        byte[] hcdName = hcd.getName();
        expectedException = false;
        try {
            this.admin.modifyColumn(tableName, hcd);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor modifiedHcd = modifiedHtd.getFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        HColumnDescriptor xtracol = new HColumnDescriptor("xtracol");
        xtracol.setValue("xtracol", "xtracol");
        expectedException = false;
        try {
            this.admin.addColumn(tableName, xtracol);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)hcd.getValue("xtracol").equals("xtracol"));
        this.admin.deleteColumn(tableName, xtracol.getName());
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd == null ? 1 : 0) != 0);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        this.admin.listTables();
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    @Test(timeout=300000L)
    public void testShouldFailOnlineSchemaUpdateIfOnlineSchemaIsNotEnabled() throws Exception {
        byte[] tableName = Bytes.toBytes("changeTableSchemaOnlineFailure");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", false);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals(copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((String)"Online schema update should not happen.", (boolean)expectedException);
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
    }

    protected void verifyRoundRobinDistribution(HTable ht, int expectedRegions) throws IOException {
        int numRS = ht.getConnection().getCurrentNrHRS();
        NavigableMap<HRegionInfo, ServerName> regions = ht.getRegionLocations();
        HashMap server2Regions = new HashMap();
        for (Map.Entry entry : regions.entrySet()) {
            ServerName server = (ServerName)entry.getValue();
            ArrayList regs = (ArrayList)server2Regions.get(server);
            if (regs == null) {
                regs = new ArrayList();
                server2Regions.put(server, regs);
            }
            regs.add(entry.getKey());
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        for (List regionList : server2Regions.values()) {
            Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
        }
    }

    @Test(timeout=300000L)
    public void testCreateTableNumberOfRegions() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes("testCreateTableNumberOfRegions");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap<HRegionInfo, ServerName> regions = ht.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regions.size());
        ht.close();
        byte[] TABLE_2 = Bytes.add(tableName, Bytes.toBytes("_2"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_2));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, new byte[][]{{42}});
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regions.size());
        ht2.close();
        byte[] TABLE_3 = Bytes.add(tableName, Bytes.toBytes("_3"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_3));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, "a".getBytes(), "z".getBytes(), 3);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regions.size());
        ht3.close();
        byte[] TABLE_4 = Bytes.add(tableName, Bytes.toBytes("_4"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_4));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try {
            this.admin.createTable(desc, "a".getBytes(), "z".getBytes(), 2);
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (IllegalArgumentException eae) {
            // empty catch block
        }
        byte[] TABLE_5 = Bytes.add(tableName, Bytes.toBytes("_5"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_5));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, new byte[]{1}, new byte[]{127}, 16);
        HTable ht5 = new HTable(TEST_UTIL.getConfiguration(), TABLE_5);
        regions = ht5.getRegionLocations();
        Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regions.size());
        ht5.close();
    }

    @Test(timeout=300000L)
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes("testCreateTableWithRegions");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, splitKeys);
        boolean tableAvailable = this.admin.isTableAvailable(Bytes.toString(tableName), (byte[][])splitKeys);
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap<HRegionInfo, ServerName> regions = ht.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        Iterator hris = regions.keySet().iterator();
        HRegionInfo hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[0]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[1]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[2]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[3]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[4]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[5]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[6]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[7]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), splitKeys[8]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht, expectedRegions);
        ht.close();
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        byte[] TABLE_2 = Bytes.add(tableName, Bytes.toBytes("_2"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_2));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.keySet().iterator();
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals(hri.getEndKey(), new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals(hri.getStartKey(), new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht2, expectedRegions);
        ht2.close();
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        byte[] TABLE_3 = Bytes.add(tableName, Bytes.toBytes("_3"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_3));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        this.verifyRoundRobinDistribution(ht3, expectedRegions);
        ht3.close();
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        byte[] TABLE_4 = Bytes.add(tableName, Bytes.toBytes("_4"));
        desc = new HTableDescriptor(TableName.valueOf(TABLE_4));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        HBaseAdmin ladmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            ladmin.createTable(desc, splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ladmin.close();
    }

    @Test(timeout=300000L)
    public void testTableAvailableWithRandomSplitKeys() throws Exception {
        byte[] tableName = Bytes.toBytes("testTableAvailableWithRandomSplitKeys");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        byte[][] splitKeys = new byte[1][];
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}};
        this.admin.createTable(desc);
        boolean tableAvailable = this.admin.isTableAvailable(Bytes.toString(tableName), (byte[][])splitKeys);
        Assert.assertFalse((String)"Table should be created with 1 row in META", (boolean)tableAvailable);
    }

    @Test(timeout=300000L)
    public void testCreateTableWithOnlyEmptyStartRow() throws IOException {
        byte[] tableName = Bytes.toBytes("testCreateTableWithOnlyEmptyStartRow");
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws IOException {
        byte[] tableName = Bytes.toBytes("testCreateTableWithEmptyRowInTheSplitKeys");
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            this.LOG.info("Expected ", e);
        }
    }

    @Test(timeout=120000L)
    public void testTableExist() throws IOException {
        byte[] table = Bytes.toBytes("testTableExist");
        boolean exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test(timeout=300000L)
    public void testForceSplit() throws Exception {
        byte[][] familyNames = new byte[][]{Bytes.toBytes("cf")};
        int[] rowCounts = new int[]{6000};
        int numVersions = 1;
        int blockSize = 256;
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        byte[] splitKey = Bytes.toBytes(3500);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize);
    }

    @Test(timeout=300000L)
    public void testEnableTableRetainAssignment() throws IOException {
        byte[] tableName = Bytes.toBytes("testEnableTableAssignment");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, splitKeys);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap<HRegionInfo, ServerName> regions = ht.getRegionLocations();
        ht.close();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        this.admin.disableTable(tableName);
        this.admin.enableTable(tableName);
        NavigableMap<HRegionInfo, ServerName> regions2 = ht.getRegionLocations();
        Assert.assertEquals((long)regions.size(), (long)regions2.size());
        for (Map.Entry entry : regions.entrySet()) {
            Assert.assertEquals(regions2.get(entry.getKey()), entry.getValue());
        }
    }

    @Test(timeout=300000L)
    public void testForceSplitMultiFamily() throws Exception {
        int numVersions = 1;
        int blockSize = 256;
        byte[][] familyNames = new byte[][]{Bytes.toBytes("cf1"), Bytes.toBytes("cf2")};
        int[] rowCounts = new int[]{6000, 1};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{1, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{6000, 300};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{300, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
    }

    void splitTest(byte[] splitPoint, byte[][] familyNames, int[] rowCounts, int numVersions, int blockSize) throws Exception {
        TableName tableName = TableName.valueOf("testForceSplit");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCounts.length; ++i) {
            sb.append("_").append(Integer.toString(rowCounts[i]));
        }
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
        final HTable table = TEST_UTIL.createTable(tableName, familyNames, numVersions, blockSize);
        int rowCount = 0;
        byte[] q = new byte[]{};
        for (int index = 0; index < familyNames.length; ++index) {
            ArrayList<Put> puts = new ArrayList<Put>(rowCounts[index]);
            for (int i = 0; i < rowCounts[index]; ++i) {
                byte[] k = Bytes.toBytes(i);
                Put put = new Put(k);
                put.add(familyNames[index], q, k);
                puts.add(put);
            }
            table.put(puts);
            if (rowCount >= rowCounts[index]) continue;
            rowCount = rowCounts[index];
        }
        NavigableMap<HRegionInfo, ServerName> m = table.getRegionLocations();
        this.LOG.info("Initial regions (" + m.size() + "): " + m);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        scan = new Scan();
        scanner = table.getScanner(scan);
        scanner.next();
        this.admin.split(tableName.getName(), splitPoint);
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread("CheckForSplit"){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    NavigableMap<HRegionInfo, ServerName> regions = null;
                    try {
                        regions = table.getRegionLocations();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (regions == null) continue;
                    count.set(regions.size());
                    if (count.get() >= 2) {
                        TestAdmin.this.LOG.info("Found: " + regions);
                        break;
                    }
                    TestAdmin.this.LOG.debug("Cycle waiting on split");
                }
                TestAdmin.this.LOG.debug("CheckForSplit thread exited, current region count: " + count.get());
            }
        };
        t.setPriority(3);
        t.start();
        t.join();
        rows = 1;
        for (Result result : scanner) {
            if (++rows <= rowCount) continue;
            scanner.close();
            Assert.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        NavigableMap<HRegionInfo, ServerName> regions = null;
        try {
            regions = table.getRegionLocations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)2L, (long)regions.size());
        Set hRegionInfos = regions.keySet();
        HRegionInfo[] r = hRegionInfos.toArray(new HRegionInfo[hRegionInfos.size()]);
        if (splitPoint != null) {
            Assert.assertEquals((Object)Bytes.toString(splitPoint), (Object)Bytes.toString(r[0].getEndKey()));
            Assert.assertEquals((Object)Bytes.toString(splitPoint), (Object)Bytes.toString(r[1].getStartKey()));
            this.LOG.debug("Properly split on " + Bytes.toString(splitPoint));
        } else if (familyNames.length > 1) {
            int splitKey = Bytes.toInt(r[0].getEndKey());
            int deltaForLargestFamily = Math.abs(rowCount / 2 - splitKey);
            this.LOG.debug("SplitKey=" + splitKey + "&deltaForLargestFamily=" + deltaForLargestFamily + ", r=" + r[0]);
            for (int index = 0; index < familyNames.length; ++index) {
                int delta = Math.abs(rowCounts[index] / 2 - splitKey);
                if (delta >= deltaForLargestFamily) continue;
                Assert.assertTrue((String)("Delta " + delta + " for family " + index + " should be at least deltaForLargestFamily " + deltaForLargestFamily), (boolean)false);
            }
        }
        TEST_UTIL.deleteTable(tableName);
        table.close();
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public void testEmptyHTableDescriptor() throws IOException {
        this.admin.createTable(new HTableDescriptor());
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public void testInvalidHColumnDescriptor() throws IOException {
        new HColumnDescriptor("/cfamily/name");
    }

    @Test(timeout=300000L)
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        TableName tableName = TableName.valueOf("testMasterAdmin");
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!ZKTableReadOnly.isEnabledTable(zkw, TableName.valueOf("testMasterAdmin"))) {
            Thread.sleep(10L);
        }
        this.admin.disableTable(tableName);
        try {
            new HTable(TEST_UTIL.getConfiguration(), tableName);
        }
        catch (DoNotRetryIOException e) {
            // empty catch block
        }
        this.admin.addColumn(tableName, new HColumnDescriptor("col2"));
        this.admin.enableTable(tableName);
        try {
            this.admin.deleteColumn(tableName, Bytes.toBytes("col2"));
        }
        catch (TableNotDisabledException e) {
            this.LOG.info(e);
        }
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    @Test(timeout=300000L)
    public void testCreateBadTables() throws IOException {
        int i;
        String msg = null;
        try {
            this.admin.createTable(HTableDescriptor.META_TABLEDESC);
        }
        catch (TableExistsException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(TableExistsException.class.getName()) && msg.contains(HTableDescriptor.META_TABLEDESC.getTableName().getNameAsString()) ? 1 : 0) != 0);
        final HTableDescriptor threadDesc = new HTableDescriptor(TableName.valueOf("threaded_testCreateBadTables"));
        threadDesc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        int count = 10;
        Thread[] threads = new Thread[count];
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicInteger failures = new AtomicInteger(0);
        final HBaseAdmin localAdmin = this.admin;
        for (i = 0; i < count; ++i) {
            threads[i] = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    try {
                        localAdmin.createTable(threadDesc);
                        successes.incrementAndGet();
                    }
                    catch (TableExistsException e) {
                        failures.incrementAndGet();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed threaded create" + this.getName(), e);
                    }
                }
            };
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            while (threads[i].isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        Assert.assertEquals((long)1L, (long)successes.get());
        Assert.assertEquals((long)(count - 1), (long)failures.get());
    }

    @Test(timeout=300000L)
    public void testTableNameClash() throws Exception {
        String name = "testTableNameClash";
        this.admin.createTable(new HTableDescriptor(TableName.valueOf(name + "SOMEUPPERCASE")));
        this.admin.createTable(new HTableDescriptor(TableName.valueOf(name)));
        new HTable(TEST_UTIL.getConfiguration(), name).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCreateTableRPCTimeOut() throws Exception {
        String name = "testCreateTableRPCTimeOut";
        int oldTimeout = TEST_UTIL.getConfiguration().getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, 1500);
        try {
            int expectedRegions = 100;
            byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
            HBaseAdmin hbaseadmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            hbaseadmin.createTable(new HTableDescriptor(TableName.valueOf(name)), startKey, endKey, expectedRegions);
            hbaseadmin.close();
        }
        finally {
            TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, oldTimeout);
        }
    }

    @Test(timeout=300000L)
    public void testReadOnlyTable() throws Exception {
        byte[] name = Bytes.toBytes("testReadOnlyTable");
        HTable table = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        byte[] value = Bytes.toBytes("somedata");
        Put put = new Put(value);
        put.add(HConstants.CATALOG_FAMILY, HConstants.CATALOG_FAMILY, value);
        table.put(put);
        table.close();
    }

    @Test(timeout=300000L)
    public void testTableNames() throws IOException {
        byte[][] illegalNames;
        for (byte[] illegalName : illegalNames = new byte[][]{Bytes.toBytes("-bad"), Bytes.toBytes(".bad")}) {
            try {
                new HTableDescriptor(TableName.valueOf(illegalName));
                throw new IOException("Did not detect '" + Bytes.toString(illegalName) + "' as an illegal user table name");
            }
            catch (IllegalArgumentException e) {
            }
        }
        byte[] legalName = Bytes.toBytes("g-oo.d");
        try {
            new HTableDescriptor(TableName.valueOf(legalName));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Legal user table name: '" + Bytes.toString(legalName) + "' caused IllegalArgumentException: " + e.getMessage());
        }
    }

    @Test(expected=TableExistsException.class, timeout=300000L)
    public void testTableExistsExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes("testTableExistsExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
    }

    @Test(expected=TableNotEnabledException.class, timeout=300000L)
    public void testTableNotEnabledExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes("testTableNotEnabledExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        this.admin.disableTable(name);
        this.admin.disableTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TableNotDisabledException.class, timeout=300000L)
    public void testTableNotDisabledExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes("testTableNotDisabledExceptionWithATable");
        HTable t = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        try {
            this.admin.enableTable(name);
        }
        finally {
            t.close();
        }
    }

    @Test(expected=TableNotFoundException.class, timeout=300000L)
    public void testTableNotFoundExceptionWithoutAnyTables() throws IOException {
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), "testTableNotFoundExceptionWithoutAnyTables");
        ht.get(new Get("e".getBytes()));
    }

    @Test(timeout=300000L)
    public void testShouldCloseTheRegionBasedOnTheEncodedRegionName() throws Exception {
        TableName TABLENAME = TableName.valueOf("TestHBACloseRegion");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(rs);
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.getTable().isSystemTable()) continue;
            info = regionInfo;
            this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), rs.getServerName().getServerName());
        }
        boolean isInList = ProtobufUtil.getOnlineRegions(rs).contains(info);
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = ProtobufUtil.getOnlineRegions(rs).contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    @Test(timeout=300000L)
    public void testCloseRegionIfInvalidRegionNameIsPassed() throws Exception {
        byte[] TABLENAME = Bytes.toBytes("TestHBACloseRegion1");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(rs);
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion1")) continue;
            info = regionInfo;
            try {
                this.admin.closeRegionWithEncodedRegionName("sample", rs.getServerName().getServerName());
            }
            catch (NotServingRegionException nsre) {}
        }
        onlineRegions = ProtobufUtil.getOnlineRegions(rs);
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    @Test(timeout=300000L)
    public void testCloseRegionThatFetchesTheHRIFromMeta() throws Exception {
        TableName TABLENAME = TableName.valueOf("TestHBACloseRegion2");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(rs);
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion2")) continue;
            info = regionInfo;
            this.admin.closeRegion(regionInfo.getRegionNameAsString(), rs.getServerName().getServerName());
        }
        boolean isInList = ProtobufUtil.getOnlineRegions(rs).contains(info);
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = ProtobufUtil.getOnlineRegions(rs).contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    @Test(timeout=300000L)
    public void testCloseRegionWhenServerNameIsNull() throws Exception {
        byte[] TABLENAME = Bytes.toBytes("TestHBACloseRegion3");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        try {
            List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(rs);
            for (HRegionInfo regionInfo : onlineRegions) {
                if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion3")) continue;
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), null);
            }
            Assert.fail((String)"The test should throw exception if the servername passed is null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCloseRegionWhenServerNameIsEmpty() throws Exception {
        byte[] TABLENAME = Bytes.toBytes("TestHBACloseRegionWhenServerNameIsEmpty");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        try {
            List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(rs);
            for (HRegionInfo regionInfo : onlineRegions) {
                if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegionWhenServerNameIsEmpty")) continue;
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getEncodedName(), " ");
            }
            Assert.fail((String)"The test should throw exception if the servername passed is empty.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCloseRegionWhenEncodedRegionNameIsNotGiven() throws Exception {
        byte[] TABLENAME = Bytes.toBytes("TestHBACloseRegion4");
        this.createTableWithDefaultConf(TABLENAME);
        HRegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLENAME);
        List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(rs);
        for (HRegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaTable() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion4")) continue;
            info = regionInfo;
            try {
                this.admin.closeRegionWithEncodedRegionName(regionInfo.getRegionNameAsString(), rs.getServerName().getServerName());
            }
            catch (NotServingRegionException nsre) {}
        }
        onlineRegions = ProtobufUtil.getOnlineRegions(rs);
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    private HBaseAdmin createTable(byte[] TABLENAME) throws IOException {
        Configuration config = TEST_UTIL.getConfiguration();
        HBaseAdmin admin = new HBaseAdmin(config);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(TABLENAME));
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable(htd, null);
        return admin;
    }

    private void createTableWithDefaultConf(byte[] TABLENAME) throws IOException {
        this.createTableWithDefaultConf(TableName.valueOf(TABLENAME));
    }

    private void createTableWithDefaultConf(TableName TABLENAME) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        this.admin.createTable(htd, null);
    }

    @Test(timeout=300000L)
    public void testGetTableRegions() throws IOException {
        byte[] tableName = Bytes.toBytes("testGetTableRegions");
        int expectedRegions = 10;
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        List<HRegionInfo> RegionInfos = this.admin.getTableRegions(tableName);
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + RegionInfos.size()), (long)expectedRegions, (long)RegionInfos.size());
    }

    @Test(timeout=300000L)
    public void testHLogRollWriting() throws Exception {
        this.setUpforLogRolling();
        String className = this.getClass().getName();
        StringBuilder v = new StringBuilder(className);
        while (v.length() < 1000) {
            v.append(className);
        }
        byte[] value = Bytes.toBytes(v.toString());
        HRegionServer regionServer = this.startAndWriteData("TestLogRolling", value);
        this.LOG.info("after writing there are " + HLogUtilsForTests.getNumRolledLogFiles(regionServer.getWAL()) + " log files");
        ArrayList<HRegion> regions = new ArrayList<HRegion>(regionServer.getOnlineRegionsLocalContext());
        for (HRegion r : regions) {
            r.flushcache();
        }
        this.admin.rollHLogWriter(regionServer.getServerName().getServerName());
        int count = HLogUtilsForTests.getNumRolledLogFiles(regionServer.getWAL());
        this.LOG.info("after flushing all regions and rolling logs there are " + count + " log files");
        Assert.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testMoveToPreviouslyAssignedRS() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes("testMoveToPreviouslyAssignedRS");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        HBaseAdmin localAdmin = this.createTable(tableName);
        List<HRegionInfo> tableRegions = localAdmin.getTableRegions(tableName);
        HRegionInfo hri = tableRegions.get(0);
        AssignmentManager am = master.getAssignmentManager();
        Assert.assertTrue((String)("Region " + hri.getRegionNameAsString() + " should be assigned properly"), (boolean)am.waitForAssignment(hri));
        ServerName server = am.getRegionStates().getRegionServerOfRegion(hri);
        localAdmin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes(server.getServerName()));
        Assert.assertEquals((String)"Current region server and region server before move should be same.", (Object)server, (Object)am.getRegionStates().getRegionServerOfRegion(hri));
    }

    private void setUpforLogRolling() {
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 786432L);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.maxlogentries", 32);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("ipc.ping.interval", 10000);
        TEST_UTIL.getConfiguration().setInt("ipc.socket.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.optionalflushcount", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 8192);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 10000L);
        TEST_UTIL.getConfiguration().setInt("hbase.server.thread.wakefrequency", 2000);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("heartbeat.recheck.interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.tolerable.lowreplication", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.lowreplication.rolllimit", 3);
    }

    private HRegionServer startAndWriteData(String tableName, byte[] value) throws IOException, InterruptedException {
        new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME).close();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(Bytes.toBytes(tableName));
        for (int i = 1; i <= 256; ++i) {
            Put put = new Put(Bytes.toBytes("row" + String.format("%1$04d", i)));
            put.add(HConstants.CATALOG_FAMILY, null, value);
            table.put(put);
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        table.close();
        return regionServer;
    }

    @Test(timeout=300000L)
    public void testCheckHBaseAvailableClosesConnection() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        int initialCount = HConnectionTestingUtility.getConnectionCount();
        HBaseAdmin.checkHBaseAvailable(conf);
        int finalCount = HConnectionTestingUtility.getConnectionCount();
        Assert.assertEquals((long)initialCount, (long)finalCount);
    }

    @Test(timeout=300000L)
    public void testCheckHBaseAvailableWithoutCluster() {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.zookeeper.property.clientPort", conf.getInt("hbase.zookeeper.property.clientPort", 9999) + 10);
        int initialCount = HConnectionTestingUtility.getConnectionCount();
        long start = System.currentTimeMillis();
        try {
            HBaseAdmin.checkHBaseAvailable(conf);
            Assert.assertTrue((boolean)false);
        }
        catch (MasterNotRunningException ignored) {
        }
        catch (ZooKeeperConnectionException ignored) {
        }
        catch (ServiceException ignored) {
        }
        catch (IOException ignored) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        int finalCount = HConnectionTestingUtility.getConnectionCount();
        Assert.assertEquals((long)initialCount, (long)finalCount);
        this.LOG.info("It took " + (end - start) + " ms to find out that" + " HBase was not available");
    }

    @Test(timeout=300000L)
    public void testDisableCatalogTable() throws Exception {
        try {
            this.admin.disableTable(TableName.META_TABLE_NAME);
            Assert.fail((String)"Expected to throw ConstraintException");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testDisableCatalogTable".getBytes()));
        HColumnDescriptor hcd = new HColumnDescriptor("cf1".getBytes());
        htd.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(htd);
    }

    @Test
    public void testIsEnabledOrDisabledOnUnknownTable() throws Exception {
        try {
            this.admin.isTableEnabled(Bytes.toBytes("unkownTable"));
            Assert.fail((String)"Test should fail if isTableEnabled called on unknown table.");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.admin.isTableDisabled(Bytes.toBytes("unkownTable"));
            Assert.fail((String)"Test should fail if isTableDisabled called on unknown table.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testGetRegion() throws Exception {
        String name = "testGetRegion";
        this.LOG.info("Started testGetRegion");
        byte[] nameBytes = Bytes.toBytes("testGetRegion");
        HTable t = TEST_UTIL.createTable(nameBytes, HConstants.CATALOG_FAMILY);
        TEST_UTIL.createMultiRegions(t, HConstants.CATALOG_FAMILY);
        CatalogTracker ct = new CatalogTracker(TEST_UTIL.getConfiguration());
        ct.start();
        try {
            HRegionLocation regionLocation = t.getRegionLocation("mmm");
            HRegionInfo region = regionLocation.getRegionInfo();
            byte[] regionName = region.getRegionName();
            Pair<HRegionInfo, ServerName> pair = this.admin.getRegion(regionName, ct);
            Assert.assertTrue((boolean)Bytes.equals(regionName, pair.getFirst().getRegionName()));
            pair = this.admin.getRegion(region.getEncodedNameAsBytes(), ct);
            Assert.assertTrue((boolean)Bytes.equals(regionName, pair.getFirst().getRegionName()));
        }
        finally {
            ct.stop();
        }
    }

    static class DoneListener
    implements EventHandler.EventHandlerListener {
        private final AtomicBoolean done;

        DoneListener(AtomicBoolean done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterProcess(EventHandler event) {
            this.done.set(true);
            AtomicBoolean atomicBoolean = this.done;
            synchronized (atomicBoolean) {
                this.done.notifyAll();
            }
        }

        @Override
        public void beforeProcess(EventHandler event) {
        }
    }
}

