/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCloneSnapshotFromClient {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final byte[] FAMILY = Bytes.toBytes("cf");
    private byte[] emptySnapshot;
    private byte[] snapshotName0;
    private byte[] snapshotName1;
    private byte[] snapshotName2;
    private int snapshot0Rows;
    private int snapshot1Rows;
    private TableName tableName;
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf("testtb-" + tid);
        this.emptySnapshot = Bytes.toBytes("emptySnaptb-" + tid);
        this.snapshotName0 = Bytes.toBytes("snaptb0-" + tid);
        this.snapshotName1 = Bytes.toBytes("snaptb1-" + tid);
        this.snapshotName2 = Bytes.toBytes("snaptb2-" + tid);
        SnapshotTestingUtils.createTable(TEST_UTIL, this.tableName, new byte[][]{this.FAMILY});
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        try {
            this.admin.enableTable(this.tableName);
            SnapshotTestingUtils.loadData(TEST_UTIL, table, 500, (byte[][])new byte[][]{this.FAMILY});
            this.snapshot0Rows = TEST_UTIL.countRows(table);
            this.admin.disableTable(this.tableName);
            this.admin.snapshot(this.snapshotName0, this.tableName);
            this.admin.enableTable(this.tableName);
            SnapshotTestingUtils.loadData(TEST_UTIL, table, 500, (byte[][])new byte[][]{this.FAMILY});
            this.snapshot1Rows = TEST_UTIL.countRows(table);
            this.admin.disableTable(this.tableName);
            this.admin.snapshot(this.snapshotName1, this.tableName);
            this.admin.enableTable(this.tableName);
        }
        finally {
            table.close();
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.admin.tableExists(this.tableName)) {
            TEST_UTIL.deleteTable(this.tableName);
        }
        SnapshotTestingUtils.deleteAllSnapshots(this.admin);
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws IOException, InterruptedException {
        String snapshotName = "random-snapshot-" + System.currentTimeMillis();
        String tableName = "random-table-" + System.currentTimeMillis();
        this.admin.cloneSnapshot(snapshotName, tableName);
    }

    @Test(expected=NamespaceNotFoundException.class)
    public void testCloneOnMissingNamespace() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf("unknownNS:clonetb");
        this.admin.cloneSnapshot(this.snapshotName1, clonedTableName);
    }

    @Test
    public void testCloneSnapshot() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf("clonedtb-" + System.currentTimeMillis());
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
        this.testCloneSnapshot(clonedTableName, this.emptySnapshot, 0);
    }

    private void testCloneSnapshot(TableName tableName, byte[] snapshotName, int snapshotRows) throws IOException, InterruptedException {
        this.admin.cloneSnapshot(snapshotName, tableName);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, tableName, snapshotRows);
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testCloneSnapshotCrossNamespace() throws IOException, InterruptedException {
        String nsName = "testCloneSnapshotCrossNamespace";
        this.admin.createNamespace(NamespaceDescriptor.create(nsName).build());
        TableName clonedTableName = TableName.valueOf(nsName, "clonedtb-" + System.currentTimeMillis());
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
        this.testCloneSnapshot(clonedTableName, this.emptySnapshot, 0);
    }

    @Test
    public void testCloneLinksAfterDelete() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf("clonedtb1-" + System.currentTimeMillis());
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName);
        this.admin.snapshot(this.snapshotName2, clonedTableName);
        TableName clonedTableName2 = TableName.valueOf("clonedtb2-" + System.currentTimeMillis());
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName2);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName2, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName2);
        TEST_UTIL.deleteTable(this.tableName);
        this.waitCleanerRun();
        this.admin.enableTable(clonedTableName);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        this.admin.enableTable(clonedTableName2);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName2, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName2);
        TEST_UTIL.deleteTable(clonedTableName);
        this.waitCleanerRun();
        this.admin.enableTable(clonedTableName2);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName2, this.snapshot0Rows);
        TableName clonedTableName3 = TableName.valueOf("clonedtb3-" + System.currentTimeMillis());
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName3);
        SnapshotTestingUtils.verifyRowCount(TEST_UTIL, clonedTableName3, this.snapshot0Rows);
        TEST_UTIL.deleteTable(clonedTableName2);
        TEST_UTIL.deleteTable(clonedTableName3);
        this.admin.deleteSnapshot(this.snapshotName2);
    }

    private void waitCleanerRun() throws InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
    }
}

