/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHCM {
    private static final Log LOG = LogFactory.getLog(TestHCM.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf("test");
    private static final TableName TABLE_NAME1 = TableName.valueOf("test1");
    private static final TableName TABLE_NAME2 = TableName.valueOf("test2");
    private static final TableName TABLE_NAME3 = TableName.valueOf("test3");
    private static final TableName TABLE_NAME4 = TableName.valueOf("test4");
    private static final byte[] FAM_NAM = Bytes.toBytes("f");
    private static final byte[] ROW = Bytes.toBytes("bbb");
    private static final byte[] ROW_X = Bytes.toBytes("xxx");
    private static Random _randy = new Random();
    protected static final AtomicBoolean syncBlockingFilter = new AtomicBoolean(false);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static int getHConnectionManagerCacheSize() {
        return HConnectionTestingUtility.getConnectionCount();
    }

    @Test
    public void testClusterConnection() throws IOException {
        ThreadPoolExecutor otherPool = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory("test-hcm"));
        HConnection con1 = HConnectionManager.createConnection(TEST_UTIL.getConfiguration());
        HConnection con2 = HConnectionManager.createConnection(TEST_UTIL.getConfiguration(), otherPool);
        Assert.assertTrue((otherPool == ((HConnectionManager.HConnectionImplementation)con2).getCurrentBatchPool() ? 1 : 0) != 0);
        String tableName = "testClusterConnection";
        TEST_UTIL.createTable(tableName.getBytes(), FAM_NAM).close();
        HTable t = (HTable)con1.getTable(tableName, (ExecutorService)otherPool);
        Assert.assertNull((String)"Internal Thread pool should be null", (Object)((HConnectionManager.HConnectionImplementation)con1).getCurrentBatchPool());
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con2.getTable(tableName);
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con2.getTable(Bytes.toBytes(tableName));
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con2.getTable(TableName.valueOf(tableName));
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con1.getTable(tableName);
        ExecutorService pool = ((HConnectionManager.HConnectionImplementation)con1).getCurrentBatchPool();
        Assert.assertNotNull((String)"An internal Thread pool should have been created", (Object)pool);
        Assert.assertTrue((t.getPool() == pool ? 1 : 0) != 0);
        t.close();
        t = (HTable)con1.getTable(tableName);
        Assert.assertTrue((t.getPool() == pool ? 1 : 0) != 0);
        t.close();
        con1.close();
        Assert.assertTrue((boolean)pool.isShutdown());
        con2.close();
        Assert.assertFalse((boolean)otherPool.isShutdown());
        otherPool.shutdownNow();
    }

    @Ignore(value="Fails in IDEs: HBASE-9042")
    @Test(expected=RegionServerStoppedException.class)
    public void testClusterStatus() throws Exception {
        TableName tn = TableName.valueOf("testClusterStatus");
        byte[] cf = "cf".getBytes();
        byte[] rk = "rk1".getBytes();
        JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
        rs.waitForServerOnline();
        final ServerName sn = rs.getRegionServer().getServerName();
        HTable t = TEST_UTIL.createTable(tn, cf);
        TEST_UTIL.waitTableAvailable(tn.getName());
        while (TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        final HConnectionManager.HConnectionImplementation hci = (HConnectionManager.HConnectionImplementation)t.getConnection();
        while (t.getRegionLocation(rk).getPort() != sn.getPort()) {
            TEST_UTIL.getHBaseAdmin().move(t.getRegionLocation(rk).getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes(sn.toString()));
            while (TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition()) {
                Thread.sleep(1L);
            }
            hci.clearRegionCache(tn);
        }
        Assert.assertNotNull((Object)hci.clusterStatusListener);
        TEST_UTIL.assertRegionOnServer(t.getRegionLocation(rk).getRegionInfo(), sn, 20000L);
        Put p1 = new Put(rk);
        p1.add(cf, "qual".getBytes(), "val".getBytes());
        t.put(p1);
        rs.getRegionServer().abort("I'm dead");
        TEST_UTIL.waitFor(40000L, 1000L, true, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getDeadServers().isDeadServer(sn);
            }
        });
        TEST_UTIL.waitFor(40000L, 1000L, true, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return hci.clusterStatusListener.isDeadServer(sn);
            }
        });
        t.close();
        hci.getClient(sn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionCut() throws Exception {
        String tableName = "HCM-testConnectionCut";
        TEST_UTIL.createTable(tableName.getBytes(), FAM_NAM).close();
        boolean previousBalance = TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, true);
        Configuration c2 = new Configuration(TEST_UTIL.getConfiguration());
        c2.set(HConstants.HBASE_CLIENT_INSTANCE_ID, String.valueOf(-1));
        c2.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        c2.setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, 30000);
        HTable table = new HTable(c2, tableName);
        Put p = new Put(FAM_NAM);
        p.add(FAM_NAM, FAM_NAM, FAM_NAM);
        table.put(p);
        final HConnectionManager.HConnectionImplementation hci = (HConnectionManager.HConnectionImplementation)table.getConnection();
        final HRegionLocation loc = table.getRegionLocation(FAM_NAM);
        Get get = new Get(FAM_NAM);
        Assert.assertNotNull((Object)table.get(get));
        get = new Get(FAM_NAM);
        get.setFilter(new BlockingFilter());
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = syncBlockingFilter;
                synchronized (atomicBoolean) {
                    try {
                        syncBlockingFilter.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                hci.clusterStatusListener.deadServerHandler.newDead(loc.getServerName());
            }
        };
        t.start();
        try {
            table.get(get);
            Assert.fail();
        }
        catch (IOException expected) {
            LOG.debug("Received: " + expected);
            Assert.assertFalse((boolean)(expected instanceof SocketTimeoutException));
            Assert.assertFalse((boolean)syncBlockingFilter.get());
        }
        finally {
            syncBlockingFilter.set(true);
            t.join();
            HConnectionManager.getConnection(c2).close();
            TEST_UTIL.getHBaseAdmin().setBalancerRunning(previousBalance, true);
        }
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void abortingHConnectionRemovesItselfFromHCM() throws Exception {
        HashMap<HConnectionKey, HConnectionManager.HConnectionImplementation> oldHBaseInstances = new HashMap<HConnectionKey, HConnectionManager.HConnectionImplementation>();
        oldHBaseInstances.putAll(HConnectionManager.CONNECTION_INSTANCES);
        HConnectionManager.CONNECTION_INSTANCES.clear();
        try {
            HConnection connection = HConnectionManager.getConnection(TEST_UTIL.getConfiguration());
            connection.abort("test abortingHConnectionRemovesItselfFromHCM", new Exception("test abortingHConnectionRemovesItselfFromHCM"));
            Assert.assertNotSame((Object)connection, (Object)HConnectionManager.getConnection(TEST_UTIL.getConfiguration()));
        }
        finally {
            HConnectionManager.CONNECTION_INSTANCES.clear();
            HConnectionManager.CONNECTION_INSTANCES.putAll(oldHBaseInstances);
        }
    }

    @Test
    public void testRegionCaching() throws Exception {
        TEST_UTIL.createTable(TABLE_NAME, FAM_NAM).close();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        HTable table = new HTable(conf, TABLE_NAME);
        TEST_UTIL.createMultiRegions(table, FAM_NAM);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        HConnectionManager.HConnectionImplementation conn = (HConnectionManager.HConnectionImplementation)table.getConnection();
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        int nextPort = conn.getCachedLocation(TABLE_NAME, ROW).getPort() + 1;
        HRegionLocation loc = conn.getCachedLocation(TABLE_NAME, ROW);
        conn.updateCachedLocation(loc.getRegionInfo(), loc, ServerName.valueOf("127.0.0.1", nextPort, Long.MAX_VALUE), Long.MAX_VALUE);
        Assert.assertEquals((long)conn.getCachedLocation(TABLE_NAME, ROW).getPort(), (long)nextPort);
        conn.forceDeleteCachedLocation(TABLE_NAME, (byte[])ROW.clone());
        HRegionLocation rl = conn.getCachedLocation(TABLE_NAME, ROW);
        Assert.assertNull((String)("What is this location?? " + rl), (Object)rl);
        conn.clearRegionCache(TABLE_NAME);
        Assert.assertEquals((long)0L, (long)conn.getNumberOfCachedRegionLocations(TABLE_NAME));
        Put put2 = new Put(ROW);
        put2.add(FAM_NAM, ROW, ROW);
        table.put(put2);
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        Assert.assertNotNull((Object)conn.getCachedLocation(TableName.valueOf(TABLE_NAME.getName()), (byte[])ROW.clone()));
        TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, false);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        while (master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        HRegionLocation toMove = conn.getCachedLocation(TABLE_NAME, ROW);
        byte[] regionName = toMove.getRegionInfo().getRegionName();
        byte[] encodedRegionNameBytes = toMove.getRegionInfo().getEncodedNameAsBytes();
        int curServerId = TEST_UTIL.getHBaseCluster().getServerWith(regionName);
        int destServerId = curServerId == 0 ? 1 : 0;
        HRegionServer curServer = TEST_UTIL.getHBaseCluster().getRegionServer(curServerId);
        HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(destServerId);
        ServerName destServerName = destServer.getServerName();
        Assert.assertTrue((curServer != destServer ? 1 : 0) != 0);
        Assert.assertFalse((boolean)curServer.getServerName().equals(destServer.getServerName()));
        Assert.assertFalse((toMove.getPort() == destServerName.getPort() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNull((Object)destServer.getOnlineRegion(regionName));
        Assert.assertFalse((boolean)TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition());
        LOG.info("Move starting region=" + toMove.getRegionInfo().getRegionNameAsString());
        TEST_UTIL.getHBaseAdmin().move(toMove.getRegionInfo().getEncodedNameAsBytes(), destServerName.getServerName().getBytes());
        while (destServer.getOnlineRegion(regionName) == null || destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        LOG.info("Move finished for region=" + toMove.getRegionInfo().getRegionNameAsString());
        Assert.assertNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNotNull((Object)destServer.getOnlineRegion(regionName));
        Assert.assertFalse((boolean)destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((boolean)curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((conn.getCachedLocation(TABLE_NAME, ROW).getPort() == destServerName.getPort() ? 1 : 0) != 0);
        LOG.info("Put starting");
        Put put3 = new Put(ROW);
        put3.add(FAM_NAM, ROW, ROW);
        try {
            table.put(put3);
            Assert.fail((String)"Unreachable point");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            LOG.info("Put done, exception caught: " + e.getClass());
            Assert.assertEquals((long)1L, (long)e.getNumExceptions());
            Assert.assertEquals((long)1L, (long)e.getCauses().size());
            Assert.assertArrayEquals((byte[])e.getRow(0).getRow(), (byte[])ROW);
            Throwable cause = HConnectionManager.findException(e.getCause(0));
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof RegionMovedException));
        }
        Assert.assertNotNull((String)"Cached connection is null", (Object)conn.getCachedLocation(TABLE_NAME, ROW));
        Assert.assertEquals((String)("Previous server was " + curServer.getServerName().getHostAndPort()), (long)destServerName.getPort(), (long)conn.getCachedLocation(TABLE_NAME, ROW).getPort());
        Assert.assertFalse((boolean)destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((boolean)curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        LOG.info("Move starting region=" + toMove.getRegionInfo().getRegionNameAsString());
        TEST_UTIL.getHBaseAdmin().move(toMove.getRegionInfo().getEncodedNameAsBytes(), curServer.getServerName().getServerName().getBytes());
        while (curServer.getOnlineRegion(regionName) == null || destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        Assert.assertNotNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNull((Object)destServer.getOnlineRegion(regionName));
        LOG.info("Move finished for region=" + toMove.getRegionInfo().getRegionNameAsString());
        Assert.assertFalse((conn.getCachedLocation(TABLE_NAME, ROW).getPort() == curServer.getServerName().getPort() ? 1 : 0) != 0);
        Scan sc = new Scan();
        sc.setStopRow(ROW);
        sc.setStartRow(ROW);
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        try {
            ResultScanner rs = table.getScanner(sc);
            while (rs.next() != null) {
            }
            Assert.fail((String)"Unreachable point");
        }
        catch (RetriesExhaustedException e) {
            LOG.info("Scan done, expected exception caught: " + e.getClass());
        }
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        Assert.assertEquals((String)("Previous server was " + destServer.getServerName().getHostAndPort()), (long)curServer.getServerName().getPort(), (long)conn.getCachedLocation(TABLE_NAME, ROW).getPort());
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        table.close();
    }

    @Test
    public void testConnectionManagement() throws Exception {
        HTable table0 = TEST_UTIL.createTable(TABLE_NAME1, FAM_NAM);
        HConnection conn = HConnectionManager.createConnection(TEST_UTIL.getConfiguration());
        HTableInterface table = conn.getTable(TABLE_NAME1.getName());
        table.close();
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertFalse((boolean)((HTable)table).getPool().isShutdown());
        table = conn.getTable(TABLE_NAME1.getName());
        table.close();
        Assert.assertFalse((boolean)((HTable)table).getPool().isShutdown());
        conn.close();
        Assert.assertTrue((boolean)((HTable)table).getPool().isShutdown());
        table0.close();
    }

    @Test(timeout=60000L)
    public void testCacheSeqNums() throws Exception {
        HTable table = TEST_UTIL.createTable(TABLE_NAME2, FAM_NAM);
        TEST_UTIL.createMultiRegions(table, FAM_NAM);
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        HConnectionManager.HConnectionImplementation conn = (HConnectionManager.HConnectionImplementation)table.getConnection();
        HRegionLocation location = conn.getCachedLocation(TABLE_NAME2, ROW);
        Assert.assertNotNull((Object)location);
        HRegionLocation anySource = new HRegionLocation(location.getRegionInfo(), ServerName.valueOf(location.getHostname(), location.getPort() - 1, 0L));
        int nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), location, ServerName.valueOf("127.0.0.1", nextPort, 0L), location.getSeqNum() - 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW);
        Assert.assertEquals((long)nextPort, (long)location.getPort());
        nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), location, ServerName.valueOf("127.0.0.1", nextPort, 0L), location.getSeqNum() - 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW);
        Assert.assertEquals((long)nextPort, (long)location.getPort());
        nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), anySource, ServerName.valueOf("127.0.0.1", nextPort, 0L), location.getSeqNum() + 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW);
        Assert.assertEquals((long)nextPort, (long)location.getPort());
        nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), anySource, ServerName.valueOf("127.0.0.1", nextPort, 0L), location.getSeqNum() - 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW);
        Assert.assertEquals((long)(nextPort - 1), (long)location.getPort());
        table.close();
    }

    @Test
    public void testConnectionSameness() throws Exception {
        HConnection previousConnection = null;
        for (int i = 0; i < 2; ++i) {
            Configuration configuration = TEST_UTIL.getConfiguration();
            configuration.set("some_key", String.valueOf(_randy.nextInt()));
            LOG.info("The hash code of the current configuration is: " + configuration.hashCode());
            HConnection currentConnection = HConnectionManager.getConnection(configuration);
            if (previousConnection != null) {
                Assert.assertTrue((String)"Did not get the same connection even though its key didn't change", (previousConnection == currentConnection ? 1 : 0) != 0);
            }
            previousConnection = currentConnection;
            configuration.set("other_key", String.valueOf(_randy.nextInt()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionUniqueness() throws Exception {
        int zkmaxconnections = TEST_UTIL.getConfiguration().getInt("hbase.zookeeper.property.maxClientCnxns", 300);
        int maxConnections = Math.min(zkmaxconnections - 1, 20);
        ArrayList<HConnection> connections = new ArrayList<HConnection>(maxConnections);
        HConnection previousConnection = null;
        try {
            for (int i = 0; i < maxConnections; ++i) {
                Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
                configuration.set("some_key", String.valueOf(_randy.nextInt()));
                configuration.set(HConstants.HBASE_CLIENT_INSTANCE_ID, String.valueOf(_randy.nextInt()));
                LOG.info("The hash code of the current configuration is: " + configuration.hashCode());
                HConnection currentConnection = HConnectionManager.getConnection(configuration);
                if (previousConnection != null) {
                    Assert.assertTrue((String)"Got the same connection even though its key changed!", (previousConnection != currentConnection ? 1 : 0) != 0);
                }
                configuration.set("other_key", String.valueOf(_randy.nextInt()));
                previousConnection = currentConnection;
                LOG.info("The current HConnectionManager#HBASE_INSTANCES cache size is: " + TestHCM.getHConnectionManagerCacheSize());
                Thread.sleep(50L);
                connections.add(currentConnection);
            }
        }
        finally {
            for (HConnection c : connections) {
                HConnectionManager.deleteConnection(c.getConfiguration());
            }
        }
    }

    @Test
    public void testClosing() throws Exception {
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        configuration.set(HConstants.HBASE_CLIENT_INSTANCE_ID, String.valueOf(_randy.nextInt()));
        HConnection c1 = HConnectionManager.createConnection(configuration);
        HConnection c2 = HConnectionManager.createConnection(configuration);
        HConnection c3 = HConnectionManager.getConnection(configuration);
        HConnection c4 = HConnectionManager.getConnection(configuration);
        Assert.assertTrue((c3 == c4 ? 1 : 0) != 0);
        c1.close();
        Assert.assertTrue((boolean)c1.isClosed());
        Assert.assertFalse((boolean)c2.isClosed());
        Assert.assertFalse((boolean)c3.isClosed());
        c3.close();
        Assert.assertFalse((boolean)c3.isClosed());
        c3.close();
        Assert.assertTrue((boolean)c3.isClosed());
        HConnection c5 = HConnectionManager.getConnection(configuration);
        Assert.assertTrue((c5 != c3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)c2.isClosed());
        c2.close();
        Assert.assertTrue((boolean)c2.isClosed());
        c5.close();
        Assert.assertTrue((boolean)c5.isClosed());
    }

    @Test
    public void testCreateConnection() throws Exception {
        HConnection c2;
        Configuration configuration = TEST_UTIL.getConfiguration();
        HConnection c1 = HConnectionManager.createConnection(configuration);
        Assert.assertTrue((c1 != (c2 = HConnectionManager.createConnection(configuration)) ? 1 : 0) != 0);
        Assert.assertTrue((c1.getConfiguration() == c2.getConfiguration() ? 1 : 0) != 0);
        HConnection c3 = HConnectionManager.getConnection(configuration);
        Assert.assertTrue((c1 != c3 ? 1 : 0) != 0);
        Assert.assertTrue((c2 != c3 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testConnection() throws Exception {
        Configuration c = new Configuration();
        c.set("hbase.zookeeper.quorum", TEST_UTIL.getConfiguration().get("hbase.zookeeper.quorum"));
        c.set("hbase.zookeeper.property.clientPort", TEST_UTIL.getConfiguration().get("hbase.zookeeper.property.clientPort"));
        HConnection conn = HConnectionManager.getConnection(c);
        Assert.assertTrue((boolean)conn.isMasterRunning());
        conn.close();
    }

    private int setNumTries(HConnectionManager.HConnectionImplementation hci, int newVal) throws Exception {
        Field numTries = hci.getClass().getDeclaredField("numTries");
        numTries.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(numTries, numTries.getModifiers() & 0xFFFFFFEF);
        int prevNumRetriesVal = (Integer)numTries.get(hci);
        numTries.set(hci, newVal);
        return prevNumRetriesVal;
    }

    @Test
    public void testMulti() throws Exception {
        HTable table = TEST_UTIL.createTable(TABLE_NAME3, FAM_NAM);
        TEST_UTIL.createMultiRegions(table, FAM_NAM);
        HConnectionManager.HConnectionImplementation conn = (HConnectionManager.HConnectionImplementation)HConnectionManager.getConnection(TEST_UTIL.getConfiguration());
        conn.clearRegionCache(TABLE_NAME3);
        Assert.assertEquals((long)0L, (long)conn.getNumberOfCachedRegionLocations(TABLE_NAME3));
        TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, false);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        while (master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        Put put = new Put(ROW_X);
        put.add(FAM_NAM, ROW_X, ROW_X);
        table.put(put);
        HRegionLocation toMove = conn.getCachedLocation(TABLE_NAME3, ROW_X);
        byte[] regionName = toMove.getRegionInfo().getRegionName();
        byte[] encodedRegionNameBytes = toMove.getRegionInfo().getEncodedNameAsBytes();
        int curServerId = TEST_UTIL.getHBaseCluster().getServerWith(regionName);
        int destServerId = curServerId == 0 ? 1 : 0;
        HRegionServer curServer = TEST_UTIL.getHBaseCluster().getRegionServer(curServerId);
        HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(destServerId);
        ServerName destServerName = destServer.getServerName();
        List<HRegion> regions = curServer.getOnlineRegions(TABLE_NAME3);
        byte[] otherRow = null;
        for (HRegion region : regions) {
            if (region.getRegionInfo().getEncodedName().equals(toMove.getRegionInfo().getEncodedName()) || Bytes.BYTES_COMPARATOR.compare(region.getRegionInfo().getStartKey(), ROW_X) >= 0) continue;
            otherRow = region.getRegionInfo().getStartKey();
            break;
        }
        Assert.assertNotNull(otherRow);
        if (otherRow.length <= 0) {
            otherRow = Bytes.toBytes("aaa");
        }
        Put put2 = new Put(otherRow);
        put2.add(FAM_NAM, otherRow, otherRow);
        table.put(put2);
        Assert.assertTrue((curServer != destServer ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)curServer.getServerName(), (Object)destServer.getServerName());
        Assert.assertNotEquals((long)toMove.getPort(), (long)destServerName.getPort());
        Assert.assertNotNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNull((Object)destServer.getOnlineRegion(regionName));
        Assert.assertFalse((boolean)TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition());
        LOG.info("Move starting region=" + toMove.getRegionInfo().getRegionNameAsString());
        TEST_UTIL.getHBaseAdmin().move(toMove.getRegionInfo().getEncodedNameAsBytes(), destServerName.getServerName().getBytes());
        while (destServer.getOnlineRegion(regionName) == null || destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        LOG.info("Move finished for region=" + toMove.getRegionInfo().getRegionNameAsString());
        Assert.assertNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNotNull((Object)destServer.getOnlineRegion(regionName));
        Assert.assertFalse((boolean)destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((boolean)curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((conn.getCachedLocation(TABLE_NAME3, ROW_X).getPort() == destServerName.getPort() ? 1 : 0) != 0);
        int prevNumRetriesVal = this.setNumTries(conn, 2);
        Put put3 = new Put(ROW_X);
        put3.add(FAM_NAM, ROW_X, ROW_X);
        Put put4 = new Put(otherRow);
        put4.add(FAM_NAM, otherRow, otherRow);
        table.batch(Lists.newArrayList(put4, put3));
        this.setNumTries(conn, prevNumRetriesVal);
        table.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Test presumes RETRY_BACKOFF will never change; it has")
    @Test
    public void testErrorBackoffTimeCalculation() throws Exception {
        long ANY_PAUSE = 100L;
        HRegionInfo ri = new HRegionInfo(TABLE_NAME);
        HRegionLocation location = new HRegionLocation(ri, ServerName.valueOf("127.0.0.1", 1, 0L));
        HRegionLocation diffLocation = new HRegionLocation(ri, ServerName.valueOf("127.0.0.1", 2, 0L));
        ManualEnvironmentEdge timeMachine = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge(timeMachine);
        try {
            long timeBase = timeMachine.currentTimeMillis();
            long largeAmountOfTime = 100000L;
            HConnectionManager.ServerErrorTracker tracker = new HConnectionManager.ServerErrorTracker(largeAmountOfTime, 100);
            Assert.assertEquals((long)0L, (long)tracker.calculateBackoffTime(location, 100L));
            tracker.reportServerError(location);
            TestHCM.assertEqualsWithJitter(100L, tracker.calculateBackoffTime(location, 100L));
            tracker.reportServerError(location);
            tracker.reportServerError(location);
            tracker.reportServerError(location);
            TestHCM.assertEqualsWithJitter(500L, tracker.calculateBackoffTime(location, 100L));
            Assert.assertEquals((long)0L, (long)tracker.calculateBackoffTime(diffLocation, 100L));
            tracker.reportServerError(diffLocation);
            TestHCM.assertEqualsWithJitter(100L, tracker.calculateBackoffTime(diffLocation, 100L));
            HRegionInfo ri2 = new HRegionInfo(TABLE_NAME2);
            HRegionLocation diffRegion = new HRegionLocation(ri2, location.getServerName());
            TestHCM.assertEqualsWithJitter(500L, tracker.calculateBackoffTime(diffRegion, 100L));
            TestHCM.assertEqualsWithJitter(1000L, tracker.calculateBackoffTime(location, 200L));
            long timeShift = 50L;
            timeMachine.setValue(timeBase + timeShift);
            TestHCM.assertEqualsWithJitter(500L - timeShift, tracker.calculateBackoffTime(location, 100L), 200L);
            timeMachine.setValue(timeBase + 10000L);
            Assert.assertEquals((long)0L, (long)tracker.calculateBackoffTime(location, 100L));
            long timeLeft = 50L;
            timeMachine.setValue(timeBase + largeAmountOfTime - timeLeft);
            Assert.assertTrue((boolean)tracker.canRetryMore(1));
            tracker.reportServerError(location);
            Assert.assertEquals((long)timeLeft, (long)tracker.calculateBackoffTime(location, 100L));
            timeMachine.setValue(timeBase + largeAmountOfTime);
            Assert.assertFalse((boolean)tracker.canRetryMore(1));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static void assertEqualsWithJitter(long expected, long actual) {
        TestHCM.assertEqualsWithJitter(expected, actual, expected);
    }

    private static void assertEqualsWithJitter(long expected, long actual, long jitterBase) {
        Assert.assertTrue((String)("Value not within jitter: " + expected + " vs " + actual), ((float)Math.abs(actual - expected) <= 0.01f * (float)jitterBase ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey test: See HBASE-8996")
    @Test
    public void testDeleteForZKConnLeak() throws Exception {
        TEST_UTIL.createTable(TABLE_NAME4, FAM_NAM);
        final Configuration config = HBaseConfiguration.create(TEST_UTIL.getConfiguration());
        config.setInt("zookeeper.recovery.retry", 1);
        config.setInt("zookeeper.recovery.retry.intervalmill", 1000);
        config.setInt("hbase.rpc.timeout", 2000);
        config.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 10, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory("test-hcm-delete"));
        pool.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        HConnection conn = HConnectionManager.getConnection(config);
                        LOG.info("Connection " + conn);
                        HConnectionManager.deleteStaleConnection(conn);
                        LOG.info("Connection closed " + conn);
                        Threads.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        for (int i = 0; i < 30; ++i) {
            HConnection c1 = null;
            try {
                c1 = HConnectionManager.getConnection(config);
                LOG.info("HTable connection " + i + " " + c1);
                HTable table = new HTable(TABLE_NAME4, c1, (ExecutorService)pool);
                table.close();
                LOG.info("HTable connection " + i + " closed " + c1);
                continue;
            }
            catch (Exception e) {
                LOG.info("We actually want this to happen!!!!  So we can see if we are leaking zk", e);
                continue;
            }
            finally {
                if (c1 != null) {
                    if (c1.isClosed()) {
                        Field zkwField = c1.getClass().getDeclaredField("keepAliveZookeeper");
                        zkwField.setAccessible(true);
                        Object watcher = zkwField.get(c1);
                        if (watcher != null && ((ZooKeeperWatcher)watcher).getRecoverableZooKeeper().getState().isAlive()) {
                            Thread.sleep(1000L);
                            if (((ZooKeeperWatcher)watcher).getRecoverableZooKeeper().getState().isAlive()) {
                                pool.shutdownNow();
                                Assert.fail((String)"Live zookeeper in closed connection");
                            }
                        }
                    }
                    c1.close();
                }
            }
        }
        pool.shutdownNow();
    }

    public static class BlockingFilter
    extends FilterBase {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
            int i = 0;
            while (i++ < 1000 && !syncBlockingFilter.get()) {
                AtomicBoolean atomicBoolean = syncBlockingFilter;
                synchronized (atomicBoolean) {
                    syncBlockingFilter.notifyAll();
                }
                Threads.sleep(100L);
            }
            syncBlockingFilter.set(true);
            return false;
        }

        public static Filter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new BlockingFilter();
        }
    }
}

