/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHTableUtil {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[] VALUE = Bytes.toBytes("testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testBucketPut() throws Exception {
        byte[] TABLE = Bytes.toBytes("testBucketPut");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        ht.setAutoFlush(false, true);
        ArrayList<Put> puts = new ArrayList<Put>();
        puts.add(this.createPut("row1"));
        puts.add(this.createPut("row2"));
        puts.add(this.createPut("row3"));
        puts.add(this.createPut("row4"));
        HTableUtil.bucketRsPut(ht, puts);
        Scan scan = new Scan();
        scan.addColumn(FAMILY, QUALIFIER);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            ++count;
        }
        this.LOG.info("bucket put count=" + count);
        Assert.assertEquals((long)count, (long)puts.size());
        ht.close();
    }

    private Put createPut(String row) {
        Put put = new Put(Bytes.toBytes(row));
        put.add(FAMILY, QUALIFIER, VALUE);
        return put;
    }

    @Test
    public void testBucketBatch() throws Exception {
        byte[] TABLE = Bytes.toBytes("testBucketBatch");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        ArrayList<Row> rows = new ArrayList<Row>();
        rows.add(this.createPut("row1"));
        rows.add(this.createPut("row2"));
        rows.add(this.createPut("row3"));
        rows.add(this.createPut("row4"));
        HTableUtil.bucketRsBatch(ht, rows);
        Scan scan = new Scan();
        scan.addColumn(FAMILY, QUALIFIER);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            ++count;
        }
        this.LOG.info("bucket batch count=" + count);
        Assert.assertEquals((long)count, (long)rows.size());
        ht.close();
    }
}

