/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSnapshotFromClient {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFromClient.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static final String STRING_TABLE_NAME = "test";
    private static final byte[] TEST_FAM = Bytes.toBytes("fam");
    private static final TableName TABLE_NAME = TableName.valueOf("test");

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @Before
    public void setup() throws Exception {
        UTIL.createTable(TABLE_NAME, TEST_FAM);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", e);
        }
    }

    @Test(timeout=300000L)
    public void testMetaTablesSnapshot() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        byte[] snapshotName = Bytes.toBytes("metaSnapshot");
        try {
            admin.snapshot(snapshotName, TableName.META_TABLE_NAME);
            Assert.fail((String)"taking a snapshot of hbase:meta should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testSnapshotDeletionWithRegex() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        HTable table = new HTable(UTIL.getConfiguration(), TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM);
        table.close();
        byte[] snapshot1 = Bytes.toBytes("TableSnapshot1");
        admin.snapshot(snapshot1, TABLE_NAME);
        LOG.debug("Snapshot1 completed.");
        byte[] snapshot2 = Bytes.toBytes("TableSnapshot2");
        admin.snapshot(snapshot2, TABLE_NAME);
        LOG.debug("Snapshot2 completed.");
        String snapshot3 = "3rdTableSnapshot";
        admin.snapshot(Bytes.toBytes(snapshot3), TABLE_NAME);
        LOG.debug(snapshot3 + " completed.");
        admin.deleteSnapshots("TableSnapshot.*");
        List<HBaseProtos.SnapshotDescription> snapshots = admin.listSnapshots();
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)snapshots.get(0).getName(), (Object)snapshot3);
        admin.deleteSnapshot(snapshot3);
        admin.close();
    }

    @Test(timeout=300000L)
    public void testOfflineTableSnapshot() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        HTable table = new HTable(UTIL.getConfiguration(), TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM, false);
        HashSet<String> snapshotServers = new HashSet<String>();
        List<JVMClusterUtil.RegionServerThread> servers = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread server : servers) {
            if (server.getRegionServer().getOnlineRegions(TABLE_NAME).size() <= 0) continue;
            snapshotServers.add(server.getRegionServer().getServerName().toString());
        }
        LOG.debug("FS state before disable:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug("FS state before snapshot:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        byte[] snapshot = Bytes.toBytes("offlineTableSnapshot");
        admin.snapshot(snapshot, TABLE_NAME);
        LOG.debug("Snapshot completed.");
        List<HBaseProtos.SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug("FS state after snapshot:");
        FSUtils.logFileSystemState(UTIL.getTestFileSystem(), FSUtils.getRootDir(UTIL.getConfiguration()), LOG);
        SnapshotTestingUtils.confirmSnapshotValid(snapshots.get(0), TABLE_NAME, TEST_FAM, rootDir, admin, fs, false, new Path(rootDir, "WALs"), snapshotServers);
        admin.deleteSnapshot(snapshot);
        snapshots = admin.listSnapshots();
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    @Test(timeout=300000L)
    public void testSnapshotFailsOnNonExistantTable() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        String tableName = "_not_a_table";
        boolean fail = false;
        do {
            try {
                admin.getTableDescriptor(Bytes.toBytes(tableName));
                fail = true;
                LOG.error("Table:" + tableName + " already exists, checking a new name");
                tableName = tableName + "!";
            }
            catch (TableNotFoundException e) {
                fail = false;
            }
        } while (fail);
        try {
            admin.snapshot("fail", tableName);
            Assert.fail((String)"Snapshot succeeded even though there is not table.");
        }
        catch (SnapshotCreationException e) {
            LOG.info("Correctly failed to snapshot a non-existant table:" + e.getMessage());
        }
    }
}

