/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotMetadata {
    private static final Log LOG = LogFactory.getLog(TestSnapshotMetadata.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static final String STRING_TABLE_NAME = "TestSnapshotMetadata";
    private static final String MAX_VERSIONS_FAM_STR = "fam_max_columns";
    private static final byte[] MAX_VERSIONS_FAM = Bytes.toBytes("fam_max_columns");
    private static final String COMPRESSED_FAM_STR = "fam_compressed";
    private static final byte[] COMPRESSED_FAM = Bytes.toBytes("fam_compressed");
    private static final String BLOCKSIZE_FAM_STR = "fam_blocksize";
    private static final byte[] BLOCKSIZE_FAM = Bytes.toBytes("fam_blocksize");
    private static final String BLOOMFILTER_FAM_STR = "fam_bloomfilter";
    private static final byte[] BLOOMFILTER_FAM = Bytes.toBytes("fam_bloomfilter");
    private static final String TEST_CONF_CUSTOM_VALUE = "TestCustomConf";
    private static final String TEST_CUSTOM_VALUE = "TestCustomValue";
    private static final byte[][] families = new byte[][]{MAX_VERSIONS_FAM, BLOOMFILTER_FAM, COMPRESSED_FAM, BLOCKSIZE_FAM};
    private static final DataBlockEncoding DATA_BLOCK_ENCODING_TYPE = DataBlockEncoding.FAST_DIFF;
    private static final BloomType BLOOM_TYPE = BloomType.ROW;
    private static final int BLOCK_SIZE = 98;
    private static final int MAX_VERSIONS = 8;
    private HBaseAdmin admin;
    private String originalTableDescription;
    private HTableDescriptor originalTableDescriptor;
    TableName originalTableName;
    private static FileSystem fs;
    private static Path rootDir;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotMetadata.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", e);
        }
    }

    private static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @Before
    public void setup() throws Exception {
        this.admin = UTIL.getHBaseAdmin();
        this.createTableWithNonDefaultProperties();
    }

    @After
    public void tearDown() throws Exception {
        SnapshotTestingUtils.deleteAllSnapshots(this.admin);
    }

    private void createTableWithNonDefaultProperties() throws Exception {
        long startTime = System.currentTimeMillis();
        String sourceTableNameAsString = STRING_TABLE_NAME + startTime;
        this.originalTableName = TableName.valueOf(sourceTableNameAsString);
        HColumnDescriptor maxVersionsColumn = new HColumnDescriptor(MAX_VERSIONS_FAM);
        HColumnDescriptor bloomFilterColumn = new HColumnDescriptor(BLOOMFILTER_FAM);
        HColumnDescriptor dataBlockColumn = new HColumnDescriptor(COMPRESSED_FAM);
        HColumnDescriptor blockSizeColumn = new HColumnDescriptor(BLOCKSIZE_FAM);
        maxVersionsColumn.setMaxVersions(8);
        bloomFilterColumn.setBloomFilterType(BLOOM_TYPE);
        dataBlockColumn.setDataBlockEncoding(DATA_BLOCK_ENCODING_TYPE);
        blockSizeColumn.setBlocksize(98);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(sourceTableNameAsString));
        htd.addFamily(maxVersionsColumn);
        htd.addFamily(bloomFilterColumn);
        htd.addFamily(dataBlockColumn);
        htd.addFamily(blockSizeColumn);
        htd.setValue(TEST_CUSTOM_VALUE, TEST_CUSTOM_VALUE);
        htd.setConfiguration(TEST_CONF_CUSTOM_VALUE, TEST_CONF_CUSTOM_VALUE);
        Assert.assertTrue((htd.getConfiguration().size() > 0 ? 1 : 0) != 0);
        this.admin.createTable(htd);
        HTable original = new HTable(UTIL.getConfiguration(), this.originalTableName);
        this.originalTableName = TableName.valueOf(sourceTableNameAsString);
        this.originalTableDescriptor = this.admin.getTableDescriptor(this.originalTableName);
        this.originalTableDescription = this.originalTableDescriptor.toStringCustomizedValues();
        original.close();
    }

    @Test(timeout=300000L)
    public void testDescribeMatchesAfterClone() throws Exception {
        String clonedTableNameAsString = "clone" + this.originalTableName;
        byte[] clonedTableName = Bytes.toBytes(clonedTableNameAsString);
        String snapshotNameAsString = "snapshot" + this.originalTableName + System.currentTimeMillis();
        byte[] snapshotName = Bytes.toBytes(snapshotNameAsString);
        ArrayList<byte[]> familiesList = new ArrayList<byte[]>();
        for (byte[] family : families) {
            familiesList.add(family);
        }
        SnapshotTestingUtils.createSnapshotAndValidate(this.admin, this.originalTableName, null, familiesList, snapshotNameAsString, rootDir, fs, false);
        this.admin.cloneSnapshot(snapshotName, clonedTableName);
        HTable clonedTable = new HTable(UTIL.getConfiguration(), clonedTableName);
        HTableDescriptor cloneHtd = this.admin.getTableDescriptor(clonedTableName);
        Assert.assertEquals((Object)this.originalTableDescription.replace(this.originalTableName.getNameAsString(), clonedTableNameAsString), (Object)cloneHtd.toStringCustomizedValues());
        Assert.assertEquals((long)this.originalTableDescriptor.getValues().size(), (long)cloneHtd.getValues().size());
        Assert.assertEquals((long)this.originalTableDescriptor.getConfiguration().size(), (long)cloneHtd.getConfiguration().size());
        Assert.assertEquals((Object)cloneHtd.getValue(TEST_CUSTOM_VALUE), (Object)TEST_CUSTOM_VALUE);
        Assert.assertEquals((Object)cloneHtd.getConfigurationValue(TEST_CONF_CUSTOM_VALUE), (Object)TEST_CONF_CUSTOM_VALUE);
        Assert.assertEquals(this.originalTableDescriptor.getValues(), cloneHtd.getValues());
        Assert.assertEquals(this.originalTableDescriptor.getConfiguration(), cloneHtd.getConfiguration());
        this.admin.enableTable(this.originalTableName);
        clonedTable.close();
    }

    @Test(timeout=300000L)
    public void testDescribeMatchesAfterRestore() throws Exception {
        this.runRestoreWithAdditionalMetadata(false);
    }

    @Test(timeout=300000L)
    public void testDescribeMatchesAfterMetadataChangeAndRestore() throws Exception {
        this.runRestoreWithAdditionalMetadata(true);
    }

    @Test(timeout=300000L)
    public void testDescribeOnEmptyTableMatchesAfterMetadataChangeAndRestore() throws Exception {
        this.runRestoreWithAdditionalMetadata(true, false);
    }

    private void runRestoreWithAdditionalMetadata(boolean changeMetadata) throws Exception {
        this.runRestoreWithAdditionalMetadata(changeMetadata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRestoreWithAdditionalMetadata(boolean changeMetadata, boolean addData) throws Exception {
        if (this.admin.isTableDisabled(this.originalTableName)) {
            this.admin.enableTable(this.originalTableName);
        }
        byte[] familyForUpdate = BLOCKSIZE_FAM;
        ArrayList<byte[]> familiesWithDataList = new ArrayList<byte[]>();
        ArrayList<byte[]> emptyFamiliesList = new ArrayList<byte[]>();
        if (addData) {
            HTable original = new HTable(UTIL.getConfiguration(), this.originalTableName);
            UTIL.loadTable(original, familyForUpdate);
            original.close();
            for (byte[] family : families) {
                if (family == familyForUpdate) continue;
                emptyFamiliesList.add(family);
            }
            familiesWithDataList.add(familyForUpdate);
        } else {
            for (byte[] family : families) {
                emptyFamiliesList.add(family);
            }
        }
        String snapshotNameAsString = "snapshot" + this.originalTableName + System.currentTimeMillis();
        byte[] snapshotName = Bytes.toBytes(snapshotNameAsString);
        SnapshotTestingUtils.createSnapshotAndValidate(this.admin, this.originalTableName, familiesWithDataList, emptyFamiliesList, snapshotNameAsString, rootDir, fs, false);
        this.admin.enableTable(this.originalTableName);
        if (changeMetadata) {
            String newFamilyNameAsString = "newFamily" + System.currentTimeMillis();
            byte[] newFamilyName = Bytes.toBytes(newFamilyNameAsString);
            this.admin.disableTable(this.originalTableName);
            HColumnDescriptor hcd = new HColumnDescriptor(newFamilyName);
            this.admin.addColumn(this.originalTableName, hcd);
            Assert.assertTrue((String)"New column family was not added.", (boolean)this.admin.getTableDescriptor(this.originalTableName).toString().contains(newFamilyNameAsString));
        }
        if (!this.admin.isTableDisabled(this.originalTableName)) {
            this.admin.disableTable(this.originalTableName);
        }
        this.admin.restoreSnapshot(snapshotName);
        this.admin.enableTable(this.originalTableName);
        HTable original = new HTable(UTIL.getConfiguration(), this.originalTableName);
        try {
            Assert.assertTrue((boolean)this.originalTableDescriptor.equals(this.admin.getTableDescriptor(this.originalTableName)));
            Assert.assertTrue((boolean)this.originalTableDescriptor.equals(original.getTableDescriptor()));
        }
        finally {
            original.close();
        }
    }
}

