/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.HBaseZeroCopyByteString;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class BigDecimalColumnInterpreter
extends ColumnInterpreter<BigDecimal, BigDecimal, HBaseProtos.EmptyMsg, HBaseProtos.BigDecimalMsg, HBaseProtos.BigDecimalMsg> {
    @Override
    public BigDecimal getValue(byte[] colFamily, byte[] colQualifier, Cell kv) throws IOException {
        if (kv == null || CellUtil.cloneValue(kv) == null) {
            return null;
        }
        return Bytes.toBigDecimal(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()).setScale(2, RoundingMode.HALF_EVEN);
    }

    @Override
    public BigDecimal add(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null ^ bd2 == null) {
            return bd1 == null ? bd2 : bd1;
        }
        if (bd1 == null) {
            return null;
        }
        return bd1.add(bd2);
    }

    @Override
    public int compare(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null ^ bd2 == null) {
            return bd1 == null ? -1 : 1;
        }
        if (bd1 == null) {
            return 0;
        }
        return bd1.compareTo(bd2);
    }

    @Override
    public BigDecimal getMaxValue() {
        return BigDecimal.valueOf(Double.MAX_VALUE);
    }

    @Override
    public BigDecimal increment(BigDecimal bd) {
        return bd == null ? null : bd.add(BigDecimal.ONE);
    }

    @Override
    public BigDecimal multiply(BigDecimal bd1, BigDecimal bd2) {
        return bd1 == null || bd2 == null ? null : bd1.multiply(bd2).setScale(2, RoundingMode.HALF_EVEN);
    }

    @Override
    public BigDecimal getMinValue() {
        return BigDecimal.valueOf(Double.MIN_VALUE);
    }

    @Override
    public double divideForAvg(BigDecimal bd1, Long l2) {
        return l2 == null || bd1 == null ? Double.NaN : bd1.doubleValue() / l2.doubleValue();
    }

    @Override
    public BigDecimal castToReturnType(BigDecimal bd) {
        return bd;
    }

    @Override
    public BigDecimal castToCellType(BigDecimal bd) {
        return bd;
    }

    @Override
    public HBaseProtos.EmptyMsg getRequestData() {
        return HBaseProtos.EmptyMsg.getDefaultInstance();
    }

    @Override
    public void initialize(HBaseProtos.EmptyMsg msg) {
    }

    private HBaseProtos.BigDecimalMsg getProtoForType(BigDecimal t) {
        HBaseProtos.BigDecimalMsg.Builder builder = HBaseProtos.BigDecimalMsg.newBuilder();
        return builder.setBigdecimalMsg(HBaseZeroCopyByteString.wrap(Bytes.toBytes(t))).build();
    }

    @Override
    public HBaseProtos.BigDecimalMsg getProtoForCellType(BigDecimal t) {
        return this.getProtoForType(t);
    }

    @Override
    public HBaseProtos.BigDecimalMsg getProtoForPromotedType(BigDecimal s) {
        return this.getProtoForType(s);
    }

    @Override
    public BigDecimal getPromotedValueFromProto(HBaseProtos.BigDecimalMsg r) {
        return Bytes.toBigDecimal(r.getBigdecimalMsg().toByteArray());
    }

    @Override
    public BigDecimal getCellValueFromProto(HBaseProtos.BigDecimalMsg q) {
        return Bytes.toBigDecimal(q.getBigdecimalMsg().toByteArray());
    }
}

