/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.constraint.AllFailConstraint;
import org.apache.hadoop.hbase.constraint.BaseConstraint;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.constraint.Constraints;
import org.apache.hadoop.hbase.constraint.RuntimeFailConstraint;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestConstraint {
    private static final Log LOG = LogFactory.getLog(TestConstraint.class);
    private static HBaseTestingUtility util;
    private static final byte[] tableName;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] test;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        util.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        util.startMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintPasses() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        for (byte[] family : new byte[][]{dummy, test}) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        Constraints.add(desc, CheckWasRunConstraint.class);
        util.getHBaseAdmin().createTable(desc);
        HTable table = new HTable(util.getConfiguration(), tableName);
        try {
            Put put = new Put(row1);
            byte[] value = Integer.toString(10).getBytes();
            put.add(dummy, new byte[0], value);
            table.put(put);
        }
        finally {
            table.close();
        }
        Assert.assertTrue((boolean)CheckWasRunConstraint.wasRun);
    }

    @Test(timeout=60000L)
    public void testConstraintFails() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        for (byte[] family : new byte[][]{dummy, test}) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        Constraints.add(desc, AllFailConstraint.class);
        util.getHBaseAdmin().createTable(desc);
        HTable table = new HTable(util.getConfiguration(), tableName);
        Put put = new Put(row1);
        put.add(dummy, new byte[0], "fail".getBytes());
        LOG.warn("Doing put in table");
        try {
            table.put(put);
            Assert.fail((String)"This put should not have suceeded - AllFailConstraint was not run!");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            List<Throwable> causes = e.getCauses();
            Assert.assertEquals((String)"More than one failure cause - should only be the failure constraint exception", (long)1L, (long)causes.size());
            Throwable t = causes.get(0);
            Assert.assertEquals(ConstraintException.class, t.getClass());
        }
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableConstraint() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        for (byte[] family : new byte[][]{dummy, test}) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        Constraints.add(desc, CheckWasRunConstraint.class);
        Constraints.add(desc, AllFailConstraint.class);
        Constraints.disableConstraint(desc, AllFailConstraint.class);
        util.getHBaseAdmin().createTable(desc);
        HTable table = new HTable(util.getConfiguration(), tableName);
        try {
            Put put = new Put(row1);
            put.add(dummy, new byte[0], "pass".getBytes());
            table.put(put);
        }
        finally {
            table.close();
        }
        Assert.assertTrue((boolean)CheckWasRunConstraint.wasRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableConstraints() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        for (byte[] family : new byte[][]{dummy, test}) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        Constraints.add(desc, CheckWasRunConstraint.class);
        Constraints.disable(desc);
        util.getHBaseAdmin().createTable(desc);
        HTable table = new HTable(util.getConfiguration(), tableName);
        try {
            Put put = new Put(row1);
            put.add(dummy, new byte[0], "pass".getBytes());
            LOG.warn("Doing put in table");
            table.put(put);
        }
        finally {
            table.close();
        }
        Assert.assertFalse((boolean)CheckWasRunConstraint.wasRun);
    }

    @Test
    public void testIsUnloaded() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        for (byte[] family : new byte[][]{dummy, test}) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        Constraints.add(desc, RuntimeFailConstraint.class);
        Constraints.add(desc, CheckWasRunConstraint.class);
        CheckWasRunConstraint.wasRun = false;
        util.getHBaseAdmin().createTable(desc);
        HTable table = new HTable(util.getConfiguration(), tableName);
        Put put = new Put(row1);
        put.add(dummy, new byte[0], "pass".getBytes());
        try {
            table.put(put);
            Assert.fail((String)"RuntimeFailConstraint wasn't triggered - this put shouldn't work!");
        }
        catch (Exception e) {
            // empty catch block
        }
        table.put(put);
        Assert.assertFalse((boolean)CheckWasRunConstraint.wasRun);
        table.close();
    }

    @After
    public void cleanup() throws Exception {
        CheckWasRunConstraint.wasRun = false;
        util.getHBaseAdmin().disableTable(tableName);
        util.getHBaseAdmin().deleteTable(tableName);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    static {
        tableName = Bytes.toBytes("test");
        dummy = Bytes.toBytes("dummy");
        row1 = Bytes.toBytes("r1");
        test = Bytes.toBytes("test");
    }

    public static class CheckWasRunConstraint
    extends BaseConstraint {
        public static boolean wasRun = false;

        @Override
        public void check(Put p) {
            wasRun = true;
        }
    }
}

