/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.constraint.AllPassConstraint;
import org.apache.hadoop.hbase.constraint.BaseConstraint;
import org.apache.hadoop.hbase.constraint.CheckConfigurationConstraint;
import org.apache.hadoop.hbase.constraint.Constraint;
import org.apache.hadoop.hbase.constraint.ConstraintProcessor;
import org.apache.hadoop.hbase.constraint.Constraints;
import org.apache.hadoop.hbase.constraint.TestConstraint;
import org.apache.hadoop.hbase.constraint.WorksConstraint;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestConstraints {
    @Test
    public void testSimpleReadWrite() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("table"));
        Constraints.add(desc, WorksConstraint.class);
        List<? extends Constraint> constraints = Constraints.getConstraints(desc, this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)constraints.size());
        Assert.assertEquals(WorksConstraint.class, constraints.get(0).getClass());
        Constraints.add(desc, AlsoWorks.class, WorksConstraint.NameConstraint.class);
        constraints = Constraints.getConstraints(desc, this.getClass().getClassLoader());
        Assert.assertEquals((long)3L, (long)constraints.size());
        Assert.assertEquals(WorksConstraint.class, constraints.get(0).getClass());
        Assert.assertEquals(AlsoWorks.class, constraints.get(1).getClass());
        Assert.assertEquals(WorksConstraint.NameConstraint.class, constraints.get(2).getClass());
    }

    @Test
    public void testReadWriteWithConf() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("table"));
        Constraints.add(desc, new Pair<Class<CheckConfigurationConstraint>, Configuration>(CheckConfigurationConstraint.class, CheckConfigurationConstraint.getConfiguration()));
        List<? extends Constraint> c = Constraints.getConstraints(desc, this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertEquals(CheckConfigurationConstraint.class, c.get(0).getClass());
        Constraints.add(desc, new Pair<Class<CheckConfigurationConstraint>, Configuration>(CheckConfigurationConstraint.class, new Configuration(false)));
        try {
            Constraints.getConstraints(desc, this.getClass().getClassLoader());
            Assert.fail((String)"No exception thrown  - configuration not overwritten");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEnableDisableRemove() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("table"));
        Constraints.add(desc, AllPassConstraint.class);
        Assert.assertTrue((boolean)Constraints.enabled(desc, AllPassConstraint.class));
        Assert.assertTrue((boolean)desc.hasCoprocessor(ConstraintProcessor.class.getName()));
        Constraints.disable(desc);
        Assert.assertFalse((boolean)desc.hasCoprocessor(ConstraintProcessor.class.getName()));
        Assert.assertTrue((boolean)Constraints.enabled(desc, AllPassConstraint.class));
        Constraints.remove(desc, AllPassConstraint.class);
        Assert.assertFalse((boolean)Constraints.has(desc, AllPassConstraint.class));
        Constraints.add(desc, AllPassConstraint.class);
        Constraints.remove(desc);
        Assert.assertFalse((boolean)desc.hasCoprocessor(ConstraintProcessor.class.getName()));
        Assert.assertFalse((boolean)Constraints.has(desc, AllPassConstraint.class));
    }

    @Test
    public void testUpdateConstraint() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("table"));
        Constraints.add(desc, CheckConfigurationConstraint.class, TestConstraint.CheckWasRunConstraint.class);
        Constraints.setConfiguration(desc, CheckConfigurationConstraint.class, CheckConfigurationConstraint.getConfiguration());
        List<? extends Constraint> constraints = Constraints.getConstraints(desc, this.getClass().getClassLoader());
        Assert.assertEquals((long)2L, (long)constraints.size());
        Assert.assertEquals(CheckConfigurationConstraint.class, constraints.get(0).getClass());
        Assert.assertEquals(TestConstraint.CheckWasRunConstraint.class, constraints.get(1).getClass());
    }

    @Test
    public void testRemoveUnsetConstraint() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("table"));
        Constraints.remove(desc);
        Constraints.remove(desc, AlsoWorks.class);
    }

    @Test
    public void testConfigurationPreserved() throws Throwable {
        Configuration conf = new Configuration();
        conf.setBoolean("_ENABLED", false);
        conf.setLong("_PRIORITY", 10L);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf("table"));
        Constraints.add(desc, AlsoWorks.class, conf);
        Constraints.add(desc, WorksConstraint.class);
        Assert.assertFalse((boolean)Constraints.enabled(desc, AlsoWorks.class));
        List<? extends Constraint> constraints = Constraints.getConstraints(desc, this.getClass().getClassLoader());
        for (Constraint constraint : constraints) {
            Configuration storedConf = constraint.getConf();
            if (constraint instanceof AlsoWorks) {
                Assert.assertEquals((long)10L, (long)storedConf.getLong("_PRIORITY", -1L));
                continue;
            }
            Assert.assertEquals((long)2L, (long)storedConf.getLong("_PRIORITY", -1L));
        }
    }

    public static class AlsoWorks
    extends BaseConstraint {
        @Override
        public void check(Put p) {
        }
    }
}

