/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestWALObserver {
    private static final Log LOG = LogFactory.getLog(TestWALObserver.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] TEST_TABLE = Bytes.toBytes("observedTable");
    private static byte[][] TEST_FAMILY = new byte[][]{Bytes.toBytes("fam1"), Bytes.toBytes("fam2"), Bytes.toBytes("fam3")};
    private static byte[][] TEST_QUALIFIER = new byte[][]{Bytes.toBytes("q1"), Bytes.toBytes("q2"), Bytes.toBytes("q3")};
    private static byte[][] TEST_VALUE = new byte[][]{Bytes.toBytes("v1"), Bytes.toBytes("v2"), Bytes.toBytes("v3")};
    private static byte[] TEST_ROW = Bytes.toBytes("testRow");
    private Configuration conf;
    private FileSystem fs;
    private Path dir;
    private Path hbaseRootDir;
    private String logName;
    private Path oldLogDir;
    private Path logDir;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.wal.classes", SampleRegionWALObserver.class.getName());
        conf.set("hbase.coprocessor.region.classes", SampleRegionWALObserver.class.getName());
        conf.setBoolean("dfs.support.append", true);
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(1);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOG.info("hbase.rootdir=" + hbaseRootDir);
        FSUtils.setRootDir(conf, hbaseRootDir);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create(TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir(this.conf);
        this.dir = new Path(this.hbaseRootDir, TestWALObserver.class.getName());
        this.oldLogDir = new Path(this.hbaseRootDir, "oldWALs");
        this.logDir = new Path(this.hbaseRootDir, "WALs");
        this.logName = "WALs";
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
    }

    @Test
    public void testWALObserverWriteToWAL() throws Exception {
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(Bytes.toString(TEST_TABLE));
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString(TEST_TABLE));
        Path basedir = new Path(this.hbaseRootDir, Bytes.toString(TEST_TABLE));
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        AtomicLong sequenceId = new AtomicLong(0L);
        HLog log = HLogFactory.createHLog(this.fs, this.hbaseRootDir, TestWALObserver.class.getName(), this.conf);
        SampleRegionWALObserver cp = this.getCoprocessor(log);
        cp.setTestValues(TEST_TABLE, TEST_ROW, TEST_FAMILY[0], TEST_QUALIFIER[0], TEST_FAMILY[1], TEST_QUALIFIER[1], TEST_FAMILY[2], TEST_QUALIFIER[2]);
        Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
        Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
        Put p = this.creatPutWith2Families(TEST_ROW);
        NavigableMap<byte[], List<Cell>> familyMap = p.getFamilyCellMap();
        WALEdit edit = new WALEdit();
        this.addFamilyMapToWALEdit(familyMap, edit);
        boolean foundFamily0 = false;
        boolean foundFamily2 = false;
        boolean modifiedFamily1 = false;
        ArrayList<KeyValue> kvs = edit.getKeyValues();
        for (KeyValue kv : kvs) {
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(kv.getFamily(), TEST_FAMILY[1]) || Arrays.equals(kv.getValue(), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertTrue((boolean)foundFamily0);
        Assert.assertFalse((boolean)foundFamily2);
        Assert.assertFalse((boolean)modifiedFamily1);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        log.append(hri, hri.getTable(), edit, now, htd, sequenceId);
        foundFamily0 = false;
        foundFamily2 = false;
        modifiedFamily1 = false;
        for (KeyValue kv : kvs) {
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(kv.getFamily(), TEST_FAMILY[1]) || Arrays.equals(kv.getValue(), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertFalse((boolean)foundFamily0);
        Assert.assertTrue((boolean)foundFamily2);
        Assert.assertTrue((boolean)modifiedFamily1);
        Assert.assertTrue((boolean)cp.isPreWALWriteCalled());
        Assert.assertTrue((boolean)cp.isPostWALWriteCalled());
    }

    @Test
    public void testWALCoprocessorReplay() throws Exception {
        TableName tableName = TableName.valueOf("testWALCoprocessorReplay");
        final HTableDescriptor htd = this.getBasic3FamilyHTableDescriptor(tableName);
        AtomicLong sequenceId = new AtomicLong(0L);
        final HRegionInfo hri = new HRegionInfo(tableName, null, null);
        Path basedir = FSUtils.getTableDir(this.hbaseRootDir, tableName);
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        final Configuration newConf = HBaseConfiguration.create(this.conf);
        HLog wal = this.createWAL(this.conf);
        WALEdit edit = new WALEdit();
        long now = EnvironmentEdgeManager.currentTimeMillis();
        int countPerFamily = 1000;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, TEST_ROW, hcd.getName(), 1000, EnvironmentEdgeManager.getDelegate(), wal, htd, sequenceId);
        }
        wal.append(hri, tableName, edit, now, htd, sequenceId);
        wal.sync();
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Path p = TestWALObserver.this.runWALSplit(newConf);
                LOG.info("WALSplit path == " + p);
                FileSystem newFS = FileSystem.get(newConf);
                HLog wal2 = TestWALObserver.this.createWAL(newConf);
                HRegion region = HRegion.openHRegion(newConf, FileSystem.get(newConf), TestWALObserver.this.hbaseRootDir, hri, htd, wal2, TEST_UTIL.getHBaseCluster().getRegionServer(0), null);
                long seqid2 = region.getOpenSeqNum();
                SampleRegionWALObserver cp2 = (SampleRegionWALObserver)region.getCoprocessorHost().findCoprocessor(SampleRegionWALObserver.class.getName());
                Assert.assertNotNull((Object)cp2);
                Assert.assertTrue((boolean)cp2.isPreWALRestoreCalled());
                Assert.assertTrue((boolean)cp2.isPostWALRestoreCalled());
                region.close();
                wal2.closeAndDelete();
                return null;
            }
        });
    }

    @Test
    public void testWALObserverLoaded() throws Exception {
        HLog log = HLogFactory.createHLog(this.fs, this.hbaseRootDir, TestWALObserver.class.getName(), this.conf);
        Assert.assertNotNull((Object)this.getCoprocessor(log));
    }

    private SampleRegionWALObserver getCoprocessor(HLog wal) throws Exception {
        WALCoprocessorHost host = wal.getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(SampleRegionWALObserver.class.getName());
        return (SampleRegionWALObserver)c;
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(tableName));
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return new HRegionInfo(htd.getTableName(), null, null, false);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    private Put creatPutWith2Families(byte[] row) throws IOException {
        Put p = new Put(row);
        for (int i = 0; i < TEST_FAMILY.length - 1; ++i) {
            p.add(TEST_FAMILY[i], TEST_QUALIFIER[i], TEST_VALUE[i]);
        }
        return p;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                walEdit.add((KeyValue)cell);
            }
        }
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List<Path> splits = HLogSplitter.split(this.hbaseRootDir, this.logDir, this.oldLogDir, FileSystem.get(c), c);
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists(splits.get(0)));
        LOG.info("Split file=" + splits.get(0));
        return splits.get(0);
    }

    private HLog createWAL(Configuration c) throws IOException {
        return HLogFactory.createHLog(FileSystem.get(c), this.hbaseRootDir, this.logName, c);
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, HLog wal, HTableDescriptor htd, AtomicLong sequenceId) throws IOException {
        String familyStr = Bytes.toString(family);
        for (int j = 0; j < count; ++j) {
            byte[] qualifierBytes = Bytes.toBytes(Integer.toString(j));
            byte[] columnBytes = Bytes.toBytes(familyStr + ":" + Integer.toString(j));
            WALEdit edit = new WALEdit();
            edit.add(new KeyValue(rowName, family, qualifierBytes, ee.currentTimeMillis(), columnBytes));
            wal.append(hri, tableName, edit, ee.currentTimeMillis(), htd, sequenceId);
        }
    }

    private HTableDescriptor getBasic3FamilyHTableDescriptor(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return htd;
    }

    private HTableDescriptor createBasic3FamilyHTD(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(tableName));
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes("a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes("b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes("c"));
        htd.addFamily(c);
        return htd;
    }
}

