/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FuzzyRowFilter
extends FilterBase {
    private List<Pair<byte[], byte[]>> fuzzyKeysData;
    private boolean done = false;

    public FuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        this.fuzzyKeysData = fuzzyKeysData;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell kv) {
        KeyValue v = KeyValueUtil.ensureKeyValue(kv);
        byte[] rowKey = v.getRow();
        SatisfiesCode bestOption = SatisfiesCode.NO_NEXT;
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            SatisfiesCode satisfiesCode = FuzzyRowFilter.satisfies(rowKey, fuzzyData.getFirst(), fuzzyData.getSecond());
            if (satisfiesCode == SatisfiesCode.YES) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (satisfiesCode != SatisfiesCode.NEXT_EXISTS) continue;
            bestOption = SatisfiesCode.NEXT_EXISTS;
        }
        if (bestOption == SatisfiesCode.NEXT_EXISTS) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.done = true;
        return Filter.ReturnCode.NEXT_ROW;
    }

    @Override
    public Cell getNextCellHint(Cell currentKV) {
        KeyValue v = KeyValueUtil.ensureKeyValue(currentKV);
        byte[] rowKey = v.getRow();
        byte[] nextRowKey = null;
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            byte[] nextRowKeyCandidate = FuzzyRowFilter.getNextForFuzzyRule(rowKey, fuzzyData.getFirst(), fuzzyData.getSecond());
            if (nextRowKeyCandidate == null || nextRowKey != null && Bytes.compareTo(nextRowKeyCandidate, nextRowKey) >= 0) continue;
            nextRowKey = nextRowKeyCandidate;
        }
        if (nextRowKey == null) {
            throw new IllegalStateException("No next row key that satisfies fuzzy exists when getNextKeyHint() is invoked. Filter: " + this.toString() + " currentKV: " + currentKV.toString());
        }
        return KeyValue.createFirstOnRow(nextRowKey);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FuzzyRowFilter.Builder builder = FilterProtos.FuzzyRowFilter.newBuilder();
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            bbpBuilder.setFirst(HBaseZeroCopyByteString.wrap(fuzzyData.getFirst()));
            bbpBuilder.setSecond(HBaseZeroCopyByteString.wrap(fuzzyData.getSecond()));
            builder.addFuzzyKeysData(bbpBuilder);
        }
        return builder.build().toByteArray();
    }

    public static FuzzyRowFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FuzzyRowFilter proto;
        try {
            proto = FilterProtos.FuzzyRowFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int count = proto.getFuzzyKeysDataCount();
        ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
        for (int i = 0; i < count; ++i) {
            HBaseProtos.BytesBytesPair current = proto.getFuzzyKeysData(i);
            byte[] keyBytes = current.getFirst().toByteArray();
            byte[] keyMeta = current.getSecond().toByteArray();
            fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
        }
        return new FuzzyRowFilter(fuzzyKeysData);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FuzzyRowFilter");
        sb.append("{fuzzyKeysData=");
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            sb.append('{').append(Bytes.toStringBinary(fuzzyData.getFirst())).append(":");
            sb.append(Bytes.toStringBinary(fuzzyData.getSecond())).append('}');
        }
        sb.append("}, ");
        return sb.toString();
    }

    static SatisfiesCode satisfies(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.satisfies(row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    private static SatisfiesCode satisfies(byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        if (row == null) {
            return SatisfiesCode.YES;
        }
        boolean nextRowKeyCandidateExists = false;
        for (int i = 0; i < fuzzyKeyMeta.length && i < length; ++i) {
            boolean fixedByteIncorrect;
            boolean byteAtPositionFixed = fuzzyKeyMeta[i] == 0;
            boolean bl = fixedByteIncorrect = byteAtPositionFixed && fuzzyKeyBytes[i] != row[i + offset];
            if (fixedByteIncorrect) {
                if (nextRowKeyCandidateExists) {
                    return SatisfiesCode.NEXT_EXISTS;
                }
                boolean rowByteLessThanFixed = (row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF);
                return rowByteLessThanFixed ? SatisfiesCode.NEXT_EXISTS : SatisfiesCode.NO_NEXT;
            }
            if (fuzzyKeyMeta[i] != 1 || FuzzyRowFilter.isMax(fuzzyKeyBytes[i])) continue;
            nextRowKeyCandidateExists = true;
        }
        return SatisfiesCode.YES;
    }

    private static boolean isMax(byte fuzzyKeyByte) {
        return (fuzzyKeyByte & 0xFF) == 255;
    }

    static byte[] getNextForFuzzyRule(byte[] row, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        return FuzzyRowFilter.getNextForFuzzyRule(row, 0, row.length, fuzzyKeyBytes, fuzzyKeyMeta);
    }

    private static byte[] getNextForFuzzyRule(byte[] row, int offset, int length, byte[] fuzzyKeyBytes, byte[] fuzzyKeyMeta) {
        int i;
        byte[] result = Arrays.copyOf(fuzzyKeyBytes, length > fuzzyKeyBytes.length ? length : fuzzyKeyBytes.length);
        int toInc = -1;
        boolean increased = false;
        for (i = 0; i < result.length; ++i) {
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] == 1) {
                result[i] = row[offset + i];
                if (FuzzyRowFilter.isMax(row[i])) continue;
                toInc = i;
                continue;
            }
            if (i >= fuzzyKeyMeta.length || fuzzyKeyMeta[i] != 0) continue;
            if ((row[i + offset] & 0xFF) < (fuzzyKeyBytes[i] & 0xFF)) {
                increased = true;
                break;
            }
            if ((row[i + offset] & 0xFF) > (fuzzyKeyBytes[i] & 0xFF)) break;
        }
        if (!increased) {
            if (toInc < 0) {
                return null;
            }
            int n = toInc;
            result[n] = (byte)(result[n] + 1);
            for (i = toInc + 1; i < result.length; ++i) {
                if (i < fuzzyKeyMeta.length && fuzzyKeyMeta[i] != 1) continue;
                result[i] = 0;
            }
        }
        return result;
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzyRowFilter)) {
            return false;
        }
        FuzzyRowFilter other = (FuzzyRowFilter)o;
        if (this.fuzzyKeysData.size() != other.fuzzyKeysData.size()) {
            return false;
        }
        for (int i = 0; i < this.fuzzyKeysData.size(); ++i) {
            Pair<byte[], byte[]> thisData = this.fuzzyKeysData.get(i);
            Pair<byte[], byte[]> otherData = other.fuzzyKeysData.get(i);
            if (Bytes.equals(thisData.getFirst(), otherData.getFirst()) && Bytes.equals(thisData.getSecond(), otherData.getSecond())) continue;
            return false;
        }
        return true;
    }

    static enum SatisfiesCode {
        YES,
        NEXT_EXISTS,
        NO_NEXT;

    }
}

