/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SkipFilter
extends FilterBase {
    private boolean filterRow = false;
    private Filter filter;

    public SkipFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void reset() throws IOException {
        this.filter.reset();
        this.filterRow = false;
    }

    private void changeFR(boolean value) {
        this.filterRow = this.filterRow || value;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        Filter.ReturnCode c = this.filter.filterKeyValue(v);
        this.changeFR(c != Filter.ReturnCode.INCLUDE);
        return c;
    }

    @Override
    public Cell transformCell(Cell v) throws IOException {
        return this.filter.transformCell(v);
    }

    @Override
    public boolean filterRow() {
        return this.filterRow;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.SkipFilter.Builder builder = FilterProtos.SkipFilter.newBuilder();
        builder.setFilter(ProtobufUtil.toFilter(this.filter));
        return builder.build().toByteArray();
    }

    public static SkipFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.SkipFilter proto;
        try {
            proto = FilterProtos.SkipFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        try {
            return new SkipFilter(ProtobufUtil.toFilter(proto.getFilter()));
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkipFilter)) {
            return false;
        }
        SkipFilter other = (SkipFilter)o;
        return this.getFilter().areSerializedFieldsEqual(other.getFilter());
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        return this.filter.isFamilyEssential(name);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.filter.toString();
    }
}

