/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnPaginationFilter {
    private static final byte[] ROW = Bytes.toBytes("row_1_test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes("test");
    private static final byte[] VAL_1 = Bytes.toBytes("a");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes("foo");
    private Filter columnPaginationFilterOffset;
    private Filter columnPaginationFilter;

    @Before
    public void setUp() throws Exception {
        this.columnPaginationFilter = this.getColumnPaginationFilter();
        this.columnPaginationFilterOffset = this.getColumnPaginationFilterOffset();
    }

    private Filter getColumnPaginationFilter() {
        return new ColumnPaginationFilter(1, 0);
    }

    private Filter getColumnPaginationFilterOffset() {
        return new ColumnPaginationFilter(1, COLUMN_QUALIFIER);
    }

    private Filter serializationTest(Filter filter) throws Exception {
        FilterProtos.Filter filterProto = ProtobufUtil.toFilter(filter);
        Filter newFilter = ProtobufUtil.toFilter(filterProto);
        return newFilter;
    }

    private void basicFilterTests(ColumnPaginationFilter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        Assert.assertTrue((String)"basicFilter1", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE_AND_NEXT_COL ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() throws Exception {
        Filter newFilter = this.serializationTest(this.columnPaginationFilter);
        this.basicFilterTests((ColumnPaginationFilter)newFilter);
        Filter newFilterOffset = this.serializationTest(this.columnPaginationFilterOffset);
        this.basicFilterTests((ColumnPaginationFilter)newFilterOffset);
    }
}

