/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFilterList {
    static final int MAX_PAGES = 2;
    static final char FIRST_CHAR = 'a';
    static final char LAST_CHAR = 'e';
    static byte[] GOOD_BYTES = Bytes.toBytes("abc");
    static byte[] BAD_BYTES = Bytes.toBytes("def");

    @Test
    public void testAddFilter() throws Exception {
        FirstKeyOnlyFilter filter1 = new FirstKeyOnlyFilter();
        FirstKeyOnlyFilter filter2 = new FirstKeyOnlyFilter();
        FilterList filterList = new FilterList(filter1, filter2);
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList = new FilterList(Arrays.asList(filter1, filter2));
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, filter1, filter2);
        filterList.addFilter(new FirstKeyOnlyFilter());
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filter1, filter2));
        filterList.addFilter(new FirstKeyOnlyFilter());
    }

    @Test
    public void testMPONE() throws Exception {
        this.mpOneTest(this.getFilterMPONE());
    }

    private Filter getFilterMPONE() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter(new PrefixFilter(Bytes.toBytes("yyy"))));
        FilterList filterMPONE = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        return filterMPONE;
    }

    private void mpOneTest(Filter filterMPONE) throws Exception {
        filterMPONE.reset();
        Assert.assertFalse((boolean)filterMPONE.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes("yyyyyyyyy");
        for (int i = 0; i < 1; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes("z");
        Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(0), Bytes.toBytes(0));
        Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)filterMPONE.filterRow());
        rowkey = Bytes.toBytes("yyy");
        Assert.assertTrue((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(0), Bytes.toBytes(0));
        Assert.assertFalse((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)filterMPONE.filterRow());
        rowkey = Bytes.toBytes("z");
        Assert.assertTrue((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        Assert.assertTrue((boolean)filterMPONE.filterAllRemaining());
    }

    @Test
    public void testMPALL() throws Exception {
        this.mpAllTest(this.getMPALLFilter());
    }

    private Filter getMPALLFilter() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter(new PrefixFilter(Bytes.toBytes("yyy"))));
        FilterList filterMPALL = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        return filterMPALL;
    }

    private void mpAllTest(Filter filterMPALL) throws Exception {
        filterMPALL.reset();
        Assert.assertFalse((boolean)filterMPALL.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes("yyyyyyyyy");
        for (int i = 0; i < 1; ++i) {
            Assert.assertFalse((boolean)filterMPALL.filterRowKey(rowkey, 0, rowkey.length));
            KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPALL.filterKeyValue(kv) ? 1 : 0) != 0);
        }
        filterMPALL.reset();
        rowkey = Bytes.toBytes("z");
        Assert.assertTrue((boolean)filterMPALL.filterRowKey(rowkey, 0, rowkey.length));
        KeyValue kv = new KeyValue(rowkey, rowkey, rowkey, rowkey);
        Assert.assertTrue((Filter.ReturnCode.NEXT_ROW == filterMPALL.filterKeyValue(kv) ? 1 : 0) != 0);
    }

    @Test
    public void testOrdering() throws Exception {
        this.orderingTest(this.getOrderingFilter());
    }

    public Filter getOrderingFilter() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PrefixFilter(Bytes.toBytes("yyy")));
        filters.add(new PageFilter(2L));
        FilterList filterMPONE = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        return filterMPONE;
    }

    public void orderingTest(Filter filterMPONE) throws Exception {
        KeyValue kv;
        int i;
        filterMPONE.reset();
        Assert.assertFalse((boolean)filterMPONE.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes("yyyyyyyy");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes("xxxxxxx");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes("yyy");
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes(i), Bytes.toBytes(i));
            Assert.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)filterMPONE.filterRow());
        }
    }

    public void testFilterListTwoFiltersMustPassOne() throws Exception {
        byte[] r1 = Bytes.toBytes("Row1");
        byte[] r11 = Bytes.toBytes("Row11");
        byte[] r2 = Bytes.toBytes("Row2");
        FilterList flist = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        flist.addFilter(new PrefixFilter(r1));
        flist.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r1, r1, r1))), (Object)((Object)Filter.ReturnCode.INCLUDE));
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r11, r11, r11))), (Object)((Object)Filter.ReturnCode.INCLUDE));
        flist.reset();
        flist.filterRowKey(r2, 0, r2.length);
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r2, r2, r2))), (Object)((Object)Filter.ReturnCode.SKIP));
        flist = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        flist.addFilter(new AlwaysNextColFilter());
        flist.addFilter(new PrefixFilter(r1));
        flist.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r1, r1, r1))), (Object)((Object)Filter.ReturnCode.INCLUDE));
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r11, r11, r11))), (Object)((Object)Filter.ReturnCode.INCLUDE));
        flist.reset();
        flist.filterRowKey(r2, 0, r2.length);
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r2, r2, r2))), (Object)((Object)Filter.ReturnCode.SKIP));
    }

    public void testFilterListWithInclusiveStopFilteMustPassOne() throws Exception {
        byte[] r1 = Bytes.toBytes("Row1");
        byte[] r11 = Bytes.toBytes("Row11");
        byte[] r2 = Bytes.toBytes("Row2");
        FilterList flist = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        flist.addFilter(new AlwaysNextColFilter());
        flist.addFilter(new InclusiveStopFilter(r1));
        flist.filterRowKey(r1, 0, r1.length);
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r1, r1, r1))), (Object)((Object)Filter.ReturnCode.INCLUDE));
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r11, r11, r11))), (Object)((Object)Filter.ReturnCode.INCLUDE));
        flist.reset();
        flist.filterRowKey(r2, 0, r2.length);
        Assert.assertEquals((Object)((Object)flist.filterKeyValue(new KeyValue(r2, r2, r2))), (Object)((Object)Filter.ReturnCode.SKIP));
    }

    @Test
    public void testSerialization() throws Exception {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter(new PrefixFilter(Bytes.toBytes("yyy"))));
        FilterList filterMPALL = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        byte[] buffer = ((Filter)filterMPALL).toByteArray();
        FilterList newFilter = FilterList.parseFrom(buffer);
        this.mpOneTest(ProtobufUtil.toFilter(ProtobufUtil.toFilter(this.getFilterMPONE())));
        this.mpAllTest(ProtobufUtil.toFilter(ProtobufUtil.toFilter(this.getMPALLFilter())));
        this.orderingTest(ProtobufUtil.toFilter(ProtobufUtil.toFilter(this.getOrderingFilter())));
    }

    public void testFilterKeyValue() throws Exception {
        FilterBase includeFilter = new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) {
                return Filter.ReturnCode.INCLUDE;
            }
        };
        FilterBase alternateFilter = new FilterBase(){
            boolean returnInclude = true;

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) {
                Filter.ReturnCode returnCode = this.returnInclude ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
                this.returnInclude = !this.returnInclude;
                return returnCode;
            }
        };
        FilterBase alternateIncludeFilter = new FilterBase(){
            boolean returnIncludeOnly = false;

            @Override
            public Filter.ReturnCode filterKeyValue(Cell v) {
                Filter.ReturnCode returnCode = this.returnIncludeOnly ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                this.returnIncludeOnly = !this.returnIncludeOnly;
                return returnCode;
            }
        };
        FilterList mpOnefilterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(includeFilter, alternateIncludeFilter, alternateFilter));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)mpOnefilterList.filterKeyValue(null)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)mpOnefilterList.filterKeyValue(null)));
        FilterList mpAllfilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(includeFilter, alternateIncludeFilter, alternateFilter));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL), (Object)((Object)mpAllfilterList.filterKeyValue(null)));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)mpAllfilterList.filterKeyValue(null)));
    }

    @Test
    public void testHintPassThru() throws Exception {
        final KeyValue minKeyValue = new KeyValue(Bytes.toBytes(0L), null, null);
        KeyValue maxKeyValue = new KeyValue(Bytes.toBytes(Long.MAX_VALUE), null, null);
        FilterBase filterNoHint = new FilterBase(){

            @Override
            public byte[] toByteArray() {
                return null;
            }
        };
        FilterBase filterMinHint = new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell ignored) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }

            @Override
            public Cell getNextCellHint(Cell currentKV) {
                return minKeyValue;
            }

            @Override
            public byte[] toByteArray() {
                return null;
            }
        };
        FilterBase filterMaxHint = new FilterBase(){

            @Override
            public Filter.ReturnCode filterKeyValue(Cell ignored) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }

            @Override
            public Cell getNextCellHint(Cell currentKV) {
                return new KeyValue(Bytes.toBytes(Long.MAX_VALUE), null, null);
            }

            @Override
            public byte[] toByteArray() {
                return null;
            }
        };
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMinHint, filterMaxHint));
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMinHint, filterMaxHint, filterNoHint));
        Assert.assertNull((Object)filterList.getNextKeyHint(null));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterNoHint, filterMaxHint));
        Assert.assertNull((Object)filterList.getNextKeyHint(null));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMaxHint, filterMaxHint));
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterMinHint, filterMaxHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterMaxHint, filterMinHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMinHint, filterMaxHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMaxHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMinHint));
        filterList.filterKeyValue(null);
        Assert.assertEquals((long)0L, (long)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
    }

    @Test
    public void testTransformMPO() throws Exception {
        FilterList flist = new FilterList(FilterList.Operator.MUST_PASS_ONE, Lists.newArrayList(new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(new FamilyFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("fam"))), new QualifierFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("qual1"))), new KeyOnlyFilter())), new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(new FamilyFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("fam"))), new QualifierFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("qual2")))))));
        KeyValue kvQual1 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual1"), Bytes.toBytes("value"));
        KeyValue kvQual2 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual2"), Bytes.toBytes("value"));
        KeyValue kvQual3 = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("fam"), Bytes.toBytes("qual3"), Bytes.toBytes("value"));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(kvQual1)));
        KeyValue transformedQual1 = KeyValueUtil.ensureKeyValue(flist.transform(kvQual1));
        Assert.assertEquals((long)0L, (long)transformedQual1.getValue().length);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)flist.filterKeyValue(kvQual2)));
        KeyValue transformedQual2 = KeyValueUtil.ensureKeyValue(flist.transform(kvQual2));
        Assert.assertEquals((Object)"value", (Object)Bytes.toString(transformedQual2.getValue()));
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SKIP), (Object)((Object)flist.filterKeyValue(kvQual3)));
    }

    public static class AlwaysNextColFilter
    extends FilterBase {
        @Override
        public Filter.ReturnCode filterKeyValue(Cell v) {
            return Filter.ReturnCode.NEXT_COL;
        }

        public static AlwaysNextColFilter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new AlwaysNextColFilter();
        }
    }
}

