/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FilterWrapper;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFilterSerialization {
    @Test
    public void testColumnCountGetFilter() throws Exception {
        ColumnCountGetFilter columnCountGetFilter = new ColumnCountGetFilter(1);
        Assert.assertTrue((boolean)columnCountGetFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(columnCountGetFilter))));
    }

    @Test
    public void testColumnPaginationFilter() throws Exception {
        ColumnPaginationFilter columnPaginationFilter = new ColumnPaginationFilter(1, 7);
        Assert.assertTrue((boolean)columnPaginationFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(columnPaginationFilter))));
    }

    @Test
    public void testColumnPrefixFilter() throws Exception {
        ColumnPrefixFilter columnPrefixFilter = new ColumnPrefixFilter(Bytes.toBytes(""));
        Assert.assertTrue((boolean)columnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(columnPrefixFilter))));
        columnPrefixFilter = new ColumnPrefixFilter(Bytes.toBytes(""));
        Assert.assertTrue((boolean)columnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(columnPrefixFilter))));
    }

    @Test
    public void testColumnRangeFilter() throws Exception {
        ColumnRangeFilter columnRangeFilter = new ColumnRangeFilter(null, true, null, false);
        Assert.assertTrue((boolean)columnRangeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(columnRangeFilter))));
        columnRangeFilter = new ColumnRangeFilter(Bytes.toBytes("a"), false, Bytes.toBytes("b"), true);
        Assert.assertTrue((boolean)columnRangeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(columnRangeFilter))));
    }

    @Test
    public void testDependentColumnFilter() throws Exception {
        DependentColumnFilter dependentColumnFilter = new DependentColumnFilter(null, null);
        Assert.assertTrue((boolean)dependentColumnFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(dependentColumnFilter))));
        dependentColumnFilter = new DependentColumnFilter(Bytes.toBytes("family"), Bytes.toBytes("qual"), true, CompareFilter.CompareOp.GREATER_OR_EQUAL, new BitComparator(Bytes.toBytes("bitComparator"), BitComparator.BitwiseOp.OR));
        Assert.assertTrue((boolean)dependentColumnFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(dependentColumnFilter))));
    }

    @Test
    public void testFamilyFilter() throws Exception {
        FamilyFilter familyFilter = new FamilyFilter(CompareFilter.CompareOp.EQUAL, new BinaryPrefixComparator(Bytes.toBytes("testValueOne")));
        Assert.assertTrue((boolean)familyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(familyFilter))));
    }

    @Test
    public void testFilterList() throws Exception {
        FilterList filterList = new FilterList(new LinkedList<Filter>());
        Assert.assertTrue((boolean)filterList.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(filterList))));
        LinkedList<FilterBase> list = new LinkedList<FilterBase>();
        list.add(new ColumnCountGetFilter(1));
        list.add(new RowFilter(CompareFilter.CompareOp.EQUAL, new SubstringComparator("testFilterList")));
        Assert.assertTrue((boolean)filterList.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(filterList))));
    }

    @Test
    public void testFilterWrapper() throws Exception {
        FilterWrapper filterWrapper = new FilterWrapper(new ColumnRangeFilter(Bytes.toBytes("e"), false, Bytes.toBytes("f"), true));
        Assert.assertTrue((boolean)filterWrapper.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(filterWrapper))));
    }

    @Test
    public void testFirstKeyValueMatchingQualifiersFilter() throws Exception {
        TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        FirstKeyValueMatchingQualifiersFilter firstKeyValueMatchingQualifiersFilter = new FirstKeyValueMatchingQualifiersFilter(set);
        Assert.assertTrue((boolean)firstKeyValueMatchingQualifiersFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(firstKeyValueMatchingQualifiersFilter))));
        set.add(Bytes.toBytes("col0"));
        set.add(Bytes.toBytes("col1"));
        firstKeyValueMatchingQualifiersFilter = new FirstKeyValueMatchingQualifiersFilter(set);
        Assert.assertTrue((boolean)firstKeyValueMatchingQualifiersFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(firstKeyValueMatchingQualifiersFilter))));
    }

    @Test
    public void testFirstKeyOnlyFilter() throws Exception {
        FirstKeyOnlyFilter firstKeyOnlyFilter = new FirstKeyOnlyFilter();
        Assert.assertTrue((boolean)firstKeyOnlyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(firstKeyOnlyFilter))));
    }

    @Test
    public void testFuzzyRowFilter() throws Exception {
        LinkedList<Pair<byte[], byte[]>> fuzzyList = new LinkedList<Pair<byte[], byte[]>>();
        fuzzyList.add(new Pair<byte[], byte[]>(Bytes.toBytes("999"), new byte[]{0, 0, 1}));
        fuzzyList.add(new Pair<byte[], byte[]>(Bytes.toBytes("abcd"), new byte[]{1, 0, 1, 1}));
        FuzzyRowFilter fuzzyRowFilter = new FuzzyRowFilter(fuzzyList);
        Assert.assertTrue((boolean)fuzzyRowFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(fuzzyRowFilter))));
    }

    @Test
    public void testInclusiveStopFilter() throws Exception {
        InclusiveStopFilter inclusiveStopFilter = new InclusiveStopFilter(null);
        Assert.assertTrue((boolean)inclusiveStopFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(inclusiveStopFilter))));
        inclusiveStopFilter = new InclusiveStopFilter(Bytes.toBytes("inclusiveStopFilter"));
        Assert.assertTrue((boolean)inclusiveStopFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(inclusiveStopFilter))));
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        KeyOnlyFilter keyOnlyFilter = new KeyOnlyFilter(true);
        Assert.assertTrue((boolean)keyOnlyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(keyOnlyFilter))));
        keyOnlyFilter = new KeyOnlyFilter();
        Assert.assertTrue((boolean)keyOnlyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(keyOnlyFilter))));
    }

    @Test
    public void testMultipleColumnPrefixFilter() throws Exception {
        Object prefixes = null;
        MultipleColumnPrefixFilter multipleColumnPrefixFilter = new MultipleColumnPrefixFilter((byte[][])prefixes);
        Assert.assertTrue((boolean)multipleColumnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(multipleColumnPrefixFilter))));
        prefixes = new byte[2][];
        prefixes[0] = Bytes.toBytes("a");
        prefixes[1] = Bytes.toBytes("");
        multipleColumnPrefixFilter = new MultipleColumnPrefixFilter((byte[][])prefixes);
        Assert.assertTrue((boolean)multipleColumnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(multipleColumnPrefixFilter))));
    }

    @Test
    public void testPageFilter() throws Exception {
        PageFilter pageFilter = new PageFilter(6L);
        Assert.assertTrue((boolean)pageFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(pageFilter))));
    }

    @Test
    public void testPrefixFilter() throws Exception {
        PrefixFilter prefixFilter = new PrefixFilter(null);
        Assert.assertTrue((boolean)prefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(prefixFilter))));
        prefixFilter = new PrefixFilter(Bytes.toBytes("abc"));
        Assert.assertTrue((boolean)prefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(prefixFilter))));
    }

    @Test
    public void testQualifierFilter() throws Exception {
        QualifierFilter qualifierFilter = new QualifierFilter(CompareFilter.CompareOp.EQUAL, new NullComparator());
        Assert.assertTrue((boolean)qualifierFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(qualifierFilter))));
    }

    @Test
    public void testRandomRowFilter() throws Exception {
        RandomRowFilter randomRowFilter = new RandomRowFilter(0.1f);
        Assert.assertTrue((boolean)randomRowFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(randomRowFilter))));
    }

    @Test
    public void testRowFilter() throws Exception {
        RowFilter rowFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, new SubstringComparator("testRowFilter"));
        Assert.assertTrue((boolean)rowFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(rowFilter))));
    }

    @Test
    public void testSingleColumnValueExcludeFilter() throws Exception {
        SingleColumnValueExcludeFilter singleColumnValueExcludeFilter = new SingleColumnValueExcludeFilter(null, null, CompareFilter.CompareOp.GREATER_OR_EQUAL, Bytes.toBytes("value"));
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(singleColumnValueExcludeFilter))));
        singleColumnValueExcludeFilter = new SingleColumnValueExcludeFilter(Bytes.toBytes("fam"), Bytes.toBytes("qual"), CompareFilter.CompareOp.LESS_OR_EQUAL, new NullComparator(), false, false);
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(singleColumnValueExcludeFilter))));
    }

    @Test
    public void testSingleColumnValueFilter() throws Exception {
        SingleColumnValueFilter singleColumnValueFilter = new SingleColumnValueFilter(null, null, CompareFilter.CompareOp.LESS, Bytes.toBytes("value"));
        Assert.assertTrue((boolean)singleColumnValueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(singleColumnValueFilter))));
        singleColumnValueFilter = new SingleColumnValueFilter(Bytes.toBytes("family"), Bytes.toBytes("qualifier"), CompareFilter.CompareOp.NOT_EQUAL, new NullComparator(), true, true);
        Assert.assertTrue((boolean)singleColumnValueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(singleColumnValueFilter))));
    }

    @Test
    public void testSkipFilter() throws Exception {
        SkipFilter skipFilter = new SkipFilter(new PageFilter(6L));
        Assert.assertTrue((boolean)skipFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(skipFilter))));
    }

    @Test
    public void testTimestampsFilter() throws Exception {
        TimestampsFilter timestampsFilter = new TimestampsFilter(new LinkedList<Long>());
        Assert.assertTrue((boolean)timestampsFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(timestampsFilter))));
        LinkedList<Long> list = new LinkedList<Long>();
        list.add(new Long(System.currentTimeMillis()));
        list.add(new Long(System.currentTimeMillis()));
        timestampsFilter = new TimestampsFilter(list);
        Assert.assertTrue((boolean)timestampsFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(timestampsFilter))));
    }

    @Test
    public void testValueFilter() throws Exception {
        ValueFilter valueFilter = new ValueFilter(CompareFilter.CompareOp.NO_OP, new BinaryComparator(Bytes.toBytes("testValueOne")));
        Assert.assertTrue((boolean)valueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(valueFilter))));
    }

    @Test
    public void testWhileMatchFilter() throws Exception {
        WhileMatchFilter whileMatchFilter = new WhileMatchFilter(new ColumnRangeFilter(Bytes.toBytes("c"), false, Bytes.toBytes("d"), true));
        Assert.assertTrue((boolean)whileMatchFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter(ProtobufUtil.toFilter(whileMatchFilter))));
    }
}

