/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestInvocationRecordFilter {
    private static final byte[] TABLE_NAME_BYTES = Bytes.toBytes("invocationrecord");
    private static final byte[] FAMILY_NAME_BYTES = Bytes.toBytes("mycf");
    private static final byte[] ROW_BYTES = Bytes.toBytes("row");
    private static final String QUALIFIER_PREFIX = "qualifier";
    private static final String VALUE_PREFIX = "value";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HRegion region;

    @Before
    public void setUp() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(TABLE_NAME_BYTES));
        htd.addFamily(new HColumnDescriptor(FAMILY_NAME_BYTES));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = HRegion.createHRegion(info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), htd);
        Put put = new Put(ROW_BYTES);
        for (int i = 0; i < 10; i += 2) {
            put.add(FAMILY_NAME_BYTES, Bytes.toBytes(QUALIFIER_PREFIX + i), (long)i, Bytes.toBytes(VALUE_PREFIX + i));
        }
        this.region.put(put);
        this.region.flushcache();
    }

    @Test
    public void testFilterInvocation() throws Exception {
        ArrayList<Integer> selectQualifiers = new ArrayList<Integer>();
        ArrayList<Integer> expectedQualifiers = new ArrayList<Integer>();
        selectQualifiers.add(-1);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[0]), expectedQualifiers.toArray(new Integer[0]));
        selectQualifiers.clear();
        selectQualifiers.add(0);
        expectedQualifiers.add(0);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[0]), expectedQualifiers.toArray(new Integer[0]));
        selectQualifiers.add(3);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[0]), expectedQualifiers.toArray(new Integer[0]));
        selectQualifiers.add(4);
        expectedQualifiers.add(4);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[0]), expectedQualifiers.toArray(new Integer[0]));
        selectQualifiers.add(5);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[0]), expectedQualifiers.toArray(new Integer[0]));
        selectQualifiers.add(8);
        expectedQualifiers.add(8);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[0]), expectedQualifiers.toArray(new Integer[0]));
    }

    public void verifyInvocationResults(Integer[] selectQualifiers, Integer[] expectedQualifiers) throws Exception {
        Get get = new Get(ROW_BYTES);
        for (int i = 0; i < selectQualifiers.length; ++i) {
            get.addColumn(FAMILY_NAME_BYTES, Bytes.toBytes(QUALIFIER_PREFIX + selectQualifiers[i]));
        }
        get.setFilter(new InvocationRecordFilter());
        ArrayList<KeyValue> expectedValues = new ArrayList<KeyValue>();
        for (int i = 0; i < expectedQualifiers.length; ++i) {
            expectedValues.add(new KeyValue(ROW_BYTES, FAMILY_NAME_BYTES, Bytes.toBytes(QUALIFIER_PREFIX + expectedQualifiers[i]), (long)expectedQualifiers[i].intValue(), Bytes.toBytes(VALUE_PREFIX + expectedQualifiers[i])));
        }
        Scan scan = new Scan(get);
        ArrayList<Cell> actualValues = new ArrayList<Cell>();
        ArrayList<Cell> temp = new ArrayList<Cell>();
        RegionScanner scanner = this.region.getScanner(scan);
        while (scanner.next(temp)) {
            actualValues.addAll(temp);
            temp.clear();
        }
        actualValues.addAll(temp);
        Assert.assertTrue((String)("Actual values " + actualValues + " differ from the expected values:" + expectedValues), (boolean)((Object)expectedValues).equals(actualValues));
    }

    @After
    public void tearDown() throws Exception {
        HLog hlog = this.region.getLog();
        this.region.close();
        hlog.closeAndDelete();
    }

    private static class InvocationRecordFilter
    extends FilterBase {
        private List<Cell> visitedKeyValues = new ArrayList<Cell>();

        private InvocationRecordFilter() {
        }

        @Override
        public void reset() {
            this.visitedKeyValues.clear();
        }

        @Override
        public Filter.ReturnCode filterKeyValue(Cell ignored) {
            this.visitedKeyValues.add(ignored);
            return Filter.ReturnCode.INCLUDE;
        }

        @Override
        public void filterRowCells(List<Cell> kvs) {
            kvs.clear();
            kvs.addAll(this.visitedKeyValues);
        }

        @Override
        public boolean hasFilterRow() {
            return true;
        }
    }
}

